/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class LaneValidator
implements IModelElementValidator {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        LaneSymbol lane = (LaneSymbol)element;
        if (this.findDuplicateId(lane)) {
            result.add(Issue.error((EObject)lane, MessageFormat.format(Validation_Messages.MSG_DuplicateIdUsed, lane.getId()), ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        }
        if (lane.getParticipantReference() != null) {
            for (ActivitySymbolType activitySymbol : lane.getActivitySymbol()) {
                ActivityType activity = activitySymbol.getActivity();
                if (activity == null || !ActivityUtil.isInteractive((ActivityType)activity) || activity.getPerformer() == null || lane.getParticipantReference() == activity.getPerformer()) continue;
                result.add(Issue.warning((EObject)activity, MessageFormat.format(Validation_Messages.MSG_OverriddenLaneParticipant, lane.getParticipantReference().getId(), activity.getPerformer().getId()), ValidationService.PKG_CWM.getActivityType_Performer()));
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private boolean findDuplicateId(LaneSymbol lane) {
        PoolSymbol pool = lane.getParentPool();
        for (LaneSymbol otherLane : pool.getLanes()) {
            if (lane.equals(otherLane) || otherLane.getId() == null || !otherLane.getId().equals(lane.getId())) continue;
            return true;
        }
        return false;
    }
}

