/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class PoolValidator
implements IModelElementValidator {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        PoolSymbol pool = (PoolSymbol)element;
        if (this.findDuplicateId(pool)) {
            result.add(Issue.error((EObject)pool, MessageFormat.format(Validation_Messages.MSG_DuplicateIdUsed, pool.getId()), ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        }
        ValidationService vs = ValidationService.getInstance();
        result.addAll(Arrays.asList(vs.validateModelElements((List<?>)pool.getLanes())));
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private boolean findDuplicateId(PoolSymbol pool) {
        for (PoolSymbol otherPool : ModelUtils.findContainingDiagram((IGraphicalObject)pool).getPoolSymbols()) {
            if (pool.equals(otherPool) || otherPool.getId() == null || !otherPool.getId().equals(pool.getId())) continue;
            return true;
        }
        return false;
    }
}

