/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.Code;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.validation.IModelValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class QualityAssuranceCodeValidator
implements IModelValidator {
    @Override
    public Issue[] validate(ModelType model) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        if (model.getQualityControl() != null) {
            EList codes = model.getQualityControl().getCode();
            for (Code code : codes) {
                String id = code.getCode();
                if (StringUtils.isEmpty((String)id)) {
                    result.add(Issue.error((EObject)code, Validation_Messages.ERR_ELEMENT_EmptyId, ValidationService.PKG_CWM.getCode_Code()));
                    continue;
                }
                if (!ModelUtils.isValidId((String)id)) {
                    result.add(Issue.error((EObject)code, MessageFormat.format(Validation_Messages.ERR_ELEMENT_InvalidId, id), ValidationService.PKG_CWM.getCode_Code()));
                    continue;
                }
                if (!this.isDuplicate(code)) continue;
                result.add(Issue.error((EObject)code, MessageFormat.format(Validation_Messages.MSG_DuplicateIdUsed, id), ValidationService.PKG_CWM.getCode_Code()));
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private boolean isDuplicate(Code code) {
        ModelType model = ModelUtils.findContainingModel((EObject)code);
        EList codes = model.getQualityControl().getCode();
        for (Code current : codes) {
            if (current.equals(code) || StringUtils.isEmpty((String)code.getCode()) || !code.getCode().equals(current.getCode())) continue;
            return true;
        }
        return false;
    }
}

