/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.IModelParticipantUtils;

public class RoleValidator
implements IModelElementValidator {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        RoleType role = (RoleType)element;
        if (IModelParticipantUtils.isDuplicateId((IModelParticipant)role)) {
            result.add(Issue.error((EObject)role, Validation_Messages.ERR_ROLE_DuplicateId, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        }
        if (role.getId().equals("Administrator")) {
            if (this.isAdministratorConnectedToOrganization(role)) {
                result.add(Issue.error((EObject)role, Validation_Messages.ERR_ROLE_Administrator, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
            }
        } else {
            if (RoleValidator.worksForAnyOrganization((IModelParticipant)role) > 0 && this.managerOfAnyOrganization(role) > 0) {
                result.add(Issue.error((EObject)role, Validation_Messages.ERR_ROLE_WorksForManagerOf, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
            }
            if (RoleValidator.worksForAnyOrganization((IModelParticipant)role) > 1) {
                result.add(Issue.error((EObject)role, Validation_Messages.ERR_ROLE_WorksFor, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
            }
            if (this.managerOfAnyOrganization(role) > 1) {
                result.add(Issue.error((EObject)role, Validation_Messages.ERR_ROLE_ManagerOf, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    public static int worksForAnyOrganization(IModelParticipant role) {
        int cnt = 0;
        for (OrganizationType organization : ModelUtils.findContainingModel((EObject)role).getOrganization()) {
            for (ParticipantType participant : organization.getParticipant()) {
                IModelParticipant childParticipant = participant.getParticipant();
                if (!childParticipant.equals(role)) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    public int managerOfAnyOrganization(RoleType role) {
        int cnt = 0;
        for (OrganizationType organization : ModelUtils.findContainingModel((EObject)role).getOrganization()) {
            RoleType teamLead = organization.getTeamLead();
            if (teamLead == null || !teamLead.equals(role)) continue;
            ++cnt;
        }
        return cnt;
    }

    public boolean isAdministratorConnectedToOrganization(RoleType administrator) {
        for (OrganizationType organization : ModelUtils.findContainingModel((EObject)administrator).getOrganization()) {
            RoleType teamLead = organization.getTeamLead();
            if (teamLead != null && teamLead.equals(administrator)) {
                return true;
            }
            for (ParticipantType participant : organization.getParticipant()) {
                IModelParticipant childParticipant = participant.getParticipant();
                if (!childParticipant.equals(administrator)) continue;
                return true;
            }
        }
        return false;
    }
}

