/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.actionTypes;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.extensions.actions.delegate.TargetWorklist;
import org.eclipse.stardust.model.xpdl.carnot.EventActionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class DelegateActivityActionValidator
implements IModelElementValidator {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        if (element instanceof EventActionType) {
            EventActionType action = (EventActionType)element;
            String targetWorklist = AttributeUtil.getAttributeValue((IExtensibleElement)action, (String)"carnot:engine:targetWorklist");
            if (TargetWorklist.Participant.getId().equals(targetWorklist)) {
                String participantId = AttributeUtil.getAttributeValue((IExtensibleElement)action, (String)"carnot:engine:target");
                if (StringUtils.isEmpty((String)participantId)) {
                    result.add(Issue.error((EObject)action, Validation_Messages.DelegateActivity_MissingParticipantId, "carnot:engine:target"));
                } else {
                    ModelType model = ModelUtils.findContainingModel((EObject)action);
                    if (model != null) {
                        IModelParticipant participant = (IModelParticipant)ModelUtils.findIdentifiableElement((List)model.getRole(), (String)participantId);
                        if (participant == null) {
                            participant = (IModelParticipant)ModelUtils.findIdentifiableElement((List)model.getOrganization(), (String)participantId);
                        }
                        if (participant == null) {
                            participant = (IModelParticipant)ModelUtils.findIdentifiableElement((List)model.getConditionalPerformer(), (String)participantId);
                        }
                        if (participant == null) {
                            result.add(Issue.error((EObject)action, MessageFormat.format(Validation_Messages.DelegateActivity_InvalidParticipantId, participantId), "carnot:engine:target"));
                        }
                    }
                }
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }
}

