/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.util;

import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.modeling.validation.ExtensionDescriptor;

public class ExtensionsResolver {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isMatchingElement(EObject element, String classAttributeName, Map<String, String> filterValues, ExtensionDescriptor template) {
        try {
            if (!template.isMatchingClass(element, classAttributeName)) return false;
            IConfigurationElement[] filters = template.getFilters();
            for (Map.Entry<String, String> entry : filterValues.entrySet()) {
                if (SpiExtensionRegistry.matchFilter((IConfigurationElement[])filters, (String)entry.getKey(), (String)entry.getValue())) continue;
                return false;
            }
            int j = 0;
            while (j < filters.length) {
                boolean notOperator = false;
                String name = filters[j].getAttribute("name");
                String value = filters[j].getAttribute("value");
                if (name.startsWith("!")) {
                    notOperator = true;
                    name = name.substring(1);
                }
                if ("metaType".equals(name)) {
                    if (!(element instanceof ITypedElement)) {
                        return false;
                    }
                    IMetaType metaType = ((ITypedElement)element).getMetaType();
                    if (!SpiExtensionRegistry.matchFilterValue((boolean)notOperator, (String)(metaType == null ? null : metaType.getId()), (String)value)) {
                        return false;
                    }
                }
                if (name.startsWith("feature:")) {
                    String featureName = name.substring("feature:".length());
                    Object featureValue = SpiExtensionRegistry.getFeatureValue((EObject)element, (String)featureName);
                    if (featureValue == null) {
                        return false;
                    }
                    if (!SpiExtensionRegistry.matchFilterValue((boolean)notOperator, (String)(featureValue == null ? null : featureValue.toString()), (String)value)) {
                        return false;
                    }
                }
                ++j;
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return false;
    }

    private ExtensionsResolver() {
    }
}

