/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IDropToFrameHandler;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.tcf.internal.debug.actions.TCFActionStepOut;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.internal.debug.ui.model.TCFRunnable;
import org.eclipse.tcf.services.IBreakpoints;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.services.IStackTrace;
import org.eclipse.tcf.util.TCFDataCache;

public class DropToFrameCommand
implements IDropToFrameHandler {
    private final TCFModel model;

    public DropToFrameCommand(TCFModel tcfModel) {
        this.model = tcfModel;
    }

    public void canExecute(final IEnabledStateRequest request) {
        new TCFRunnable(this.model, (IRequest)request){

            @Override
            public void run() {
                Object[] elements = request.getElements();
                if (elements.length != 1 || !(elements[0] instanceof TCFNodeStackFrame)) {
                    request.setEnabled(false);
                    this.done();
                    return;
                }
                TCFNodeStackFrame frameNode = (TCFNodeStackFrame)elements[0];
                TCFNodeExecContext exeNode = (TCFNodeExecContext)frameNode.getParent();
                if (!exeNode.getStackTrace().validate(this)) {
                    return;
                }
                if (frameNode.getFrameNo() < 1) {
                    request.setEnabled(false);
                    this.done();
                    return;
                }
                TCFDataCache<IRunControl.RunControlContext> ctx_cache = exeNode.getRunContext();
                if (!ctx_cache.validate((Runnable)this)) {
                    return;
                }
                IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)ctx_cache.getData();
                if (!this.canStepOut(ctx)) {
                    request.setEnabled(false);
                    this.done();
                    return;
                }
                int action_cnt = DropToFrameCommand.this.model.getLaunch().getContextActionsCount(ctx.getID());
                if (action_cnt > 0 || !this.canStepOut(ctx)) {
                    request.setEnabled(false);
                    this.done();
                    return;
                }
                TCFDataCache<TCFContextState> state_cache = exeNode.getState();
                if (!state_cache.validate((Runnable)this)) {
                    return;
                }
                TCFContextState state_data = (TCFContextState)state_cache.getData();
                request.setEnabled(state_data != null && state_data.is_suspended);
                this.done();
            }

            private boolean canStepOut(IRunControl.RunControlContext ctx) {
                if (ctx == null) {
                    return false;
                }
                if (ctx.canResume(5)) {
                    return true;
                }
                if (!ctx.hasState()) {
                    return false;
                }
                return ctx.canResume(0) && DropToFrameCommand.this.model.getLaunch().getService(IBreakpoints.class) != null;
            }
        };
    }

    public boolean execute(final IDebugCommandRequest request) {
        new TCFRunnable(this.model, (IRequest)request){

            @Override
            public void run() {
                Object[] elements = request.getElements();
                if (elements.length != 1 || !(elements[0] instanceof TCFNodeStackFrame)) {
                    request.setStatus(Status.CANCEL_STATUS);
                    this.done();
                    return;
                }
                TCFNodeStackFrame frameNode = (TCFNodeStackFrame)elements[0];
                TCFNodeExecContext exeNode = (TCFNodeExecContext)frameNode.getParent();
                if (!exeNode.getStackTrace().validate(this)) {
                    return;
                }
                int frameNo = frameNode.getFrameNo();
                if (frameNo < 1) {
                    request.setStatus(Status.CANCEL_STATUS);
                    this.done();
                    return;
                }
                TCFDataCache<IRunControl.RunControlContext> ctx_cache = exeNode.getRunContext();
                if (!ctx_cache.validate((Runnable)this)) {
                    return;
                }
                TCFDataCache<TCFContextState> state_cache = exeNode.getState();
                if (!state_cache.validate((Runnable)this)) {
                    return;
                }
                TCFContextState state_data = (TCFContextState)state_cache.getData();
                if (state_data == null || !state_data.is_suspended) {
                    request.setStatus(Status.CANCEL_STATUS);
                    this.done();
                    return;
                }
                Map stack = (Map)exeNode.getStackTrace().getData();
                for (TCFNode node : stack.values()) {
                    TCFNodeStackFrame frame_to_step_out = (TCFNodeStackFrame)node;
                    if (frame_to_step_out.getFrameNo() != frameNo - 1) continue;
                    new StepStateMachine(DropToFrameCommand.this.model, request, (IRunControl.RunControlContext)ctx_cache.getData(), frame_to_step_out, new Runnable(){

                        @Override
                        public void run() {
                            request.done();
                        }
                    });
                    return;
                }
                request.setStatus(Status.CANCEL_STATUS);
                this.done();
            }
        };
        return false;
    }

    private static class StepStateMachine
    extends TCFActionStepOut {
        private final IDebugCommandRequest monitor;
        private final Runnable done;
        private final TCFNodeExecContext node;
        private final TCFNodeStackFrame frame;

        StepStateMachine(TCFModel model, IDebugCommandRequest monitor, IRunControl.RunControlContext ctx, TCFNodeStackFrame frame, Runnable done) {
            super(model.getLaunch(), ctx, false);
            this.monitor = monitor;
            this.done = done;
            this.frame = frame;
            this.node = (TCFNodeExecContext)frame.getParent();
        }

        protected TCFDataCache<TCFContextState> getContextState() {
            return this.node.getState();
        }

        protected TCFDataCache<IStackTrace.StackTraceContext> getStackFrame() {
            return this.frame.getStackTraceContext();
        }

        protected int getStackFrameIndex() {
            return this.frame.getFrameNo();
        }

        protected TCFDataCache<?> getStackTrace() {
            return this.node.getStackTrace();
        }

        protected void exit(Throwable error) {
            this.exit(error, "Drop To Frame");
        }

        protected void exit(Throwable error, String reason) {
            if (this.exited) {
                return;
            }
            super.exit(error, reason);
            if (error != null && this.node.getChannel().getState() == 1) {
                this.monitor.setStatus((IStatus)new Status(4, "org.eclipse.tcf.debug.ui", 0, "Cannot drop to frame: " + error.getLocalizedMessage(), error));
            }
            if (this.aborted) {
                this.monitor.setStatus(Status.CANCEL_STATUS);
            }
            this.done.run();
        }
    }
}

