/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tcf.core.ErrorReport;
import org.eclipse.tcf.internal.debug.launch.TCFLaunchDelegate;
import org.eclipse.tcf.internal.debug.launch.TCFSourceLookupDirector;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.model.TCFMemoryRegion;
import org.eclipse.tcf.internal.debug.model.TCFSymFileRef;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ColorCache;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.commands.MemoryMapItemDialog;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeLaunch;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IMemory;
import org.eclipse.tcf.services.IMemoryMap;
import org.eclipse.tcf.services.IPathMap;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.PlatformUI;

public class MemoryMapWidget {
    private static final int SIZING_TABLE_WIDTH = 500;
    private static final int SIZING_TABLE_HEIGHT = 300;
    private static final String[] column_names = new String[]{"File", "Address", "Size", "Flags", "File offset/section"};
    private TCFModel model;
    private IChannel channel;
    private TCFNode selection;
    private final IMemoryMap.MemoryMapListener listener = new MemoryMapListener();
    private Combo ctx_text;
    private Tree map_table;
    private TreeViewer table_viewer;
    private Runnable update_map_buttons;
    private final Map<String, ArrayList<IMemoryMap.MemoryRegion>> org_maps = new HashMap<String, ArrayList<IMemoryMap.MemoryRegion>>();
    private final Map<String, ArrayList<IMemoryMap.MemoryRegion>> cur_maps = new HashMap<String, ArrayList<IMemoryMap.MemoryRegion>>();
    private final ArrayList<IMemoryMap.MemoryRegion> target_map = new ArrayList();
    private final HashMap<String, TCFNodeExecContext> target_map_nodes = new HashMap();
    private TCFNodeExecContext selected_mem_map_node;
    private IMemory.MemoryContext mem_ctx;
    private ILaunchConfiguration cfg;
    private final HashSet<String> loaded_files = new HashSet();
    private String selected_mem_map_id;
    private final ArrayList<ModifyListener> modify_listeners = new ArrayList();
    private Color cError = null;
    private boolean disposed = false;
    private final ITreeContentProvider content_provider = new ITreeContentProvider(){

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IMemoryMap.MemoryRegion) {
                IMemoryMap.MemoryRegion region = (IMemoryMap.MemoryRegion)element;
                return region.getProperties().containsKey("_CHILDREN");
            }
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object input) {
            ArrayList all = new ArrayList();
            ArrayList lst = (ArrayList)MemoryMapWidget.this.cur_maps.get(input);
            if (lst != null) {
                all.addAll(lst);
            }
            all.addAll(MemoryMapWidget.this.target_map);
            ArrayList<Object> roots = new ArrayList<Object>();
            ArrayList<IMemoryMap.MemoryRegion> removed = new ArrayList<IMemoryMap.MemoryRegion>();
            int i = 0;
            while (i < all.size()) {
                IMemoryMap.MemoryRegion region1 = (IMemoryMap.MemoryRegion)all.get(i);
                boolean multiple = false;
                ArrayList<IMemoryMap.MemoryRegion> children = new ArrayList<IMemoryMap.MemoryRegion>();
                int j = i + 1;
                while (j < all.size()) {
                    IMemoryMap.MemoryRegion region2 = (IMemoryMap.MemoryRegion)all.get(j);
                    if (!region1.equals(region2) && region1.getFileName().equals(region2.getFileName())) {
                        multiple = true;
                        children.add(region2);
                        removed.add(region2);
                    }
                    ++j;
                }
                if (!removed.contains(region1)) {
                    if (multiple) {
                        children.add(0, region1);
                        removed.add(region1);
                        HashMap<String, Object> props = new HashMap<String, Object>();
                        props.put("FileName", region1.getFileName());
                        props.put("_CHILDREN", children.toArray());
                        TCFMemoryRegion region = new TCFMemoryRegion(props);
                        roots.add(region);
                    } else {
                        roots.add(region1);
                    }
                }
                ++i;
            }
            return roots.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IMemoryMap.MemoryRegion) {
                IMemoryMap.MemoryRegion region = (IMemoryMap.MemoryRegion)parentElement;
                return (Object[])region.getProperties().get("_CHILDREN");
            }
            return null;
        }
    };

    public MemoryMapWidget(Composite composite, TCFNode node) {
        this.setTCFNode(node);
        this.createContextText(composite);
        this.createMemoryMapTable(composite);
        this.cError = new Color((Device)composite.getDisplay(), ColorCache.rgb_error);
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.cError != null) {
            this.cError.dispose();
            this.cError = null;
        }
        if (this.channel != null) {
            final IChannel c = this.channel;
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IMemoryMap svc = (IMemoryMap)c.getRemoteService(IMemoryMap.class);
                    if (svc != null) {
                        svc.removeListener(MemoryMapWidget.this.listener);
                    }
                }
            });
        }
    }

    public boolean setTCFNode(TCFNode node) {
        IChannel c;
        if (node == null && this.selection == null || node != null && node.equals(this.selection)) {
            return false;
        }
        if (this.channel != null && this.channel.getState() == 1) {
            c = this.channel;
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IMemoryMap svc = (IMemoryMap)c.getRemoteService(IMemoryMap.class);
                    if (svc != null) {
                        svc.removeListener(MemoryMapWidget.this.listener);
                    }
                }
            });
        }
        if (node != null) {
            this.model = node.getModel();
            this.channel = node.getChannel();
            this.selection = node;
            if (this.channel != null && this.channel.getState() == 1) {
                c = this.channel;
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IMemoryMap svc = (IMemoryMap)c.getRemoteService(IMemoryMap.class);
                        if (svc != null) {
                            svc.addListener(MemoryMapWidget.this.listener);
                        }
                    }
                });
            }
        } else {
            this.model = null;
            this.channel = null;
            this.selection = null;
        }
        return true;
    }

    public String getMemoryMapID() {
        return this.selected_mem_map_id;
    }

    private void createContextText(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label props_label = new Label(composite, 64);
        props_label.setLayoutData((Object)new GridData(256));
        props_label.setFont(font);
        props_label.setText("&Debug context:");
        this.ctx_text = new Combo(composite, 2060);
        this.ctx_text.setLayoutData((Object)new GridData(768));
        this.ctx_text.setFont(font);
        this.ctx_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MemoryMapWidget.this.selected_mem_map_id = MemoryMapWidget.this.ctx_text.getText();
                MemoryMapWidget.this.selected_mem_map_node = (TCFNodeExecContext)MemoryMapWidget.this.target_map_nodes.get(MemoryMapWidget.this.selected_mem_map_id);
                MemoryMapWidget.this.loadTargetMemoryMap();
                MemoryMapWidget.this.table_viewer.setInput((Object)MemoryMapWidget.this.selected_mem_map_id);
                if (MemoryMapWidget.this.selected_mem_map_id.length() == 0) {
                    MemoryMapWidget.this.selected_mem_map_id = null;
                }
                MemoryMapWidget.this.update_map_buttons.run();
            }
        });
    }

    private void createMemoryMapTable(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.map_table = new Tree(composite, 68356);
        this.map_table.setFont(font);
        this.configureTable(this.map_table);
        this.map_table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                IMemoryMap.MemoryRegion r = (IMemoryMap.MemoryRegion)((IStructuredSelection)MemoryMapWidget.this.table_viewer.getSelection()).getFirstElement();
                if (r == null) {
                    return;
                }
                MemoryMapWidget.this.editRegion(r);
            }

            public void widgetSelected(SelectionEvent e) {
                MemoryMapWidget.this.update_map_buttons.run();
            }
        });
        this.table_viewer = new TreeViewer(this.map_table);
        this.table_viewer.setUseHashlookup(true);
        this.table_viewer.setColumnProperties(column_names);
        this.table_viewer.setContentProvider((IContentProvider)this.content_provider);
        this.table_viewer.setLabelProvider((IBaseLabelProvider)new MapLabelProvider());
        this.map_table.pack();
        this.createMapButtons(composite);
    }

    protected String getColumnText(int column) {
        if (column < column_names.length && column >= 0) {
            return column_names[column];
        }
        return "";
    }

    protected void configureTable(final Tree table) {
        GridData data = new GridData(1808);
        data.widthHint = 500;
        data.heightHint = 300;
        table.setLayoutData((Object)data);
        final TreeColumn colFile = new TreeColumn(table, 0);
        colFile.setResizable(true);
        colFile.setAlignment(16384);
        colFile.setText(this.getColumnText(0));
        final TreeColumn colAddr = new TreeColumn(table, 1);
        colAddr.setResizable(true);
        colAddr.setAlignment(16384);
        colAddr.setText(this.getColumnText(1));
        final TreeColumn colSize = new TreeColumn(table, 2);
        colSize.setResizable(true);
        colSize.setAlignment(16384);
        colSize.setText(this.getColumnText(2));
        final TreeColumn colFlags = new TreeColumn(table, 3);
        colFlags.setResizable(true);
        colFlags.setAlignment(16384);
        colFlags.setText(this.getColumnText(3));
        final TreeColumn colOffset = new TreeColumn(table, 4);
        colOffset.setResizable(true);
        colOffset.setAlignment(16384);
        colOffset.setText(this.getColumnText(4));
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(150));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(90));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(90));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(50));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(140));
        table.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int width = table.getSize().x - 4 - colAddr.getWidth() - colSize.getWidth() - colFlags.getWidth() - colOffset.getWidth();
                colFile.setWidth(Math.max(width, 100));
            }
        });
        colFile.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int colWidth = colFile.getWidth();
                if (colWidth < 100) {
                    event.doit = false;
                    colFile.setWidth(100);
                }
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn col;
                int colWidth;
                if (event.widget instanceof TableColumn && (colWidth = (col = (TableColumn)event.widget).getWidth()) < 40) {
                    event.doit = false;
                    col.setWidth(40);
                }
            }
        };
        colAddr.addListener(11, listener);
        colSize.addListener(11, listener);
        colFlags.addListener(11, listener);
        colOffset.addListener(11, listener);
        table.setToolTipText("");
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TreeItem)label.getData("_TABLEITEM");
                        table.setSelection(new TreeItem[]{(TreeItem)e.item});
                        table.notifyListeners(13, e);
                        shell.dispose();
                        table.setFocus();
                        break;
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
        Listener tableListener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        TreeItem item = table.getItem(new Point(event.x, event.y));
                        if (item == null || !(item.getData("_TOOLTIP") instanceof String)) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        this.tip = new Shell(table.getShell(), 540676);
                        this.tip.setBackground(table.getDisplay().getSystemColor(29));
                        FillLayout layout = new FillLayout();
                        layout.marginWidth = 2;
                        this.tip.setLayout((Layout)layout);
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(table.getDisplay().getSystemColor(28));
                        this.label.setBackground(table.getDisplay().getSystemColor(29));
                        this.label.setData("_TABLEITEM", (Object)item);
                        this.label.setText((String)item.getData("_TOOLTIP"));
                        this.label.addListener(7, labelListener);
                        this.label.addListener(3, labelListener);
                        Point size = this.tip.computeSize(-1, -1);
                        Point pt = table.toDisplay(event.x - 20, event.y - size.y);
                        this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                        this.tip.setVisible(true);
                    }
                }
            }
        };
        table.addListener(12, tableListener);
        table.addListener(1, tableListener);
        table.addListener(5, tableListener);
        table.addListener(32, tableListener);
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    protected final TreeViewer getViewer() {
        return this.table_viewer;
    }

    private void createMapButtons(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        Menu menu = new Menu((Control)this.map_table);
        SelectionAdapter sel_adapter = null;
        final Button button_add = new Button(composite, 8);
        button_add.setText(" &Add... ");
        GridData gd = new GridData(256);
        PixelConverter converter = new PixelConverter((Control)button_add);
        gd.widthHint = converter.convertHorizontalDLUsToPixels(61);
        button_add.setLayoutData((Object)gd);
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String id = MemoryMapWidget.this.ctx_text.getText();
                if (id == null || id.length() == 0) {
                    return;
                }
                HashMap<String, Object> props = new HashMap<String, Object>();
                Image image = ImageCache.getImage("icons/memory-map.gif");
                if (new MemoryMapItemDialog(MemoryMapWidget.this.map_table.getShell(), image, props, true).open() == 0) {
                    props.put("ID", id);
                    ArrayList<TCFMemoryRegion> lst = (ArrayList<TCFMemoryRegion>)MemoryMapWidget.this.cur_maps.get(id);
                    if (lst == null) {
                        lst = new ArrayList<TCFMemoryRegion>();
                        MemoryMapWidget.this.cur_maps.put(id, lst);
                    }
                    lst.add(new TCFMemoryRegion(props));
                    MemoryMapWidget.this.table_viewer.refresh();
                    MemoryMapWidget.this.notifyModifyListeners();
                }
            }
        };
        button_add.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_add = new MenuItem(menu, 8);
        item_add.setText("&Add...");
        item_add.addSelectionListener((SelectionListener)sel_adapter);
        item_add.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        final Button button_edit = new Button(composite, 8);
        button_edit.setText(" E&dit... ");
        button_edit.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IMemoryMap.MemoryRegion r = (IMemoryMap.MemoryRegion)((IStructuredSelection)MemoryMapWidget.this.table_viewer.getSelection()).getFirstElement();
                if (r == null) {
                    return;
                }
                MemoryMapWidget.this.editRegion(r);
            }
        };
        button_edit.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_edit = new MenuItem(menu, 8);
        item_edit.setText("E&dit...");
        item_edit.addSelectionListener((SelectionListener)sel_adapter);
        final Button button_remove = new Button(composite, 8);
        button_remove.setText(" &Remove ");
        button_remove.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String id = MemoryMapWidget.this.ctx_text.getText();
                if (id == null || id.length() == 0) {
                    return;
                }
                IMemoryMap.MemoryRegion r = (IMemoryMap.MemoryRegion)((IStructuredSelection)MemoryMapWidget.this.table_viewer.getSelection()).getFirstElement();
                if (r == null) {
                    return;
                }
                ArrayList lst = (ArrayList)MemoryMapWidget.this.cur_maps.get(id);
                if (lst != null && lst.remove(r)) {
                    MemoryMapWidget.this.table_viewer.refresh();
                }
                MemoryMapWidget.this.notifyModifyListeners();
            }
        };
        button_remove.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_remove = new MenuItem(menu, 8);
        item_remove.setText("&Remove");
        item_remove.addSelectionListener((SelectionListener)sel_adapter);
        item_remove.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_DELETE"));
        final Button button_locate = new Button(composite, 72);
        button_locate.setText(" Locate Symbol File... ");
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 50;
        button_locate.setLayoutData((Object)layoutData);
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String id = MemoryMapWidget.this.ctx_text.getText();
                if (id == null || id.length() == 0) {
                    return;
                }
                IMemoryMap.MemoryRegion r = (IMemoryMap.MemoryRegion)((IStructuredSelection)MemoryMapWidget.this.table_viewer.getSelection()).getFirstElement();
                if (r == null) {
                    return;
                }
                MemoryMapWidget.this.locateSymbolFile(r);
            }
        };
        button_locate.addSelectionListener((SelectionListener)sel_adapter);
        new MenuItem(menu, 2);
        final MenuItem item_locate = new MenuItem(menu, 8);
        item_locate.setText("Locate Symbol File...");
        item_locate.addSelectionListener((SelectionListener)sel_adapter);
        this.map_table.setMenu(menu);
        this.update_map_buttons = new Runnable(){

            @Override
            public void run() {
                IMemoryMap.MemoryRegion r = (IMemoryMap.MemoryRegion)((IStructuredSelection)MemoryMapWidget.this.table_viewer.getSelection()).getFirstElement();
                boolean manual = r != null && r.getProperties().get("ID") != null;
                button_add.setEnabled(MemoryMapWidget.this.selected_mem_map_id != null);
                button_edit.setEnabled(r != null && !r.getProperties().containsKey("_CHILDREN"));
                button_remove.setEnabled(manual);
                item_add.setEnabled(MemoryMapWidget.this.selected_mem_map_id != null);
                item_edit.setEnabled(r != null && !r.getProperties().containsKey("_CHILDREN"));
                item_remove.setEnabled(manual);
                String symbolFileInfo = MemoryMapWidget.this.getSymbolFileInfo(r);
                boolean enabled = symbolFileInfo != null && symbolFileInfo.contains("Symbol file error:") && r.getFileName() != null;
                button_locate.setEnabled(enabled);
                item_locate.setEnabled(enabled);
            }
        };
        this.update_map_buttons.run();
    }

    private void editRegion(IMemoryMap.MemoryRegion r) {
        ArrayList<IMemoryMap.MemoryRegion> lst;
        boolean enable_editing;
        String id = this.ctx_text.getText();
        if (id == null || id.length() == 0) {
            return;
        }
        HashMap<String, Object> props = r.getProperties();
        boolean bl = enable_editing = props.get("ID") != null;
        if (enable_editing) {
            props = new HashMap<String, Object>(props);
        }
        Image image = ImageCache.getImage("icons/memory-map.gif");
        if (new MemoryMapItemDialog(this.map_table.getShell(), image, props, enable_editing).open() == 0 && enable_editing && (lst = this.cur_maps.get(id)) != null) {
            int n = 0;
            while (n < lst.size()) {
                if (lst.get(n) == r) {
                    lst.set(n, (IMemoryMap.MemoryRegion)new TCFMemoryRegion(props));
                    this.table_viewer.refresh();
                    this.notifyModifyListeners();
                }
                ++n;
            }
        }
    }

    private void locateSymbolFile(IMemoryMap.MemoryRegion r) {
        Assert.isNotNull((Object)r);
        HashMap props = new HashMap(r.getProperties());
        FileDialog dialog = new FileDialog(this.map_table.getShell(), 4096);
        IPath workSpacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        dialog.setFilterPath(workSpacePath.toString());
        dialog.setText("Locate Symbol File");
        String symbolFile = dialog.open();
        if (symbolFile != null && new File(symbolFile).exists()) {
            LinkedHashMap properties = new LinkedHashMap();
            properties.put("Source", props.get("FileName"));
            properties.put("Destination", symbolFile);
            TCFLaunchDelegate.PathMapRule rule = new TCFLaunchDelegate.PathMapRule(properties);
            if (this.cfg != null) {
                try {
                    ILaunchConfigurationWorkingCopy wc = this.cfg instanceof ILaunchConfigurationWorkingCopy ? (ILaunchConfigurationWorkingCopy)this.cfg : this.cfg.getWorkingCopy();
                    String s = wc.getAttribute("org.eclipse.tcf.debug.PathMap", "");
                    ArrayList map = TCFLaunchDelegate.parsePathMapAttribute((String)s);
                    map.add(0, rule);
                    StringBuilder bf = new StringBuilder();
                    for (IPathMap.PathMapRule m : map) {
                        bf.append(m.toString());
                    }
                    if (bf.length() == 0) {
                        wc.removeAttribute("org.eclipse.tcf.debug.PathMap");
                    } else {
                        wc.setAttribute("org.eclipse.tcf.debug.PathMap", bf.toString());
                    }
                    if (wc.isDirty()) {
                        wc.doSave();
                    }
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
            }
        }
    }

    private void readMemoryMapAttribute() {
        this.cur_maps.clear();
        try {
            new TCFTask<Boolean>(){

                public void run() {
                    try {
                        TCFLaunchDelegate.getMemMapsAttribute((Map)MemoryMapWidget.this.cur_maps, (ILaunchConfiguration)MemoryMapWidget.this.cfg);
                        this.done(true);
                    }
                    catch (Exception e) {
                        this.error(e);
                    }
                }
            }.get();
        }
        catch (Exception x) {
            Activator.log("Invalid launch cofiguration attribute", x);
        }
    }

    private void writeMemoryMapAttribute(ILaunchConfigurationWorkingCopy copy) throws Exception {
        String s = null;
        final ArrayList<Map> lst = new ArrayList<Map>();
        for (ArrayList<IMemoryMap.MemoryRegion> x : this.cur_maps.values()) {
            for (IMemoryMap.MemoryRegion r : x) {
                lst.add(r.getProperties());
            }
        }
        if (lst.size() > 0) {
            s = (String)new TCFTask<String>(){

                public void run() {
                    try {
                        this.done(JSON.toJSON((Object)lst));
                    }
                    catch (IOException e) {
                        this.error(e);
                    }
                }
            }.getIO();
        }
        copy.setAttribute("org.eclipse.tcf.debug.MemoryMap", s);
    }

    public void loadData(ILaunchConfiguration cfg) {
        this.cfg = cfg;
        this.cur_maps.clear();
        this.org_maps.clear();
        this.loadTargetMemoryNodes();
        this.readMemoryMapAttribute();
        for (String id : this.cur_maps.keySet()) {
            this.org_maps.put(id, new ArrayList(this.cur_maps.get(id)));
        }
        Object map_id = this.getSelectedMemoryNode();
        HashSet<String> ids = new HashSet<String>(this.target_map_nodes.keySet());
        if (map_id != null) {
            ids.add((String)map_id);
        }
        ids.addAll(this.cur_maps.keySet());
        Object[] arr = ids.toArray(new String[ids.size()]);
        Arrays.sort(arr);
        this.ctx_text.removeAll();
        Object[] objectArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            this.ctx_text.add((String)id);
            ++n2;
        }
        if (map_id == null && arr.length > 0) {
            map_id = arr[0];
        }
        if (map_id == null) {
            map_id = "";
        }
        this.ctx_text.setText((String)map_id);
    }

    private String getSelectedMemoryNode() {
        if (this.channel == null || this.channel.getState() != 1) {
            return null;
        }
        try {
            return (String)new TCFTask<String>(this.channel){

                public void run() {
                    TCFDataCache<TCFNodeExecContext> mem_cache = MemoryMapWidget.this.model.searchMemoryContext(MemoryMapWidget.this.selection);
                    if (mem_cache == null) {
                        this.error(new Exception("Context does not provide memory access"));
                        return;
                    }
                    if (!mem_cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    if (mem_cache.getError() != null) {
                        this.error(mem_cache.getError());
                        return;
                    }
                    String id = null;
                    TCFNodeExecContext mem_node = (TCFNodeExecContext)mem_cache.getData();
                    if (mem_node != null) {
                        TCFDataCache<TCFNodeExecContext> syms_cache = mem_node.getSymbolsNode();
                        if (!syms_cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        TCFNodeExecContext syms_node = (TCFNodeExecContext)syms_cache.getData();
                        if (syms_node != null) {
                            TCFDataCache<IMemory.MemoryContext> mem_ctx = syms_node.getMemoryContext();
                            if (!mem_ctx.validate((Runnable)((Object)this))) {
                                return;
                            }
                            if (mem_ctx.getData() != null) {
                                if (syms_node.getModel().getLaunch().isMemoryMapPreloadingSupported()) {
                                    TCFDataCache<String> name_cache = syms_node.getFullName();
                                    if (!name_cache.validate((Runnable)((Object)this))) {
                                        return;
                                    }
                                    id = (String)name_cache.getData();
                                } else {
                                    id = ((IMemory.MemoryContext)mem_ctx.getData()).getName();
                                }
                                if (id == null) {
                                    id = syms_node.getID();
                                }
                            }
                        }
                    }
                    this.done(id);
                }
            }.get();
        }
        catch (Exception exception) {
            if (this.channel.getState() != 1) {
                return null;
            }
            return null;
        }
    }

    private String getSymbolFileInfo(IMemoryMap.MemoryRegion region) {
        if (region != null && region.getProperties().containsKey("_CHILDREN")) {
            region = (IMemoryMap.MemoryRegion)((Object[])region.getProperties().get("_CHILDREN"))[0];
        }
        final IMemoryMap.MemoryRegion r = region;
        if (this.channel == null || this.channel.getState() != 1 || r == null || r.getAddress() == null) {
            return null;
        }
        try {
            String symFileInfo = (String)new TCFTask<String>(this.channel){

                public void run() {
                    TCFDataCache<TCFSymFileRef> sym_cache;
                    if (MemoryMapWidget.this.selected_mem_map_node == null) {
                        this.done(null);
                        return;
                    }
                    TCFDataCache<TCFNodeExecContext> mem_cache = MemoryMapWidget.this.model.searchMemoryContext(MemoryMapWidget.this.selected_mem_map_node);
                    if (mem_cache == null) {
                        this.error(new Exception("Context does not provide memory access"));
                        return;
                    }
                    if (!mem_cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    if (mem_cache.getError() != null) {
                        this.error(mem_cache.getError());
                        return;
                    }
                    StringBuilder symbolFileInfo = new StringBuilder();
                    TCFNodeExecContext mem_node = (TCFNodeExecContext)mem_cache.getData();
                    if (mem_node != null && (sym_cache = mem_node.getSymFileInfo(JSON.toBigInteger((Number)r.getAddress()))) != null) {
                        if (!sym_cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        TCFSymFileRef sym_data = (TCFSymFileRef)sym_cache.getData();
                        if (sym_data != null) {
                            if (sym_data.props != null) {
                                Map map;
                                String sym_file_name = (String)sym_data.props.get("FileName");
                                if (sym_file_name != null && !sym_file_name.equals(r.getFileName())) {
                                    symbolFileInfo.append("Symbol file name: ").append(sym_file_name);
                                }
                                if ((map = (Map)sym_data.props.get("FileError")) != null) {
                                    if (symbolFileInfo.length() > 0) {
                                        symbolFileInfo.append("\n");
                                    }
                                    String msg = TCFModel.getErrorMessage((Throwable)new ErrorReport("", map), false);
                                    symbolFileInfo.append("Symbol file error: ").append(msg);
                                }
                            } else if (sym_data.error == null) {
                                symbolFileInfo.append(r.getFileName());
                                symbolFileInfo.append(", ");
                                symbolFileInfo.append(mem_node.getID());
                            }
                            if (sym_data.error != null) {
                                symbolFileInfo.append("Symbol file error: ").append(TCFModel.getErrorMessage(sym_data.error, false));
                            }
                        }
                    }
                    this.done(symbolFileInfo.length() > 0 ? symbolFileInfo.toString() : null);
                }
            }.get();
            if (symFileInfo != null && symFileInfo.startsWith(r.getFileName())) {
                Object mapped;
                TCFLaunch launch;
                String id = symFileInfo.split(", ")[1];
                symFileInfo = null;
                if (!(new File(r.getFileName()).exists() || (launch = this.findLaunch()) == null || (mapped = TCFSourceLookupDirector.lookup((TCFLaunch)launch, (String)id, (Object)r.getFileName())) instanceof IStorage && ((IStorage)mapped).getFullPath().toFile().exists())) {
                    symFileInfo = "Symbol file error: No such file or directory";
                }
            }
            return symFileInfo;
        }
        catch (Exception x) {
            if (this.channel.getState() != 1) {
                return null;
            }
            Activator.log("Cannot get selected symbol file info", x);
            return null;
        }
    }

    protected TCFLaunch findLaunch() {
        ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof TCFLaunch && launch.getLaunchConfiguration().equals(this.cfg instanceof ILaunchConfigurationWorkingCopy ? ((ILaunchConfigurationWorkingCopy)this.cfg).getOriginal() : this.cfg)) {
                return (TCFLaunch)launch;
            }
            ++n2;
        }
        return null;
    }

    private void loadTargetMemoryNodes() {
        this.target_map_nodes.clear();
        if (this.channel == null || this.channel.getState() != 1) {
            return;
        }
        try {
            new TCFTask<Boolean>(this.channel){

                public void run() {
                    TCFNodeLaunch n = MemoryMapWidget.this.model.getRootNode();
                    if (!this.collectMemoryNodes(n.getFilteredChildren())) {
                        return;
                    }
                    this.done(true);
                }

                private boolean collectMemoryNodes(TCFChildren children) {
                    if (!children.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    Map m = (Map)children.getData();
                    if (m != null) {
                        for (TCFNode n : m.values()) {
                            if (!(n instanceof TCFNodeExecContext)) continue;
                            TCFNodeExecContext exe = (TCFNodeExecContext)n;
                            if (!this.collectMemoryNodes(exe.getChildren())) {
                                return false;
                            }
                            TCFDataCache<TCFNodeExecContext> syms_cache = exe.getSymbolsNode();
                            if (!syms_cache.validate((Runnable)((Object)this))) {
                                return false;
                            }
                            TCFNodeExecContext syms_node = (TCFNodeExecContext)syms_cache.getData();
                            if (syms_node == null) continue;
                            TCFDataCache<IMemory.MemoryContext> mem_ctx = syms_node.getMemoryContext();
                            if (!mem_ctx.validate((Runnable)((Object)this))) {
                                return false;
                            }
                            if (mem_ctx.getData() == null) continue;
                            String id = null;
                            if (syms_node.getModel().getLaunch().isMemoryMapPreloadingSupported()) {
                                TCFDataCache<String> name_cache = syms_node.getFullName();
                                if (!name_cache.validate((Runnable)((Object)this))) {
                                    return false;
                                }
                                id = (String)name_cache.getData();
                            } else {
                                id = ((IMemory.MemoryContext)mem_ctx.getData()).getName();
                            }
                            if (id == null) {
                                id = syms_node.getID();
                            }
                            MemoryMapWidget.this.target_map_nodes.put(id, syms_node);
                        }
                    }
                    return true;
                }
            }.get();
        }
        catch (Exception x) {
            if (this.channel.getState() != 1) {
                return;
            }
            Activator.log("Cannot load target memory context info", x);
        }
    }

    private boolean isLocalEntry(IMemoryMap.MemoryRegion r) {
        if (r == null) {
            return false;
        }
        String f0 = r.getFileName();
        BigInteger a0 = JSON.toBigInteger((Number)r.getAddress());
        ArrayList<IMemoryMap.MemoryRegion> map = this.cur_maps.get(this.selected_mem_map_id);
        if (map == null) {
            return false;
        }
        for (IMemoryMap.MemoryRegion c : map) {
            Number a1;
            String f1 = c.getFileName();
            if (f0 != f1 && (f0 == null || !f0.equals(f1)) || a0 != (a1 = c.getAddress()) && a0 == null) continue;
            return true;
        }
        return false;
    }

    private void loadTargetMemoryMap() {
        this.loaded_files.clear();
        this.target_map.clear();
        this.mem_ctx = null;
        if (this.channel == null || this.channel.getState() != 1) {
            return;
        }
        try {
            new TCFTask<Boolean>(this.channel){

                public void run() {
                    if (MemoryMapWidget.this.selected_mem_map_node != null && !MemoryMapWidget.this.selected_mem_map_node.isDisposed()) {
                        TCFDataCache<IMemory.MemoryContext> mem_cache = MemoryMapWidget.this.selected_mem_map_node.getMemoryContext();
                        if (!mem_cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        if (mem_cache.getError() != null) {
                            this.error(mem_cache.getError());
                            return;
                        }
                        MemoryMapWidget.this.mem_ctx = (IMemory.MemoryContext)mem_cache.getData();
                        TCFDataCache<TCFNodeExecContext.MemoryRegion[]> map_cache = MemoryMapWidget.this.selected_mem_map_node.getMemoryMap();
                        if (!map_cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        if (map_cache.getError() != null) {
                            this.error(map_cache.getError());
                            return;
                        }
                        if (map_cache.getData() != null) {
                            TCFNodeExecContext.MemoryRegion[] memoryRegionArray = (TCFNodeExecContext.MemoryRegion[])map_cache.getData();
                            int n = memoryRegionArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TCFNodeExecContext.MemoryRegion m = memoryRegionArray[n2];
                                if (MemoryMapWidget.this.isLocalEntry(m.region)) {
                                    String fnm = m.region.getFileName();
                                    if (fnm != null) {
                                        MemoryMapWidget.this.loaded_files.add(fnm);
                                    }
                                } else {
                                    MemoryMapWidget.this.target_map.add(new TCFMemoryRegion(m.region.getProperties()));
                                }
                                ++n2;
                            }
                        }
                    }
                    this.done(true);
                }
            }.get();
        }
        catch (Exception x) {
            if (this.channel.getState() != 1) {
                return;
            }
            Activator.log("Cannot load target memory map", x);
        }
    }

    public boolean saveData(ILaunchConfigurationWorkingCopy copy) throws Exception {
        ArrayList<IMemoryMap.MemoryRegion> lst;
        boolean loaded_files_ok = true;
        if (this.selected_mem_map_id != null && (lst = this.cur_maps.get(this.selected_mem_map_id)) != null) {
            for (IMemoryMap.MemoryRegion r : lst) {
                String fnm = r.getFileName();
                if (fnm == null || this.loaded_files.contains(fnm)) continue;
                loaded_files_ok = false;
            }
            if (lst.size() == 0) {
                this.cur_maps.remove(this.selected_mem_map_id);
            }
        }
        if (!loaded_files_ok || !this.org_maps.equals(this.cur_maps)) {
            this.writeMemoryMapAttribute(copy);
            return true;
        }
        return false;
    }

    public void addModifyListener(ModifyListener l) {
        this.modify_listeners.add(l);
    }

    private void notifyModifyListeners() {
        for (ModifyListener l : this.modify_listeners) {
            l.modifyText(null);
        }
    }

    private class MapLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider,
    ITableFontProvider {
        private MapLabelProvider() {
        }

        public Image getColumnImage(Object element, int column) {
            return null;
        }

        public String getColumnText(Object element, int column) {
            TCFMemoryRegion r = (TCFMemoryRegion)element;
            if (r.getProperties().containsKey("_CHILDREN") && column != 0) {
                return "";
            }
            switch (column) {
                case 0: {
                    return r.getFileName();
                }
                case 1: 
                case 2: {
                    int l;
                    BigInteger x;
                    BigInteger bigInteger = x = column == 1 ? r.addr : r.size;
                    if (x == null) {
                        return "";
                    }
                    String s = x.toString(16);
                    int sz = 0;
                    if (MemoryMapWidget.this.mem_ctx != null) {
                        sz = MemoryMapWidget.this.mem_ctx.getAddressSize() * 2;
                    }
                    if ((l = sz - s.length()) < 0) {
                        l = 0;
                    }
                    if (l > 16) {
                        l = 16;
                    }
                    return String.valueOf("0x0000000000000000".substring(0, 2 + l)) + s;
                }
                case 3: {
                    int n = r.getFlags();
                    StringBuffer bf = new StringBuffer();
                    if ((n & 1) != 0) {
                        bf.append('r');
                    } else {
                        bf.append('-');
                    }
                    if ((n & 2) != 0) {
                        bf.append('w');
                    } else {
                        bf.append('-');
                    }
                    if ((n & 4) != 0) {
                        bf.append('x');
                    } else {
                        bf.append('-');
                    }
                    return bf.toString();
                }
                case 4: {
                    Number n = r.getOffset();
                    if (n != null) {
                        BigInteger x = JSON.toBigInteger((Number)n);
                        String s = x.toString(16);
                        int l = 16 - s.length();
                        if (l < 0) {
                            l = 0;
                        }
                        if (l > 16) {
                            l = 16;
                        }
                        return String.valueOf("0x0000000000000000".substring(0, 2 + l)) + s;
                    }
                    String s = r.getSectionName();
                    if (s != null) {
                        return s;
                    }
                    return "";
                }
            }
            return "";
        }

        public Color getBackground(Object element, int columnIndex) {
            return MemoryMapWidget.this.map_table.getBackground();
        }

        public Color getForeground(Object element, int columnIndex) {
            TreeItem[] items;
            TCFMemoryRegion r = (TCFMemoryRegion)element;
            if (r.getProperties().get("ID") != null) {
                String fnm = r.getFileName();
                if (fnm != null && MemoryMapWidget.this.loaded_files.contains(fnm)) {
                    return MemoryMapWidget.this.map_table.getDisplay().getSystemColor(6);
                }
                return MemoryMapWidget.this.map_table.getDisplay().getSystemColor(10);
            }
            String symbolFileInfo = MemoryMapWidget.this.getSymbolFileInfo((IMemoryMap.MemoryRegion)r);
            TreeItem[] treeItemArray = items = MemoryMapWidget.this.map_table.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getData() != null && item.getData().equals(r)) {
                    item.setData("_TOOLTIP", (Object)symbolFileInfo);
                }
                ++n2;
            }
            if (symbolFileInfo != null && symbolFileInfo.contains("Symbol file error:") && MemoryMapWidget.this.cError != null) {
                return MemoryMapWidget.this.cError;
            }
            return MemoryMapWidget.this.map_table.getForeground();
        }

        public Font getFont(Object element, int columnIndex) {
            switch (columnIndex) {
                case 1: 
                case 2: 
                case 4: {
                    return JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont");
                }
            }
            return null;
        }

        public String getText(Object element) {
            return element.toString();
        }
    }

    private class MemoryMapListener
    implements IMemoryMap.MemoryMapListener {
        private MemoryMapListener() {
        }

        public void changed(String context_id) {
            if (MemoryMapWidget.this.disposed) {
                IMemoryMap svc;
                if (MemoryMapWidget.this.channel != null && (svc = (IMemoryMap)MemoryMapWidget.this.channel.getRemoteService(IMemoryMap.class)) != null) {
                    svc.removeListener((IMemoryMap.MemoryMapListener)this);
                }
                return;
            }
            if (MemoryMapWidget.this.mem_ctx != null && MemoryMapWidget.this.mem_ctx.getID() != null && MemoryMapWidget.this.mem_ctx.getID().equals(context_id) && MemoryMapWidget.this.cfg != null && PlatformUI.getWorkbench().getDisplay() != null && !PlatformUI.getWorkbench().getDisplay().isDisposed()) {
                final ILaunchConfiguration lc = MemoryMapWidget.this.cfg;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!MemoryMapWidget.this.disposed) {
                            MemoryMapWidget.this.loadData(lc);
                        }
                    }
                });
            }
        }
    }
}

