/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.tcf.internal.debug.Activator;
import org.eclipse.tcf.internal.debug.actions.TCFAction;
import org.eclipse.tcf.internal.debug.launch.TCFLaunchDelegate;
import org.eclipse.tcf.internal.debug.model.ElfLoader;
import org.eclipse.tcf.internal.debug.model.TCFBreakpointsStatus;
import org.eclipse.tcf.internal.debug.model.TCFError;
import org.eclipse.tcf.internal.debug.model.TCFMemoryRegion;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IContextQuery;
import org.eclipse.tcf.services.IDPrintf;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.services.IMemory;
import org.eclipse.tcf.services.IMemoryMap;
import org.eclipse.tcf.services.IPathMap;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.IProcessesV1;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.services.IStreams;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;

public class TCFLaunch
extends Launch {
    private static final Collection<LaunchListener> listeners = new ArrayList<LaunchListener>();
    private static LaunchListener[] listeners_array;
    private final Collection<ActionsListener> action_listeners = new ArrayList<ActionsListener>();
    private TCFTask<Boolean> launch_task;
    private IProgressMonitor launch_monitor;
    private IChannel channel;
    private Throwable error;
    private TCFBreakpointsStatus breakpoints_status;
    private String mode;
    private boolean connecting;
    private boolean disconnecting;
    private boolean disconnected;
    private boolean shutdown;
    private boolean last_context_exited;
    private long actions_interval;
    private final LinkedList<TCFTask<Boolean>> disconnect_wait_list = new LinkedList();
    private final HashSet<Object> pending_clients = new HashSet();
    private long pending_clients_timestamp;
    private String peer_name;
    private Runnable update_memory_maps;
    private IProcesses.ProcessContext process;
    private Collection<Map<String, Object>> process_signals;
    private IToken process_start_command;
    private String process_input_stream_id;
    private boolean process_exited;
    private int process_exit_code;
    private final HashMap<String, String> process_env = new HashMap();
    private final HashMap<String, TCFAction> active_actions = new HashMap();
    private final HashMap<String, LinkedList<TCFAction>> context_action_queue = new HashMap();
    private final HashMap<String, Long> context_action_timestamps = new HashMap();
    private final HashMap<String, String> process_stream_ids = new HashMap();
    private final HashMap<String, String> uart_tx_stream_ids = new HashMap();
    private final HashMap<String, String> uart_rx_stream_ids = new HashMap();
    private final HashSet<String> disconnected_stream_ids = new HashSet();
    private final LinkedList<LaunchStep> launch_steps = new LinkedList();
    private final LinkedList<String> redirection_path = new LinkedList();
    private List<IPathMap.PathMapRule> host_path_map;
    private TCFDataCache<IPathMap.PathMapRule[]> target_path_map;
    private HashMap<String, IStorage> target_path_mapping_cache = new HashMap();
    private final HashMap<String, TCFDataCache<String[]>> context_query_cache = new HashMap();
    private Set<String> context_filter;
    private boolean supports_memory_map_preloading;
    private String dprintf_stream_id;
    private final IStreams.StreamsListener streams_listener = new IStreams.StreamsListener(){

        public void created(String stream_type, String stream_id, String context_id) {
            TCFLaunch.this.disconnected_stream_ids.remove(stream_id);
            if (stream_type.equals("UART-TX")) {
                TCFLaunch.this.uart_tx_stream_ids.put(stream_id, context_id);
                TCFLaunch.this.readStream(context_id, stream_id, 0);
            } else if (stream_type.equals("UART-RX")) {
                TCFLaunch.this.uart_rx_stream_ids.put(stream_id, context_id);
            } else {
                TCFLaunch.this.process_stream_ids.put(stream_id, context_id);
                if (TCFLaunch.this.process_start_command == null) {
                    TCFLaunch.this.disconnectStream(stream_id);
                }
            }
        }

        public void disposed(String stream_type, String stream_id) {
            TCFLaunch.this.disconnected_stream_ids.add(stream_id);
        }
    };
    private final IProcesses.ProcessesListener prs_listener = new IProcesses.ProcessesListener(){

        public void exited(String process_id, int exit_code) {
            if (process_id.equals(TCFLaunch.this.process.getID())) {
                TCFLaunch.this.process_exit_code = exit_code;
                TCFLaunch.this.process_exited = true;
            }
        }
    };
    private final IRunControl.RunControlListener rc_listener = new IRunControl.RunControlListener(){

        private void flushContextQueryCache() {
            for (TCFDataCache c : TCFLaunch.this.context_query_cache.values()) {
                c.reset();
            }
        }

        public void contextAdded(IRunControl.RunControlContext[] contexts) {
            this.flushContextQueryCache();
        }

        public void contextChanged(IRunControl.RunControlContext[] contexts) {
            this.flushContextQueryCache();
        }

        public void contextRemoved(String[] context_ids) {
            this.flushContextQueryCache();
        }

        public void contextSuspended(String context, String pc, String reason, Map<String, Object> params) {
        }

        public void contextResumed(String context) {
        }

        public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
        }

        public void containerResumed(String[] context_ids) {
        }

        public void contextException(String context, String msg) {
        }
    };

    private static LaunchListener[] getListeners() {
        if (listeners_array != null) {
            return listeners_array;
        }
        listeners_array = listeners.toArray(new LaunchListener[listeners.size()]);
        return listeners_array;
    }

    public TCFLaunch(ILaunchConfiguration launchConfiguration, String mode) {
        super(launchConfiguration, mode, null);
        LaunchListener[] launchListenerArray = TCFLaunch.getListeners();
        int n = launchListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            LaunchListener l = launchListenerArray[n2];
            l.onCreated(this);
            ++n2;
        }
    }

    private void onConnected() throws Exception {
        ILaunchConfiguration cfg;
        IPathMap path_map_service;
        IRunControl rc_service = this.getService(IRunControl.class);
        if (rc_service != null) {
            rc_service.addListener(this.rc_listener);
        }
        if ((path_map_service = this.getService(IPathMap.class)) != null) {
            this.target_path_map = new TCFDataCache<IPathMap.PathMapRule[]>(this.channel){

                protected boolean startDataRetrieval() {
                    this.command = path_map_service.get(new IPathMap.DoneGet(){

                        public void doneGet(IToken token, Exception error, IPathMap.PathMapRule[] map) {
                            this.set(token, error, map);
                        }
                    });
                    return false;
                }
            };
            path_map_service.addListener(new IPathMap.PathMapListener(){

                public void changed() {
                    TCFLaunch.this.target_path_map.reset();
                    TCFLaunch.this.target_path_mapping_cache = new HashMap();
                }
            });
        }
        if ((cfg = this.getLaunchConfiguration()) != null && this.getService(IPathMap.class) != null) {
            new LaunchStep(this){

                @Override
                void start() throws Exception {
                    this.downloadPathMaps(cfg, this);
                }
            };
        }
        if (this.redirection_path.size() > 0) {
            new LaunchStep(this){

                @Override
                void start() throws Exception {
                    String id = (String)redirection_path.removeFirst();
                    IPeer p = (IPeer)Protocol.getLocator().getPeers().get(id);
                    if (p != null) {
                        channel.redirect(p.getAttributes());
                    } else {
                        channel.redirect(id);
                    }
                    if (launch_monitor != null) {
                        String name = null;
                        if (p != null) {
                            name = p.getName();
                        }
                        if (name == null) {
                            name = id;
                        }
                        launch_monitor.subTask("Connecting to " + name);
                    }
                }
            };
        } else {
            String s;
            final IStreams streams = this.getService(IStreams.class);
            if (streams != null) {
                new LaunchStep(this){

                    @Override
                    void start() {
                        String[] nms;
                        final HashSet<IToken> cmds = new HashSet<IToken>();
                        String[] stringArray = nms = new String[]{"Processes", "ProcessesV1", "UART-RX", "UART-TX"};
                        int n = nms.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            cmds.add(streams.subscribe(s, streams_listener, new IStreams.DoneSubscribe(){

                                public void doneSubscribe(IToken token, Exception error) {
                                    cmds.remove(token);
                                    if (error != null) {
                                        channel.terminate((Throwable)error);
                                    }
                                    if (cmds.size() == 0) {
                                        this.done();
                                    }
                                }
                            }));
                            ++n2;
                        }
                        if (cmds.size() == 0) {
                            this.done();
                        }
                    }
                };
            }
            if (this.mode.equals("debug")) {
                IMemoryMap mem_map;
                String attach_to_context = this.getAttribute("attach_to_context");
                if (attach_to_context != null) {
                    this.context_filter = new HashSet<String>();
                    this.context_filter.add(attach_to_context);
                }
                if ((mem_map = (IMemoryMap)this.channel.getRemoteService(IMemoryMap.class)) != null) {
                    new LaunchStep(this){

                        @Override
                        void start() throws Exception {
                            final 9 done = this;
                            mem_map.set("\u0001", null, new IMemoryMap.DoneSet(){

                                public void doneSet(IToken token, Exception error) {
                                    try {
                                        supports_memory_map_preloading = error == null;
                                        if (!supports_memory_map_preloading) {
                                            this.updateMemoryMapsOnProcessCreation(cfg, done);
                                        } else {
                                            this.downloadMemoryMaps(cfg, done);
                                        }
                                    }
                                    catch (Exception x) {
                                        channel.terminate((Throwable)x);
                                    }
                                }
                            });
                        }
                    };
                }
                new LaunchStep(this){

                    @Override
                    void start() throws Exception {
                        breakpoints_status = new TCFBreakpointsStatus(this);
                        Activator.getBreakpointsModel().downloadBreakpoints(channel, this);
                    }
                };
                final IDPrintf dprintf = this.getService(IDPrintf.class);
                if (dprintf != null) {
                    new LaunchStep(this){

                        @Override
                        void start() throws Exception {
                            dprintf.open(null, new IDPrintf.DoneCommandOpen(){

                                public void doneCommandOpen(IToken token, Exception error, final String id) {
                                    if (error != null) {
                                        channel.terminate((Throwable)error);
                                        return;
                                    }
                                    dprintf_stream_id = id;
                                    streams.connect(id, new IStreams.DoneConnect(){

                                        public void doneConnect(IToken token, Exception error) {
                                            if (error != null) {
                                                channel.terminate((Throwable)error);
                                                return;
                                            }
                                            this.readStream(null, id, 0);
                                            this.done();
                                        }
                                    });
                                }
                            });
                        }
                    };
                }
            }
            if (cfg != null && this.getService(IMemory.class) != null && (s = cfg.getAttribute("org.eclipse.tcf.debug.Files", null)) != null) {
                Collection c = (Collection)JSON.parseOne((byte[])s.getBytes("UTF-8"));
                final ElfLoader loader = new ElfLoader(this.channel);
                for (final Map m : c) {
                    Boolean b1 = (Boolean)m.get("Download");
                    Boolean b2 = (Boolean)m.get("SetPC");
                    if ((b1 == null || !b1.booleanValue()) && (b2 == null || !b2.booleanValue())) continue;
                    new LaunchStep(this){

                        @Override
                        void start() throws Exception {
                            loader.load(m, this);
                        }
                    };
                }
                new LaunchStep(this){

                    @Override
                    void start() throws Exception {
                        loader.dispose();
                        this.done();
                    }
                };
            }
            new LaunchStep(this){

                @Override
                void start() {
                    this.runLaunchSequence(this);
                }
            };
            if (cfg != null) {
                this.startRemoteProcess(cfg);
            }
            new LaunchStep(this){

                @Override
                void start() {
                    connecting = false;
                    LaunchListener[] launchListenerArray = TCFLaunch.getListeners();
                    int n = launchListenerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LaunchListener l = launchListenerArray[n2];
                        l.onConnected(this);
                        ++n2;
                    }
                    this.fireChanged();
                    if (launch_task != null) {
                        launch_task.done((Object)true);
                    }
                    launch_monitor = null;
                    launch_task = null;
                }
            };
        }
        this.launch_steps.removeFirst().start();
    }

    private void onDisconnected(Throwable error) {
        assert (!this.disconnected);
        assert (!this.shutdown);
        this.error = error;
        this.breakpoints_status = null;
        this.connecting = false;
        this.disconnected = true;
        LaunchListener[] launchListenerArray = TCFLaunch.getListeners();
        int n = launchListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            LaunchListener l = launchListenerArray[n2];
            l.onDisconnected(this);
            ++n2;
        }
        for (TCFDataCache<String[]> c : this.context_query_cache.values()) {
            c.dispose();
        }
        this.context_query_cache.clear();
        if (DebugPlugin.getDefault() != null) {
            this.fireChanged();
        }
        if (this.launch_task != null) {
            this.launch_task.done((Object)false);
        }
        this.launch_monitor = null;
        this.launch_task = null;
        this.runShutdownSequence(new Runnable(){

            @Override
            public void run() {
                TCFLaunch.this.shutdown = true;
                TCFLaunch.this.fireTerminate();
                for (TCFTask tsk : TCFLaunch.this.disconnect_wait_list) {
                    tsk.done((Object)Boolean.TRUE);
                }
                TCFLaunch.this.disconnect_wait_list.clear();
            }
        });
        if (error instanceof RuntimeException) {
            Activator.log("Channel disconnected with error", error);
        }
    }

    protected void runLaunchSequence(Runnable done) {
        done.run();
    }

    private void downloadMemoryMaps(ILaunchConfiguration cfg, final Runnable done) throws Exception {
        final IMemoryMap mmap = (IMemoryMap)this.channel.getRemoteService(IMemoryMap.class);
        if (mmap == null) {
            done.run();
            return;
        }
        final HashMap<String, ArrayList<IMemoryMap.MemoryRegion>> maps = new HashMap<String, ArrayList<IMemoryMap.MemoryRegion>>();
        this.getMemMaps(maps, cfg);
        final HashSet<IToken> cmds = new HashSet<IToken>();
        final Runnable done_all = new Runnable(){
            boolean launch_done;

            @Override
            public void run() {
                if (this.launch_done) {
                    return;
                }
                done.run();
                this.launch_done = true;
            }
        };
        final IMemoryMap.DoneSet done_set_mmap = new IMemoryMap.DoneSet(){

            public void doneSet(IToken token, Exception error) {
                if (!$assertionsDisabled && !cmds.contains(token)) {
                    throw new AssertionError();
                }
                cmds.remove(token);
                if (error != null) {
                    Activator.log("Cannot update context memory map", error);
                }
                if (cmds.isEmpty()) {
                    done_all.run();
                }
            }
        };
        for (String id : maps.keySet()) {
            ArrayList<IMemoryMap.MemoryRegion> map = maps.get(id);
            TCFMemoryRegion[] arr = map.toArray(new TCFMemoryRegion[map.size()]);
            cmds.add(mmap.set(id, (IMemoryMap.MemoryRegion[])arr, done_set_mmap));
        }
        this.update_memory_maps = new Runnable(){

            @Override
            public void run() {
                try {
                    HashSet set = new HashSet(maps.keySet());
                    maps.clear();
                    TCFLaunch.this.getMemMaps(maps, TCFLaunch.this.getLaunchConfiguration());
                    for (String id : maps.keySet()) {
                        ArrayList map = (ArrayList)maps.get(id);
                        TCFMemoryRegion[] arr = map.toArray(new TCFMemoryRegion[map.size()]);
                        cmds.add(mmap.set(id, (IMemoryMap.MemoryRegion[])arr, done_set_mmap));
                    }
                    for (String id : set) {
                        if (maps.get(id) != null) continue;
                        cmds.add(mmap.set(id, null, done_set_mmap));
                    }
                }
                catch (Throwable x) {
                    TCFLaunch.this.channel.terminate(x);
                }
            }
        };
        if (cmds.isEmpty()) {
            done_all.run();
        }
    }

    private void updateMemoryMapsOnProcessCreation(ILaunchConfiguration cfg, final Runnable done) throws Exception {
        final IMemory mem = (IMemory)this.channel.getRemoteService(IMemory.class);
        final IMemoryMap mmap = (IMemoryMap)this.channel.getRemoteService(IMemoryMap.class);
        if (mem == null || mmap == null) {
            done.run();
            return;
        }
        final HashSet deleted_maps = new HashSet();
        final HashMap<String, ArrayList<IMemoryMap.MemoryRegion>> maps = new HashMap<String, ArrayList<IMemoryMap.MemoryRegion>>();
        this.getMemMaps(maps, cfg);
        final HashSet mems = new HashSet();
        final HashSet<IToken> cmds = new HashSet<IToken>();
        final HashMap mem2map = new HashMap();
        final Runnable done_all = new Runnable(){
            boolean launch_done;

            @Override
            public void run() {
                mems.clear();
                deleted_maps.clear();
                if (this.launch_done) {
                    return;
                }
                done.run();
                this.launch_done = true;
            }
        };
        final IMemoryMap.DoneSet done_set_mmap = new IMemoryMap.DoneSet(){

            public void doneSet(IToken token, Exception error) {
                cmds.remove(token);
                if (error != null) {
                    Activator.log("Cannot update context memory map", error);
                }
                if (cmds.isEmpty()) {
                    done_all.run();
                }
            }
        };
        final IMemory.DoneGetContext done_get_context = new IMemory.DoneGetContext(){

            public void doneGetContext(IToken token, Exception error, IMemory.MemoryContext context) {
                cmds.remove(token);
                if (context != null && mems.add(context.getID())) {
                    String id = context.getName();
                    if (id == null) {
                        id = context.getID();
                    }
                    if (id != null) {
                        ArrayList map = (ArrayList)maps.get(id);
                        if (map != null) {
                            TCFMemoryRegion[] arr = map.toArray(new TCFMemoryRegion[map.size()]);
                            cmds.add(mmap.set(context.getID(), (IMemoryMap.MemoryRegion[])arr, done_set_mmap));
                            mem2map.put(context.getID(), id);
                        } else if (deleted_maps.contains(id)) {
                            cmds.add(mmap.set(context.getID(), null, done_set_mmap));
                            mem2map.remove(context.getID());
                        }
                    }
                }
                if (cmds.isEmpty()) {
                    done_all.run();
                }
            }
        };
        final IMemory.DoneGetChildren done_get_children = new IMemory.DoneGetChildren(){

            public void doneGetChildren(IToken token, Exception error, String[] ids) {
                cmds.remove(token);
                if (ids != null) {
                    String[] stringArray = ids;
                    int n = ids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        cmds.add(mem.getChildren(id, (IMemory.DoneGetChildren)this));
                        cmds.add(mem.getContext(id, done_get_context));
                        ++n2;
                    }
                }
                if (cmds.isEmpty()) {
                    done_all.run();
                }
            }
        };
        cmds.add(mem.getChildren(null, done_get_children));
        mem.addListener(new IMemory.MemoryListener(){

            public void memoryChanged(String context_id, Number[] addr, long[] size) {
            }

            public void contextRemoved(String[] context_ids) {
                String[] stringArray = context_ids;
                int n = context_ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    mems.remove(id);
                    mem2map.remove(id);
                    ++n2;
                }
            }

            public void contextChanged(IMemory.MemoryContext[] contexts) {
                IMemory.MemoryContext[] memoryContextArray = contexts;
                int n = contexts.length;
                int n2 = 0;
                while (n2 < n) {
                    ArrayList map;
                    IMemory.MemoryContext context = memoryContextArray[n2];
                    String id = context.getName();
                    if (id == null) {
                        id = context.getID();
                    }
                    if (id != null && !id.equals(mem2map.get(context.getID())) && (map = (ArrayList)maps.get(id)) != null) {
                        TCFMemoryRegion[] arr = map.toArray(new TCFMemoryRegion[map.size()]);
                        cmds.add(mmap.set(context.getID(), (IMemoryMap.MemoryRegion[])arr, done_set_mmap));
                        mem2map.put(context.getID(), id);
                    }
                    ++n2;
                }
            }

            public void contextAdded(IMemory.MemoryContext[] contexts) {
                IMemory.MemoryContext[] memoryContextArray = contexts;
                int n = contexts.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemory.MemoryContext context = memoryContextArray[n2];
                    if (mems.add(context.getID())) {
                        ArrayList map;
                        String id = context.getName();
                        if (id == null) {
                            id = context.getID();
                        }
                        if (id != null && (map = (ArrayList)maps.get(id)) != null) {
                            TCFMemoryRegion[] arr = map.toArray(new TCFMemoryRegion[map.size()]);
                            cmds.add(mmap.set(context.getID(), (IMemoryMap.MemoryRegion[])arr, done_set_mmap));
                            mem2map.put(context.getID(), id);
                        }
                    }
                    ++n2;
                }
            }
        });
        this.update_memory_maps = new Runnable(){

            @Override
            public void run() {
                try {
                    maps.clear();
                    mems.clear();
                    TCFLaunch.this.getMemMaps(maps, TCFLaunch.this.getLaunchConfiguration());
                    for (String id : mem2map.values()) {
                        if (maps.get(id) != null) continue;
                        deleted_maps.add(id);
                    }
                    cmds.add(mem.getChildren(null, done_get_children));
                }
                catch (Throwable x) {
                    TCFLaunch.this.channel.terminate(x);
                }
            }
        };
    }

    private void getMemMaps(Map<String, ArrayList<IMemoryMap.MemoryRegion>> maps, ILaunchConfiguration cfg) throws Exception {
        String s = cfg.getAttribute("org.eclipse.tcf.debug.Files", null);
        if (s != null) {
            Collection c = (Collection)JSON.parseOne((byte[])s.getBytes("UTF-8"));
            for (Map m : c) {
                ArrayList<Object> l;
                Boolean b = (Boolean)m.get("LoadSymbols");
                if (b == null || !b.booleanValue()) continue;
                String id = (String)m.get("ContextID");
                if (id == null) {
                    id = (String)m.get("Context");
                }
                if (id == null) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("FileName", m.get("File"));
                b = (Boolean)m.get("Relocate");
                if (b != null && b.booleanValue()) {
                    map.put("Addr", m.get("Addr"));
                    map.put("Offs", m.get("Offs"));
                    map.put("Size", m.get("Size"));
                }
                if ((b = (Boolean)m.get("EnableOSA")) != null && b.booleanValue()) {
                    map.put("OSA", new HashMap());
                }
                if ((l = maps.get(id)) == null) {
                    l = new ArrayList();
                    maps.put(id, l);
                }
                l.add((IMemoryMap.MemoryRegion)new TCFMemoryRegion(map));
            }
        }
        TCFLaunchDelegate.getMemMapsAttribute(maps, cfg);
    }

    private void readPathMapConfiguration(ILaunchConfiguration cfg) throws CoreException {
        String s = cfg.getAttribute("org.eclipse.tcf.debug.PathMap", "");
        this.host_path_map = new ArrayList<IPathMap.PathMapRule>();
        this.host_path_map.addAll(TCFLaunchDelegate.parsePathMapAttribute(s));
        s = cfg.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, "");
        this.host_path_map.addAll(TCFLaunchDelegate.parseSourceLocatorMemento(s));
        this.readCustomPathMapConfiguration(this.channel, cfg, this.host_path_map);
        int cnt = 0;
        String id = this.getClientID();
        if (id != null) {
            for (IPathMap.PathMapRule r : this.host_path_map) {
                r.getProperties().put("ID", String.valueOf(id) + "/" + cnt++);
            }
        }
    }

    protected String getClientID() {
        return Activator.getClientID();
    }

    protected void readCustomPathMapConfiguration(IChannel channel, ILaunchConfiguration cfg, List<IPathMap.PathMapRule> host_path_map) {
    }

    private void downloadPathMaps(ILaunchConfiguration cfg, final Runnable done) throws Exception {
        this.readPathMapConfiguration(cfg);
        this.applyPathMap(this.channel, this.host_path_map.toArray(new IPathMap.PathMapRule[this.host_path_map.size()]), new IPathMap.DoneSet(){

            public void doneSet(IToken token, Exception error) {
                if (error != null) {
                    TCFLaunch.this.channel.terminate((Throwable)error);
                } else {
                    done.run();
                }
            }
        });
    }

    protected void applyPathMap(IChannel channel, IPathMap.PathMapRule[] map, IPathMap.DoneSet done) {
        IPathMap path_map_service = this.getService(IPathMap.class);
        path_map_service.set(map, done);
    }

    private String[] toArgsArray(String file, String cmd) {
        int i = 0;
        int l = cmd.length();
        ArrayList<String> arr = new ArrayList<String>();
        arr.add(file);
        while (true) {
            if (i < l && cmd.charAt(i) == ' ') {
                ++i;
                continue;
            }
            if (i >= l) break;
            String s = null;
            if (cmd.charAt(i) == '\"') {
                ++i;
                StringBuffer bf = new StringBuffer();
                while (i < l) {
                    char ch;
                    if ((ch = cmd.charAt(i++)) == '\"') break;
                    if (ch == '\\' && i < l) {
                        ch = cmd.charAt(i++);
                    }
                    bf.append(ch);
                }
                s = bf.toString();
            } else {
                int i0 = i;
                while (i < l && cmd.charAt(i) != ' ') {
                    ++i;
                }
                s = cmd.substring(i0, i);
            }
            arr.add(s);
        }
        return arr.toArray(new String[arr.size()]);
    }

    private void copyFileToRemoteTarget(String local_file, String remote_file, final Runnable done) {
        if (local_file == null) {
            this.channel.terminate((Throwable)new Exception("Program does not exist"));
            return;
        }
        final IFileSystem fs = (IFileSystem)this.channel.getRemoteService(IFileSystem.class);
        if (fs == null) {
            this.channel.terminate((Throwable)new Exception("Cannot download program file: target does not provide File System service"));
            return;
        }
        try {
            File local_fd = new File(local_file);
            final FileInputStream inp = new FileInputStream(local_fd);
            final String task_name = "Downloading: " + local_fd.getName();
            int flags = 26;
            if (this.launch_monitor != null) {
                this.launch_monitor.subTask(task_name);
            }
            fs.open(remote_file, flags, null, new IFileSystem.DoneOpen(){
                IFileSystem.IFileHandle handle;
                long offset = 0L;
                final Set<IToken> cmds = new HashSet<IToken>();
                final byte[] buf = new byte[4096];

                public void doneOpen(IToken token, IFileSystem.FileSystemException error, IFileSystem.IFileHandle handle) {
                    this.handle = handle;
                    if (error != null) {
                        TCFLaunch.this.error = new Exception("Cannot download program file", (Throwable)error);
                        TCFLaunch.this.fireChanged();
                        done.run();
                    } else {
                        this.write_next();
                    }
                }

                private void write_next() {
                    try {
                        while (this.cmds.size() < 8) {
                            int rd = inp.read(this.buf);
                            if (rd < 0) {
                                this.close();
                                break;
                            }
                            final long kb_done = (this.offset + (long)rd) / 1024L;
                            this.cmds.add(fs.write(this.handle, this.offset, this.buf, 0, rd, new IFileSystem.DoneWrite(){

                                public void doneWrite(IToken token, IFileSystem.FileSystemException error) {
                                    cmds.remove(token);
                                    if (TCFLaunch.this.launch_monitor != null) {
                                        TCFLaunch.this.launch_monitor.subTask(String.valueOf(task_name) + ", " + kb_done + " KB done");
                                    }
                                    if (error != null) {
                                        TCFLaunch.this.channel.terminate((Throwable)error);
                                    } else {
                                        this.write_next();
                                    }
                                }
                            }));
                            this.offset += (long)rd;
                        }
                    }
                    catch (Throwable x) {
                        TCFLaunch.this.channel.terminate(x);
                    }
                }

                private void close() {
                    if (this.cmds.size() > 0) {
                        return;
                    }
                    try {
                        inp.close();
                        fs.close(this.handle, new IFileSystem.DoneClose(){

                            public void doneClose(IToken token, IFileSystem.FileSystemException error) {
                                if (error != null) {
                                    TCFLaunch.this.channel.terminate((Throwable)error);
                                } else {
                                    done.run();
                                }
                            }
                        });
                    }
                    catch (Throwable x) {
                        TCFLaunch.this.channel.terminate(x);
                    }
                }
            });
        }
        catch (Throwable x) {
            this.channel.terminate(x);
        }
    }

    private void startRemoteProcess(ILaunchConfiguration cfg) throws Exception {
        String attach_to_process;
        final String project = cfg.getAttribute("org.eclipse.tcf.debug.ProjectName", "");
        final String local_file = cfg.getAttribute("org.eclipse.tcf.debug.LocalProgramFile", "");
        final String remote_file = cfg.getAttribute("org.eclipse.tcf.debug.ProgramFile", "");
        if (local_file.length() != 0 && remote_file.length() != 0) {
            new LaunchStep(this){

                @Override
                void start() throws Exception {
                    this.copyFileToRemoteTarget(TCFLaunchDelegate.getProgramPath(project, local_file), remote_file, this);
                }
            };
        }
        if ((attach_to_process = this.getAttribute("attach_to_process")) != null) {
            final IProcesses ps = (IProcesses)this.channel.getRemoteService(IProcesses.class);
            if (ps == null) {
                throw new Exception("Target does not provide Processes service");
            }
            new LaunchStep(this){

                @Override
                void start() {
                    IProcesses.DoneGetContext done = new IProcesses.DoneGetContext(){

                        public void doneGetContext(IToken token, Exception error, final IProcesses.ProcessContext process) {
                            if (error != null) {
                                channel.terminate((Throwable)error);
                            } else {
                                process.attach(new IProcesses.DoneCommand(){

                                    public void doneCommand(IToken token, Exception error) {
                                        if (error != null) {
                                            channel.terminate((Throwable)error);
                                        } else {
                                            context_filter = new HashSet();
                                            context_filter.add(process.getID());
                                            process = process;
                                            ps.addListener(prs_listener);
                                            this.readProcessStreams();
                                            this.done();
                                        }
                                    }
                                });
                            }
                        }
                    };
                    ps.getContext(attach_to_process, done);
                }
            };
        } else if (local_file.length() != 0 || remote_file.length() != 0) {
            final IProcesses ps = (IProcesses)this.channel.getRemoteService(IProcesses.class);
            if (ps == null) {
                throw new Exception("Target does not provide Processes service");
            }
            boolean append = cfg.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
            if (append) {
                new LaunchStep(this){

                    @Override
                    void start() throws Exception {
                        ps.getEnvironment(new IProcesses.DoneGetEnvironment(){

                            public void doneGetEnvironment(IToken token, Exception error, Map<String, String> env) {
                                if (error != null) {
                                    channel.terminate((Throwable)error);
                                } else {
                                    if (env != null) {
                                        process_env.putAll(env);
                                    }
                                    this.done();
                                }
                            }
                        });
                    }
                };
            }
            final String dir = cfg.getAttribute("org.eclipse.tcf.debug.WorkingDirectory", "");
            final String args = cfg.getAttribute("org.eclipse.tcf.debug.ProgramArguments", "");
            final Map env = cfg.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
            final boolean attach_children = cfg.getAttribute("org.eclipse.tcf.debug.AttachChildren", true);
            final boolean stop_at_entry = cfg.getAttribute("org.eclipse.tcf.debug.StopAtEntry", true);
            final boolean stop_at_main = cfg.getAttribute("org.eclipse.tcf.debug.StopAtMain", true);
            final boolean use_terminal = cfg.getAttribute("org.eclipse.tcf.debug.UseTerminal", true);
            final String dont_stop = cfg.getAttribute("org.eclipse.tcf.debug.SignalsDontStop", "");
            final String dont_pass = cfg.getAttribute("org.eclipse.tcf.debug.SignalsDontPass", "");
            final int no_stop = dont_stop.length() > 0 ? Integer.parseInt(dont_stop, 16) : 0;
            final int no_pass = dont_pass.length() > 0 ? Integer.parseInt(dont_pass, 16) : 0;
            final IProcessesV1 ps_v1 = (IProcessesV1)this.channel.getRemoteService(IProcessesV1.class);
            new LaunchStep(this){

                @Override
                void start() {
                    String file;
                    if (env != null) {
                        process_env.putAll(env);
                    }
                    if ((file = remote_file) == null || file.length() == 0) {
                        file = TCFLaunchDelegate.getProgramPath(project, local_file);
                    }
                    if (file == null || file.length() == 0) {
                        channel.terminate((Throwable)new Exception("Program file does not exist"));
                        return;
                    }
                    IProcesses.DoneStart done = new IProcesses.DoneStart(){

                        public void doneStart(IToken token, final Exception error, IProcesses.ProcessContext process) {
                            process_start_command = null;
                            if (error != null) {
                                for (String id : new HashSet(process_stream_ids.keySet())) {
                                    this.disconnectStream(id);
                                }
                                process_stream_ids.clear();
                                Protocol.sync((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        channel.terminate((Throwable)error);
                                    }
                                });
                            } else {
                                context_filter = new HashSet();
                                context_filter.add(process.getID());
                                process = process;
                                ps.addListener(prs_listener);
                                this.readProcessStreams();
                                this.done();
                            }
                        }
                    };
                    if (launch_monitor != null) {
                        launch_monitor.subTask("Starting: " + file);
                    }
                    String[] args_arr = this.toArgsArray(file, args);
                    if (ps_v1 != null) {
                        HashMap<String, Comparable<Boolean>> params = new HashMap<String, Comparable<Boolean>>();
                        if (mode.equals("debug")) {
                            params.put("Attach", Boolean.valueOf(true));
                            params.put("AttachChildren", Boolean.valueOf(attach_children));
                            params.put("StopAtEntry", Boolean.valueOf(stop_at_entry));
                            params.put("StopAtMain", Boolean.valueOf(stop_at_main));
                            if (dont_stop.length() > 0) {
                                params.put("SigDontStop", Integer.valueOf(no_stop));
                            }
                            if (dont_pass.length() > 0) {
                                params.put("SigDontPass", Integer.valueOf(no_pass));
                            }
                        }
                        if (use_terminal) {
                            params.put("UseTerminal", Boolean.valueOf(true));
                        }
                        process_start_command = ps_v1.start(dir, file, args_arr, (Map)process_env, params, done);
                    } else {
                        boolean attach = mode.equals("debug");
                        process_start_command = ps.start(dir, file, args_arr, (Map)process_env, attach, done);
                    }
                }
            };
            if (this.mode.equals("debug")) {
                new LaunchStep(this){

                    @Override
                    void start() {
                        ps.getSignalList(process.getID(), new IProcesses.DoneGetSignalList(){

                            public void doneGetSignalList(IToken token, Exception error, Collection<Map<String, Object>> list) {
                                if (error != null && !process_exited) {
                                    Activator.log("Can't get process signal list", error);
                                }
                                process_signals = list;
                                this.done();
                            }
                        });
                    }
                };
                if (ps_v1 == null && (no_stop != 0 || no_pass != 0)) {
                    new LaunchStep(this){

                        @Override
                        void start() {
                            final HashSet<IToken> cmds = new HashSet<IToken>();
                            final IProcesses.DoneCommand done_set_mask = new IProcesses.DoneCommand(){

                                public void doneCommand(IToken token, Exception error) {
                                    cmds.remove(token);
                                    if (error != null && !process_exited) {
                                        channel.terminate((Throwable)error);
                                    } else if (cmds.size() == 0) {
                                        this.done();
                                    }
                                }
                            };
                            cmds.add(ps.setSignalMask(process.getID(), no_stop, no_pass, done_set_mask));
                            final IRunControl rc = (IRunControl)channel.getRemoteService(IRunControl.class);
                            if (rc != null) {
                                IRunControl.DoneGetChildren done_get_children = new IRunControl.DoneGetChildren(){

                                    public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                                        if (context_ids != null) {
                                            String[] stringArray = context_ids;
                                            int n = context_ids.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                String id = stringArray[n2];
                                                cmds.add(ps.setSignalMask(id, no_stop, no_pass, done_set_mask));
                                                cmds.add(rc.getChildren(id, (IRunControl.DoneGetChildren)this));
                                                ++n2;
                                            }
                                        }
                                        cmds.remove(token);
                                        if (error != null && !process_exited) {
                                            channel.terminate((Throwable)error);
                                        } else if (cmds.size() == 0) {
                                            this.done();
                                        }
                                    }
                                };
                                cmds.add(rc.getChildren(process.getID(), done_get_children));
                            }
                        }
                    };
                }
            }
        }
    }

    private void readProcessStreams() {
        assert (this.process_start_command == null);
        IStreams streams = this.getService(IStreams.class);
        if (streams == null) {
            return;
        }
        String inp_id = (String)this.process.getProperties().get("StdInID");
        String out_id = (String)this.process.getProperties().get("StdOutID");
        String err_id = (String)this.process.getProperties().get("StdErrID");
        String[] stringArray = this.process_stream_ids.keySet().toArray(new String[this.process_stream_ids.size()]);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id.equals(inp_id)) {
                this.process_input_stream_id = id;
            } else if (id.equals(out_id)) {
                this.readStream(this.process.getID(), id, 0);
            } else if (id.equals(err_id)) {
                this.readStream(this.process.getID(), id, 1);
            } else {
                this.disconnectStream(id);
            }
            ++n2;
        }
    }

    private void readStream(final String ctx_id, final String id, final int no) {
        if (ctx_id != null) {
            LaunchListener[] launchListenerArray = TCFLaunch.getListeners();
            int n = launchListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                LaunchListener l = launchListenerArray[n2];
                l.onProcessOutput(this, ctx_id, no, null);
                ++n2;
            }
        }
        final IStreams streams = this.getService(IStreams.class);
        IStreams.DoneRead done = new IStreams.DoneRead(){

            public void doneRead(IToken token, Exception error, int lost_size, byte[] data, boolean eos) {
                LaunchListener l;
                int n;
                if (lost_size > 0) {
                    IOException x = new IOException("Process output data lost due buffer overflow");
                    LaunchListener[] launchListenerArray = TCFLaunch.getListeners();
                    int n2 = launchListenerArray.length;
                    n = 0;
                    while (n < n2) {
                        LaunchListener l2 = launchListenerArray[n];
                        l2.onProcessStreamError(TCFLaunch.this, ctx_id, no, x, lost_size);
                        ++n;
                    }
                }
                if (data != null && data.length > 0) {
                    LaunchListener[] launchListenerArray = TCFLaunch.getListeners();
                    n = launchListenerArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        l = launchListenerArray[n3];
                        l.onProcessOutput(TCFLaunch.this, ctx_id, no, data);
                        ++n3;
                    }
                }
                if (TCFLaunch.this.disconnected_stream_ids.contains(id)) {
                    return;
                }
                if (error != null) {
                    LaunchListener[] launchListenerArray = TCFLaunch.getListeners();
                    n = launchListenerArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        l = launchListenerArray[n4];
                        l.onProcessStreamError(TCFLaunch.this, ctx_id, no, error, 0);
                        ++n4;
                    }
                    TCFLaunch.this.disconnected_stream_ids.add(id);
                }
                if (!eos && error == null) {
                    streams.read(id, 4096, (IStreams.DoneRead)this);
                }
            }
        };
        streams.read(id, 4096, done);
        streams.read(id, 4096, done);
        streams.read(id, 4096, done);
        streams.read(id, 4096, done);
    }

    private void disconnectStream(String id) {
        assert (this.process_stream_ids.get(id) != null);
        this.process_stream_ids.remove(id);
        if (this.channel.getState() != 1) {
            return;
        }
        IStreams streams = this.getService(IStreams.class);
        streams.disconnect(id, new IStreams.DoneDisconnect(){

            public void doneDisconnect(IToken token, Exception error) {
                if (TCFLaunch.this.channel.getState() != 1) {
                    return;
                }
                if (error != null) {
                    TCFLaunch.this.channel.terminate((Throwable)error);
                }
            }
        });
    }

    protected void runShutdownSequence(Runnable done) {
        done.run();
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable x) {
        this.error = x;
        if (x != null) {
            if (this.channel != null && this.channel.getState() == 1) {
                this.channel.terminate(x);
            } else if (!this.connecting) {
                this.disconnected = true;
                this.shutdown = true;
            }
        }
        this.fireChanged();
    }

    public TCFBreakpointsStatus getBreakpointsStatus() {
        return this.breakpoints_status;
    }

    public boolean isMemoryMapPreloadingSupported() {
        return this.supports_memory_map_preloading;
    }

    public static void addListener(LaunchListener listener) {
        assert (Protocol.isDispatchThread());
        listeners.add(listener);
        listeners_array = null;
    }

    public static void removeListener(LaunchListener listener) {
        assert (Protocol.isDispatchThread());
        listeners.remove(listener);
        listeners_array = null;
    }

    public void launchConfigurationChanged(final ILaunchConfiguration cfg) {
        super.launchConfigurationChanged(cfg);
        if (!cfg.equals(this.getLaunchConfiguration())) {
            return;
        }
        if (this.channel != null && this.channel.getState() == 1) {
            new TCFTask<Boolean>(this.channel){

                public void run() {
                    try {
                        if (TCFLaunch.this.update_memory_maps != null) {
                            TCFLaunch.this.update_memory_maps.run();
                        }
                        if (TCFLaunch.this.host_path_map != null) {
                            TCFLaunch.this.readPathMapConfiguration(cfg);
                            TCFLaunch.this.applyPathMap(TCFLaunch.this.channel, TCFLaunch.this.host_path_map.toArray(new IPathMap.PathMapRule[TCFLaunch.this.host_path_map.size()]), new IPathMap.DoneSet(){

                                public void doneSet(IToken token, Exception error) {
                                    if (error != null) {
                                        TCFLaunch.this.channel.terminate((Throwable)error);
                                    }
                                    this.done(false);
                                }
                            });
                        } else {
                            this.done(true);
                        }
                    }
                    catch (Throwable x) {
                        TCFLaunch.this.channel.terminate(x);
                        this.done(false);
                    }
                }
            }.getE();
        }
    }

    public IChannel getChannel() {
        return this.channel;
    }

    public IProcesses.ProcessContext getProcessContext() {
        return this.process;
    }

    public void writeProcessInputStream(final String prs_id, byte[] buf, int pos, final int len) throws Exception {
        assert (Protocol.isDispatchThread());
        if (this.channel.getState() != 1) {
            throw new IOException("Connection closed");
        }
        IStreams streams = this.getService(IStreams.class);
        if (streams == null) {
            throw new IOException("Streams service not available");
        }
        if (this.process != null && prs_id.equals(this.process.getID())) {
            final String id = this.process_input_stream_id;
            if (this.process_stream_ids.get(id) == null) {
                throw new IOException("Input stream not available");
            }
            streams.write(id, buf, pos, len, new IStreams.DoneWrite(){

                public void doneWrite(IToken token, Exception error) {
                    if (error == null) {
                        return;
                    }
                    if (TCFLaunch.this.process_stream_ids.get(id) == null) {
                        return;
                    }
                    LaunchListener[] launchListenerArray = TCFLaunch.getListeners();
                    int n = launchListenerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LaunchListener l = launchListenerArray[n2];
                        l.onProcessStreamError(TCFLaunch.this, prs_id, 0, error, len);
                        ++n2;
                    }
                    TCFLaunch.this.disconnectStream(id);
                }
            });
            return;
        }
        for (final String rx_id : this.uart_rx_stream_ids.keySet()) {
            if (!prs_id.equals(this.uart_rx_stream_ids.get(rx_id))) continue;
            streams.write(rx_id, buf, pos, len, new IStreams.DoneWrite(){

                public void doneWrite(IToken token, Exception error) {
                    if (error == null) {
                        return;
                    }
                    if (TCFLaunch.this.uart_rx_stream_ids.get(rx_id) == null) {
                        return;
                    }
                    LaunchListener[] launchListenerArray = TCFLaunch.getListeners();
                    int n = launchListenerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LaunchListener l = launchListenerArray[n2];
                        l.onProcessStreamError(TCFLaunch.this, prs_id, 0, error, len);
                        ++n2;
                    }
                    TCFLaunch.this.disconnectStream(rx_id);
                }
            });
            return;
        }
        throw new IOException("No target process");
    }

    public void openUartStreams(final String ctx_id, Map<String, Object> uart_props) {
        String tx_id;
        assert (Protocol.isDispatchThread());
        if (uart_props == null) {
            return;
        }
        IStreams streams = this.getService(IStreams.class);
        if (streams == null) {
            return;
        }
        final String rx_id = (String)uart_props.get("RXStreamID");
        if (rx_id != null && this.uart_rx_stream_ids.get(rx_id) == null) {
            streams.connect(rx_id, new IStreams.DoneConnect(){

                public void doneConnect(IToken token, Exception error) {
                    if (TCFLaunch.this.uart_rx_stream_ids.get(rx_id) != null) {
                        return;
                    }
                    TCFLaunch.this.uart_rx_stream_ids.put(rx_id, ctx_id);
                    if (error == null) {
                        return;
                    }
                    LaunchListener[] launchListenerArray = TCFLaunch.getListeners();
                    int n = launchListenerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LaunchListener l = launchListenerArray[n2];
                        l.onProcessStreamError(TCFLaunch.this, ctx_id, 0, error, 0);
                        ++n2;
                    }
                }
            });
        }
        if ((tx_id = (String)uart_props.get("TXStreamID")) != null && this.uart_tx_stream_ids.get(tx_id) == null) {
            streams.connect(tx_id, new IStreams.DoneConnect(){

                public void doneConnect(IToken token, Exception error) {
                    if (TCFLaunch.this.uart_tx_stream_ids.get(tx_id) != null) {
                        return;
                    }
                    TCFLaunch.this.uart_tx_stream_ids.put(tx_id, ctx_id);
                    if (error == null) {
                        TCFLaunch.this.readStream(ctx_id, tx_id, 0);
                        return;
                    }
                    LaunchListener[] launchListenerArray = TCFLaunch.getListeners();
                    int n = launchListenerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LaunchListener l = launchListenerArray[n2];
                        l.onProcessStreamError(TCFLaunch.this, ctx_id, 0, error, 0);
                        ++n2;
                    }
                }
            });
        }
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public boolean isConnected() {
        return this.channel != null && !this.connecting && !this.disconnected;
    }

    public void onDetach(String prs_id) {
        if (this.disconnecting) {
            return;
        }
        if (this.process == null) {
            return;
        }
        if (this.process_exited) {
            return;
        }
        if (!prs_id.equals(this.process.getID())) {
            return;
        }
        IProcesses processes = this.getService(IProcesses.class);
        processes.removeListener(this.prs_listener);
        IStreams streams = this.getService(IStreams.class);
        for (String id : this.process_stream_ids.keySet()) {
            streams.disconnect(id, new IStreams.DoneDisconnect(){

                public void doneDisconnect(IToken token, Exception error) {
                    if (error != null) {
                        TCFLaunch.this.channel.terminate((Throwable)error);
                    }
                }
            });
        }
        this.process_stream_ids.clear();
        this.process_input_stream_id = null;
        this.process = null;
    }

    public void onLastContextRemoved() {
        ILaunchConfiguration cfg = this.getLaunchConfiguration();
        try {
            if (this.process != null && cfg.getAttribute("org.eclipse.tcf.debug.DisconnectOnCtxExit", true)) {
                this.last_context_exited = true;
                this.closeChannel();
            }
        }
        catch (Throwable e) {
            Activator.log("Cannot access launch configuration", e);
        }
    }

    public void closeChannel() {
        assert (Protocol.isDispatchThread());
        if (this.channel == null) {
            return;
        }
        if (this.channel.getState() == 2) {
            return;
        }
        if (this.disconnecting) {
            return;
        }
        this.disconnecting = true;
        final HashSet<IToken> cmds = new HashSet<IToken>();
        if (this.process != null && !this.process_exited) {
            cmds.add(this.process.terminate(new IProcesses.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    cmds.remove(token);
                    if (error != null) {
                        TCFLaunch.this.channel.terminate((Throwable)error);
                    } else if (cmds.isEmpty()) {
                        TCFLaunch.this.channel.close();
                    }
                }
            }));
        }
        IStreams streams = this.getService(IStreams.class);
        IStreams.DoneDisconnect done_disconnect = new IStreams.DoneDisconnect(){

            public void doneDisconnect(IToken token, Exception error) {
                cmds.remove(token);
                if (error != null) {
                    TCFLaunch.this.channel.terminate((Throwable)error);
                } else if (cmds.isEmpty()) {
                    TCFLaunch.this.channel.close();
                }
            }
        };
        for (String id : this.process_stream_ids.keySet()) {
            cmds.add(streams.disconnect(id, done_disconnect));
        }
        for (String id : this.uart_rx_stream_ids.keySet()) {
            cmds.add(streams.disconnect(id, done_disconnect));
        }
        for (String id : this.uart_tx_stream_ids.keySet()) {
            cmds.add(streams.disconnect(id, done_disconnect));
        }
        this.process_stream_ids.clear();
        this.process_input_stream_id = null;
        this.uart_rx_stream_ids.clear();
        this.uart_tx_stream_ids.clear();
        if (this.dprintf_stream_id != null) {
            this.disconnected_stream_ids.add(this.dprintf_stream_id);
            cmds.add(streams.disconnect(this.dprintf_stream_id, done_disconnect));
            this.dprintf_stream_id = null;
        }
        if (cmds.isEmpty()) {
            this.channel.close();
        }
    }

    public IPeer getPeer() {
        assert (Protocol.isDispatchThread());
        return this.channel.getRemotePeer();
    }

    public String getPeerName() {
        return this.peer_name;
    }

    public <V extends IService> V getService(Class<V> cls) {
        assert (Protocol.isDispatchThread());
        return (V)this.channel.getRemoteService(cls);
    }

    public boolean canDisconnect() {
        return !this.disconnected;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public void disconnect() throws DebugException {
        try {
            new TCFTask<Boolean>(8000L){

                public void run() {
                    if (TCFLaunch.this.channel == null || TCFLaunch.this.shutdown) {
                        this.done(true);
                    } else {
                        TCFLaunch.this.disconnect_wait_list.add(this);
                        TCFLaunch.this.closeChannel();
                    }
                }
            }.get();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception x) {
            throw new DebugException((IStatus)new TCFError(x));
        }
    }

    public boolean canTerminate() {
        return false;
    }

    public boolean isTerminated() {
        return this.disconnected;
    }

    public void terminate() throws DebugException {
    }

    public boolean isExited() {
        return this.last_context_exited;
    }

    public boolean isProcessExited() {
        return this.process_exited;
    }

    public int getExitCode() {
        return this.process_exit_code;
    }

    public Collection<Map<String, Object>> getSignalList() {
        return this.process_signals;
    }

    public List<IPathMap.PathMapRule> getHostPathMap() {
        assert (Protocol.isDispatchThread());
        return this.host_path_map;
    }

    public TCFDataCache<IPathMap.PathMapRule[]> getTargetPathMap() {
        assert (Protocol.isDispatchThread());
        return this.target_path_map;
    }

    public Map<String, IStorage> getTargetPathMappingCache() {
        return this.target_path_mapping_cache;
    }

    public TCFDataCache<String[]> getContextQuery(final String query) {
        if (query == null) {
            return null;
        }
        TCFDataCache<String[]> cache = this.context_query_cache.get(query);
        if (cache == null) {
            if (this.disconnected) {
                return null;
            }
            final IContextQuery service = (IContextQuery)this.channel.getRemoteService(IContextQuery.class);
            if (service == null) {
                return null;
            }
            cache = new TCFDataCache<String[]>(this.channel){

                protected boolean startDataRetrieval() {
                    this.command = service.query(query, new IContextQuery.DoneQuery(){

                        public void doneQuery(IToken token, Exception error, String[] contexts) {
                            this.set(token, error, contexts);
                        }
                    });
                    return false;
                }
            };
            this.context_query_cache.put(query, cache);
        }
        return cache;
    }

    public void launchTCF(String mode, String id) {
        this.launchTCF(mode, id, null, null);
    }

    public void launchTCF(String mode, String id, TCFTask<Boolean> task, IProgressMonitor monitor) {
        assert (Protocol.isDispatchThread());
        this.mode = mode;
        this.launch_task = task;
        this.launch_monitor = monitor;
        try {
            if (id == null || id.length() == 0) {
                throw new IOException("Invalid peer ID");
            }
            this.redirection_path.clear();
            while (true) {
                int i;
                if ((i = id.indexOf(47)) <= 0) break;
                this.redirection_path.add(id.substring(0, i));
                id = id.substring(i + 1);
            }
            this.redirection_path.add(id);
            String id0 = this.redirection_path.removeFirst();
            IPeer peer = (IPeer)Protocol.getLocator().getPeers().get(id0);
            if (peer == null) {
                throw new Exception("Cannot locate peer " + id0);
            }
            this.peer_name = peer.getName();
            this.channel = peer.openChannel();
            this.channel.addChannelListener(new IChannel.IChannelListener(){

                public void onChannelOpened() {
                    try {
                        TCFLaunch.this.peer_name = TCFLaunch.this.getPeer().getName();
                        TCFLaunch.this.onConnected();
                    }
                    catch (Throwable x) {
                        TCFLaunch.this.channel.terminate(x);
                    }
                }

                public void congestionLevel(int level) {
                }

                public void onChannelClosed(Throwable error) {
                    TCFLaunch.this.channel.removeChannelListener((IChannel.IChannelListener)this);
                    TCFLaunch.this.onDisconnected(error);
                }
            });
            assert (this.channel.getState() == 0);
            if (this.launch_monitor != null) {
                this.launch_monitor.subTask("Connecting to " + this.peer_name);
            }
            this.connecting = true;
        }
        catch (Throwable e) {
            this.onDisconnected(e);
        }
    }

    public void launchTCF(String mode, String peer_name, IChannel channel) {
        assert (Protocol.isDispatchThread());
        this.mode = mode;
        this.redirection_path.clear();
        try {
            if (channel == null || channel.getRemotePeer() == null) {
                throw new IOException("Invalid channel");
            }
            this.peer_name = peer_name;
            this.channel = channel;
            IChannel.IChannelListener listener = new IChannel.IChannelListener(){

                public void onChannelOpened() {
                    try {
                        TCFLaunch.this.peer_name = TCFLaunch.this.getPeer().getName();
                        TCFLaunch.this.onConnected();
                    }
                    catch (Throwable x) {
                        TCFLaunch.this.channel.terminate(x);
                    }
                }

                public void congestionLevel(int level) {
                }

                public void onChannelClosed(Throwable error) {
                    TCFLaunch.this.channel.removeChannelListener((IChannel.IChannelListener)this);
                    TCFLaunch.this.onDisconnected(error);
                }
            };
            channel.addChannelListener(listener);
            this.connecting = true;
            if (channel.getState() == 1) {
                listener.onChannelOpened();
            } else if (channel.getState() != 0) {
                throw new IOException("Channel is in invalid state");
            }
        }
        catch (Throwable e) {
            this.onDisconnected(e);
        }
    }

    private long getActionTimeStamp(String id) {
        Long l = this.context_action_timestamps.get(id);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    private void startAction(final String id) {
        if (this.active_actions.get(id) != null) {
            return;
        }
        LinkedList<TCFAction> list = this.context_action_queue.get(id);
        if (list == null || list.size() == 0) {
            return;
        }
        final TCFAction action = list.removeFirst();
        if (list.size() == 0) {
            this.context_action_queue.remove(id);
        }
        this.active_actions.put(id, action);
        final long timestamp = this.getActionTimeStamp(id);
        long time = System.currentTimeMillis();
        Protocol.invokeLater((long)(timestamp + this.actions_interval - time), (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (TCFLaunch.this.active_actions.get(id) != action) {
                    return;
                }
                long time = System.currentTimeMillis();
                HashSet hashSet = TCFLaunch.this.pending_clients;
                synchronized (hashSet) {
                    if (TCFLaunch.this.pending_clients.size() > 0) {
                        if (time - timestamp < TCFLaunch.this.actions_interval + 1000L) {
                            Protocol.invokeLater((long)20L, (Runnable)this);
                            return;
                        }
                        TCFLaunch.this.pending_clients.clear();
                    } else if (time < TCFLaunch.this.pending_clients_timestamp + 10L) {
                        Protocol.invokeLater((long)(TCFLaunch.this.pending_clients_timestamp + 10L - time), (Runnable)this);
                        return;
                    }
                }
                TCFLaunch.this.context_action_timestamps.put(id, time);
                for (ActionsListener l : TCFLaunch.this.action_listeners) {
                    l.onContextActionStart(action);
                }
                action.run();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingClient(Object client) {
        HashSet<Object> hashSet = this.pending_clients;
        synchronized (hashSet) {
            this.pending_clients.add(client);
            this.pending_clients_timestamp = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePendingClient(Object client) {
        HashSet<Object> hashSet = this.pending_clients;
        synchronized (hashSet) {
            if (this.pending_clients.remove(client) && this.pending_clients.size() == 0) {
                this.pending_clients_timestamp = System.currentTimeMillis();
            }
        }
    }

    public void setContextActionsInterval(long interval) {
        this.actions_interval = interval;
    }

    public void addContextAction(TCFAction action) {
        assert (Protocol.isDispatchThread());
        String id = action.getContextID();
        LinkedList<TCFAction> list = this.context_action_queue.get(id);
        if (list == null) {
            list = new LinkedList();
            this.context_action_queue.put(id, list);
        }
        int priority = action.getPriority();
        ListIterator<TCFAction> i = list.listIterator();
        while (i.hasNext()) {
            if (priority <= ((TCFAction)i.next()).getPriority()) continue;
            i.previous();
            break;
        }
        i.add(action);
        this.startAction(id);
    }

    public void setContextActionResult(String id, String result) {
        assert (Protocol.isDispatchThread());
        for (ActionsListener l : this.action_listeners) {
            l.onContextActionResult(id, result);
        }
    }

    public void removeContextAction(TCFAction action) {
        assert (Protocol.isDispatchThread());
        String id = action.getContextID();
        assert (this.active_actions.get(id) == action);
        this.active_actions.remove(id);
        for (ActionsListener l : this.action_listeners) {
            l.onContextActionDone(action);
        }
        this.startAction(id);
    }

    public void removeContextActions(String id) {
        assert (Protocol.isDispatchThread());
        this.context_action_queue.remove(id);
        this.context_action_timestamps.remove(id);
    }

    public int getContextActionsCount(String id) {
        int n;
        assert (Protocol.isDispatchThread());
        LinkedList<TCFAction> list = this.context_action_queue.get(id);
        int n2 = n = list == null ? 0 : list.size();
        if (this.active_actions.get(id) != null) {
            ++n;
        }
        return n;
    }

    public void addActionsListener(ActionsListener l) {
        this.action_listeners.add(l);
    }

    public void removeActionsListener(ActionsListener l) {
        this.action_listeners.remove(l);
    }

    public Set<String> getContextFilter() {
        return this.context_filter;
    }

    public static interface ActionsListener {
        public void onContextActionStart(TCFAction var1);

        public void onContextActionResult(String var1, String var2);

        public void onContextActionDone(TCFAction var1);
    }

    public static interface LaunchListener {
        public void onCreated(TCFLaunch var1);

        public void onConnected(TCFLaunch var1);

        public void onDisconnected(TCFLaunch var1);

        public void onProcessOutput(TCFLaunch var1, String var2, int var3, byte[] var4);

        public void onProcessStreamError(TCFLaunch var1, String var2, int var3, Exception var4, int var5);
    }

    private abstract class LaunchStep
    implements Runnable {
        LaunchStep() {
            TCFLaunch.this.launch_steps.add(this);
        }

        abstract void start() throws Exception;

        void done() {
            if (TCFLaunch.this.channel.getState() != 1) {
                return;
            }
            try {
                ((LaunchStep)TCFLaunch.this.launch_steps.removeFirst()).start();
            }
            catch (Throwable x) {
                TCFLaunch.this.channel.terminate(x);
            }
        }

        @Override
        public void run() {
            this.done();
        }
    }
}

