/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.handler;

import java.util.ArrayList;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.launch.core.lm.LaunchConfigHelper;
import org.eclipse.tcf.te.launch.ui.activator.UIPlugin;
import org.eclipse.tcf.te.launch.ui.model.LaunchNode;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class OpenLaunchConfigurationContributionItem
extends CompoundContributionItem
implements IWorkbenchContribution {
    private boolean enabled = true;
    private IServiceLocator serviceLocator;

    public OpenLaunchConfigurationContributionItem() {
    }

    public OpenLaunchConfigurationContributionItem(String id) {
        super(id);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected IContributionItem[] getContributionItems() {
        ILaunchConfiguration config;
        boolean openConfig;
        IHandlerService service = (IHandlerService)this.serviceLocator.getService(IHandlerService.class);
        IEvaluationContext state = service.getCurrentState();
        ISelection selection = (ISelection)state.getVariable("selection");
        IStructuredSelection iss = (IStructuredSelection)selection;
        Object obj = iss.getFirstElement();
        Assert.isTrue((boolean)(obj instanceof LaunchNode));
        LaunchNode node = (LaunchNode)((Object)obj);
        ArrayList<ActionContributionItem> items = new ArrayList<ActionContributionItem>();
        final ILaunchConfigurationType type = node.getLaunchConfigurationType();
        if (node.getLaunchConfiguration() != null) {
            openConfig = true;
            config = node.getLaunchConfiguration();
        } else {
            openConfig = false;
            ILaunchConfigurationWorkingCopy newConfig = null;
            try {
                newConfig = type.newInstance(null, "temp");
            }
            catch (Exception exception) {}
            config = newConfig;
        }
        if (type != null && config != null) {
            try {
                String[] stringArray = LaunchConfigHelper.getLaunchConfigTypeModes((ILaunchConfigurationType)type, (boolean)false);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String mode = stringArray[n2];
                    final ILaunchGroup launchGroup = DebugUITools.getLaunchGroup((ILaunchConfiguration)config, (String)mode);
                    ILaunchMode launchMode = DebugPlugin.getDefault().getLaunchManager().getLaunchMode(mode);
                    Action action = new Action(){

                        public void run() {
                            DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IStructuredSelection)new StructuredSelection(openConfig ? config : type), (String)launchGroup.getIdentifier());
                        }
                    };
                    action.setText(String.valueOf(launchMode.getLabel()) + " Configuration" + (openConfig ? "" : "s") + "...");
                    action.setImageDescriptor(launchGroup.getImageDescriptor());
                    items.add(new ActionContributionItem((IAction)action));
                    ++n2;
                }
            }
            catch (Exception exception) {}
        }
        this.enabled = !items.isEmpty();
        return items.toArray(new IContributionItem[items.size()]);
    }
}

