/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFFileSystemException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.Operation;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpCopy
extends Operation {
    List<FSTreeNode> nodes;
    FSTreeNode dest;
    IConfirmCallback confirmCallback;
    boolean cpPermission;
    boolean cpOwnership;

    public OpCopy(List<FSTreeNode> nodes, FSTreeNode dest) {
        this(nodes, dest, false, false, null);
    }

    public OpCopy(List<FSTreeNode> nodes, FSTreeNode dest, boolean cpPerm, boolean cpOwn, IConfirmCallback confirmCallback) {
        this.nodes = this.getAncestors(nodes);
        this.dest = dest;
        this.cpOwnership = cpOwn;
        this.cpPermission = cpPerm;
        this.confirmCallback = confirmCallback;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        block8: {
            super.run(monitor);
            FSTreeNode head = this.nodes.get(0);
            IChannel channel = null;
            try {
                try {
                    channel = OpCopy.openChannel(head.peerNode.getPeer());
                    if (channel == null) break block8;
                    IFileSystem service = OpCopy.getBlockingFileSystem(channel);
                    if (service != null) {
                        for (FSTreeNode node : this.nodes) {
                            this.copyNode(service, node, this.dest);
                        }
                        break block8;
                    }
                    String message = NLS.bind((String)Messages.Operation_NoFileSystemError, (Object)head.peerNode.getPeerId());
                    throw new TCFFileSystemException(4, message);
                }
                catch (TCFException e) {
                    throw new InvocationTargetException(e, e.getMessage());
                }
            }
            finally {
                if (channel != null) {
                    Tcf.getChannelManager().closeChannel(channel);
                }
                monitor.done();
            }
        }
    }

    void copyNode(IFileSystem service, FSTreeNode node, FSTreeNode dest) throws TCFFileSystemException, InterruptedException {
        if (node.isFile()) {
            this.copyFile(service, node, dest);
        } else if (node.isDirectory()) {
            this.copyFolder(service, node, dest);
        }
    }

    private void copyFolder(IFileSystem service, FSTreeNode node, FSTreeNode dest) throws TCFFileSystemException, InterruptedException {
        if (this.monitor.isCanceled()) {
            throw new InterruptedException();
        }
        FSTreeNode copy = this.findChild(service, dest, node.name);
        if (copy == null) {
            copy = (FSTreeNode)node.clone();
            this.addChild(service, dest, copy);
            this.mkdir(service, copy);
            this.copyChildren(service, node, copy);
        } else if (node.equals(copy)) {
            copy = this.createCopyDestination(service, node, dest);
            this.mkdir(service, copy);
            this.copyChildren(service, node, copy);
        } else if (this.confirmReplace(node, this.confirmCallback)) {
            this.copyChildren(service, node, copy);
        }
        this.monitor.worked(1);
    }

    private void copyChildren(IFileSystem service, FSTreeNode node, FSTreeNode dest) throws TCFFileSystemException, InterruptedException {
        List<FSTreeNode> children = this.getChildren(node, service);
        if (!children.isEmpty()) {
            for (FSTreeNode child : children) {
                this.copyNode(service, child, dest);
            }
        }
    }

    private void copyFile(IFileSystem service, FSTreeNode node, FSTreeNode dest) throws TCFFileSystemException, InterruptedException {
        if (this.monitor.isCanceled()) {
            throw new InterruptedException();
        }
        this.monitor.subTask(NLS.bind((String)Messages.OpCopy_Copying, (Object)node.name));
        final FSTreeNode copy = this.createCopyDestination(service, node, dest);
        String src_path = node.getLocation(true);
        String dst_path = copy.getLocation(true);
        final TCFFileSystemException[] errors = new TCFFileSystemException[1];
        service.copy(src_path, dst_path, this.cpPermission, this.cpOwnership, new IFileSystem.DoneCopy(){

            public void doneCopy(IToken token, IFileSystem.FileSystemException error) {
                if (error != null) {
                    String message = NLS.bind((String)Messages.OpCopy_CannotCopyFile, (Object)copy.name, (Object)error);
                    errors[0] = new TCFFileSystemException(4, message, (Throwable)error);
                }
            }
        });
        if (errors[0] != null) {
            this.removeChild(service, dest, copy);
            throw errors[0];
        }
        this.monitor.worked(1);
    }

    @Override
    public String getName() {
        return Messages.OpCopy_CopyingFile;
    }

    @Override
    public int getTotalWork() {
        if (this.nodes != null && !this.nodes.isEmpty()) {
            final AtomicReference ref = new AtomicReference();
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    block5: {
                        FSTreeNode head = OpCopy.this.nodes.get(0);
                        IChannel channel = null;
                        try {
                            channel = OpCopy.openChannel(head.peerNode.getPeer());
                            if (channel == null) break block5;
                            IFileSystem service = OpCopy.getBlockingFileSystem(channel);
                            if (service != null) {
                                ref.set(OpCopy.this.count(service, OpCopy.this.nodes));
                                break block5;
                            }
                            String message = NLS.bind((String)Messages.Operation_NoFileSystemError, (Object)head.peerNode.getPeerId());
                            throw new TCFFileSystemException(4, message);
                        }
                        finally {
                            if (channel != null) {
                                Tcf.getChannelManager().closeChannel(channel);
                            }
                        }
                    }
                }
            });
            Integer value = (Integer)ref.get();
            return value == null ? -1 : value;
        }
        return -1;
    }
}

