/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.cdt.launching;

import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.launch.cdt.activator.Activator;
import org.eclipse.tcf.te.tcf.launch.cdt.interfaces.IRemoteTEConfigurationConstants;
import org.eclipse.tcf.te.tcf.launch.cdt.nls.Messages;
import org.eclipse.tcf.te.tcf.launch.cdt.utils.TEHelper;
import org.eclipse.tcf.te.tcf.launch.cdt.utils.TERunProcess;

public class TERunLaunchDelegate
extends AbstractCLaunchDelegate {
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IPath exePath = this.checkBinaryDetails(config);
        if (exePath != null) {
            Activator.getDefault().initializeTE();
            IPeer peer = TEHelper.getCurrentConnection(config).getPeer();
            String remoteExePath = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_PATH, "");
            monitor.setTaskName(Messages.RemoteRunLaunchDelegate_2);
            boolean skipDownload = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, false);
            if (!skipDownload) {
                TEHelper.remoteFileTransfer(peer, exePath.toString(), remoteExePath, new SubProgressMonitor(monitor, 80));
            }
            monitor.setTaskName(Messages.RemoteRunLaunchDelegate_12);
            String arguments = this.getProgramArguments(config);
            String prelaunchCmd = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_PRERUN_COMMANDS, "");
            TEHelper.launchCmd(peer, prelaunchCmd, null, new SubProgressMonitor(monitor, 2), (ICallback)new Callback());
            new TERunProcess(launch, remoteExePath, arguments, this.renderProcessLabel(exePath.toOSString()), peer, new SubProgressMonitor(monitor, 20));
        }
    }

    protected IPath checkBinaryDetails(ILaunchConfiguration config) throws CoreException {
        ICProject project = CDebugUtils.verifyCProject((ILaunchConfiguration)config);
        IPath exePath = LaunchUtils.verifyProgramPath((ILaunchConfiguration)config, (ICProject)project);
        LaunchUtils.verifyBinary((ILaunchConfiguration)config, (IPath)exePath);
        return exePath;
    }

    protected String getPluginID() {
        return "org.eclipse.tcf.te.tcf.launch.cdt";
    }
}

