/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tcf.internal.core.RemotePeer;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerRedirector;

public class PeerModelPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, final String property, final Object[] args, final Object expectedValue) {
        if (receiver instanceof IPeer) {
            receiver = Platform.getAdapterManager().getAdapter(receiver, IPeerNode.class);
        }
        if (receiver instanceof IPeerNode) {
            final IPeerNode peerNode = (IPeerNode)receiver;
            final AtomicBoolean result = new AtomicBoolean();
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    result.set(PeerModelPropertyTester.this.testPeerModel(peerNode, property, args, expectedValue));
                }
            });
            return result.get();
        }
        return false;
    }

    protected boolean testPeerModel(IPeerNode peerNode, String property, Object[] args, Object expectedValue) {
        Assert.isNotNull((Object)peerNode);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IPeer peer = peerNode.getPeer();
        if ("name".equals(property) && peer.getName() != null && peer.getName().equals(expectedValue)) {
            return true;
        }
        if ("nameRegex".equals(property) && expectedValue instanceof String && peer.getName() != null && peer.getName().matches((String)expectedValue)) {
            return true;
        }
        if ("osName".equals(property) && peer.getOSName() != null && peer.getOSName().equals(expectedValue)) {
            return true;
        }
        if ("osNameRegex".equals(property) && expectedValue instanceof String && peer.getOSName() != null && peer.getOSName().matches((String)expectedValue)) {
            return true;
        }
        if ("isRedirected".equals(property)) {
            boolean isRedirected = peer instanceof PeerRedirector;
            if (expectedValue instanceof Boolean) {
                return (Boolean)expectedValue == isRedirected;
            }
        }
        if ("isProxy".equals(property)) {
            boolean isProxy = peer.getAttributes().containsKey("Proxy");
            if (expectedValue instanceof Boolean) {
                return (Boolean)expectedValue == isProxy;
            }
        }
        if ("isValid".equals(property)) {
            boolean isValid = peerNode.isValid();
            if (expectedValue instanceof Boolean) {
                return (Boolean)expectedValue == isValid;
            }
        }
        if ("isValueAdd".equals(property)) {
            boolean isValueAdd;
            String value = (String)peer.getAttributes().get("ValueAdd");
            boolean bl = isValueAdd = value != null && ("1".equals(value.trim()) || Boolean.parseBoolean(value.trim()));
            if (expectedValue instanceof Boolean) {
                return (Boolean)expectedValue == isValueAdd;
            }
        }
        if ("isOfType".equals(property)) {
            String value = (String)peer.getAttributes().get("Type");
            if (expectedValue instanceof String) {
                return value != null ? ((String)expectedValue).equals(value) : ((String)expectedValue).equalsIgnoreCase("null");
            }
        }
        if ("hasAttribute".equals(property)) {
            boolean hasAttribute;
            String name = args != null && args.length > 0 ? (String)args[0] : null;
            boolean bl = hasAttribute = name != null && !"".equals(name) ? peer.getAttributes().containsKey(name) : false;
            if (expectedValue instanceof Boolean) {
                return (Boolean)expectedValue == hasAttribute;
            }
        }
        if ("isRemotePeer".equals(property)) {
            boolean isRemotePeer = peer instanceof RemotePeer;
            if (expectedValue instanceof Boolean) {
                return (Boolean)expectedValue == isRemotePeer;
            }
        }
        if ("isAttribute".equals(property)) {
            String value;
            String name = args != null && args.length > 0 ? (String)args[0] : null;
            String string = value = name != null && !"".equals(name) ? (String)peer.getAttributes().get(name) : null;
            if (expectedValue != null) {
                return expectedValue.toString().equals(value);
            }
        }
        if ("hasOfflineService".equals(property)) {
            boolean hasOfflineService;
            String offlineServices = (String)peer.getAttributes().get("OfflineServices");
            String remoteServices = peerNode.getStringProperty("services.remote");
            List<String> offline = offlineServices != null ? Arrays.asList(offlineServices.split(",\\s*")) : Collections.EMPTY_LIST;
            List<String> remote = remoteServices != null ? Arrays.asList(remoteServices.split(",\\s*")) : null;
            boolean bl = hasOfflineService = remote == null ? offline.contains(expectedValue) : remote.contains(expectedValue);
            if (expectedValue instanceof Boolean) {
                return (Boolean)expectedValue == hasOfflineService;
            }
            return hasOfflineService;
        }
        if ("hasRemoteService".equals(property)) {
            String remoteServices = peerNode.getStringProperty("services.remote");
            List<String> remote = remoteServices != null ? Arrays.asList(remoteServices.split(",\\s*")) : Collections.EMPTY_LIST;
            boolean hasRemoteService = remote.contains(expectedValue);
            if (expectedValue instanceof Boolean) {
                return (Boolean)expectedValue == hasRemoteService;
            }
            return hasRemoteService;
        }
        if ("hasLocalService".equals(property)) {
            String localServices = peerNode.getStringProperty("services.local");
            List<String> remote = localServices != null ? Arrays.asList(localServices.split(",\\s*")) : Collections.EMPTY_LIST;
            boolean hasLocalService = remote.contains(expectedValue);
            if (expectedValue instanceof Boolean) {
                return (Boolean)expectedValue == hasLocalService;
            }
            return hasLocalService;
        }
        return false;
    }
}

