/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.steps;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IDebugService;
import org.eclipse.tcf.te.runtime.services.interfaces.IDelegateService;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.steps.AbstractPeerNodeStep;

public class StartDebuggerStep
extends AbstractPeerNodeStep {
    public static final String PARAM_ATTACH_ALL = "autoAttachAll";
    public static final String PARAM_FORCE_START_DEBUGGER = "forceStart";

    public void validateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
    }

    public void execute(IStepContext context, final IPropertiesContainer data, final IFullQualifiedId fullQualifiedId, final IProgressMonitor monitor, final ICallback callback) {
        boolean forceStart;
        final IPeerNode node = this.getActivePeerModelContext(context, data, fullQualifiedId);
        Assert.isNotNull((Object)node);
        String value = (String)this.getParameters().get(PARAM_ATTACH_ALL);
        final boolean autoAttachAll = value != null ? Boolean.parseBoolean(value) : false;
        value = (String)this.getParameters().get(PARAM_FORCE_START_DEBUGGER);
        boolean bl = forceStart = value != null ? Boolean.parseBoolean(value) : false;
        if (forceStart || StepperAttributeUtil.getBooleanProperty((String)"org.eclipse.tcf.te.tcf.locator.start_debugger", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data)) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    String remoteServices = node.getStringProperty("services.remote");
                    Assert.isNotNull((Object)remoteServices);
                    boolean canAttachDbg = false;
                    StringTokenizer tokenizer = new StringTokenizer(remoteServices, ",");
                    while (tokenizer.hasMoreTokens()) {
                        String svc = tokenizer.nextToken().trim();
                        if (!"RunControl".equals(svc)) continue;
                        canAttachDbg = true;
                        break;
                    }
                    if (canAttachDbg) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                IDebugService dbgService = (IDebugService)ServiceManager.getInstance().getService((Object)node, IDebugService.class, false);
                                if (dbgService != null) {
                                    PropertiesContainer props = new PropertiesContainer();
                                    dbgService.attach((Object)node, (IPropertiesContainer)props, monitor, (ICallback)new Callback(){

                                        protected void internalDone(Object caller, IStatus status) {
                                            if ((status == null || status.isOK()) && autoAttachAll) {
                                                IDelegate delegate;
                                                IDelegateService service = (IDelegateService)ServiceManager.getInstance().getService((Object)node, IDelegateService.class, false);
                                                IDelegate iDelegate = delegate = service != null ? (IDelegate)service.getDelegate((Object)node, IDelegate.class) : null;
                                                if (delegate != null) {
                                                    delegate.postAttachDebugger(node, monitor, callback);
                                                } else {
                                                    StartDebuggerStep.this.callback(data, fullQualifiedId, callback, status, null);
                                                }
                                            } else {
                                                StartDebuggerStep.this.callback(data, fullQualifiedId, callback, status, null);
                                            }
                                        }
                                    });
                                } else {
                                    StartDebuggerStep.this.callback(data, fullQualifiedId, callback, Status.OK_STATUS, null);
                                }
                            }
                        };
                        Protocol.invokeLater((Runnable)runnable);
                    } else {
                        StartDebuggerStep.this.callback(data, fullQualifiedId, callback, Status.OK_STATUS, null);
                    }
                }
            });
        } else {
            this.callback(data, fullQualifiedId, callback, Status.OK_STATUS, null);
        }
    }

    public void rollback(IStepContext context, IPropertiesContainer data, IStatus status, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor, ICallback callback) {
        IPeerNode node = this.getActivePeerModelContext(context, data, fullQualifiedId);
        IDebugService dbgService = (IDebugService)ServiceManager.getInstance().getService((Object)node, IDebugService.class, false);
        if (dbgService != null) {
            PropertiesContainer props = new PropertiesContainer();
            dbgService.detach((Object)node, (IPropertiesContainer)props, null, callback);
        } else {
            this.callback(data, fullQualifiedId, callback, Status.OK_STATUS, null);
        }
    }

    public static interface IDelegate {
        public void postAttachDebugger(IPeerNode var1, IProgressMonitor var2, ICallback var3);
    }
}

