/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model.properties;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;

public class PropertyTester
extends org.eclipse.core.expressions.PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, final Object expectedValue) {
        if (receiver instanceof IProcessContextNode) {
            final IProcessContextNode node = (IProcessContextNode)receiver;
            if ("isAttached".equals(property) && expectedValue instanceof Boolean) {
                final AtomicBoolean isAttached = new AtomicBoolean();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (node.getProcessContext() != null) {
                            isAttached.set(node.getProcessContext().isAttached());
                        }
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
                return ((Boolean)expectedValue).booleanValue() == isAttached.get();
            }
            if ("canAttach".equals(property) && expectedValue instanceof Boolean) {
                final AtomicBoolean canAttach = new AtomicBoolean();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (node.getProcessContext() != null) {
                            if (node.getProcessContext().getProperties().containsKey("CanAttach")) {
                                Boolean value = (Boolean)node.getProcessContext().getProperties().get("CanAttach");
                                canAttach.set(value != null && value != false);
                            } else {
                                canAttach.set(true);
                            }
                        }
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
                return ((Boolean)expectedValue).booleanValue() == canAttach.get();
            }
            if ("hasProcessContext".equals(property) && expectedValue instanceof Boolean) {
                final AtomicBoolean canAttach = new AtomicBoolean();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        canAttach.set(node.getProcessContext() != null);
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
                return ((Boolean)expectedValue).booleanValue() == canAttach.get();
            }
            if ("canTerminate".equals(property) && expectedValue instanceof Boolean) {
                final AtomicBoolean canTerminate = new AtomicBoolean();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (node.getProcessContext() != null) {
                            canTerminate.set(node.getProcessContext().canTerminate());
                        }
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
                return ((Boolean)expectedValue).booleanValue() == canTerminate.get();
            }
            if ("hasCapability".equals(property) && expectedValue instanceof String) {
                final AtomicBoolean hasCapability = new AtomicBoolean();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Map caps = (Map)node.getProperty("capabilities");
                        if (caps != null) {
                            hasCapability.set(caps.containsKey(expectedValue) && Boolean.parseBoolean(caps.get(expectedValue).toString()));
                        }
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
                return hasCapability.get();
            }
        }
        return false;
    }
}

