/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.util;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.persistence.PersistenceManager;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IPersistenceDelegate;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.processes.core.interfaces.IProcessContextItem;
import org.eclipse.tcf.te.tcf.processes.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModelLookupService;
import org.eclipse.tcf.te.tcf.processes.core.persistence.ProcessContextItem;

public class ProcessDataHelper {
    public static final String encodeProcessContextItems(IProcessContextItem[] items) {
        try {
            if (items != null && items.length > 0) {
                IPersistenceDelegate delegate = PersistenceManager.getInstance().getDelegate(IProcessContextItem.class, String.class);
                return (String)delegate.writeList((Object[])items, String.class);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static final IProcessContextItem[] decodeProcessContextItems(String encoded) {
        if (encoded != null && encoded.trim().length() > 0) {
            try {
                IPersistenceDelegate delegate = PersistenceManager.getInstance().getDelegate(IProcessContextItem.class, String.class);
                Object[] input = delegate.readList(IProcessContextItem.class, (Object)encoded);
                ArrayList<IProcessContextItem> items = new ArrayList<IProcessContextItem>();
                Object[] objectArray = input;
                int n = input.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof IProcessContextItem) {
                        items.add((IProcessContextItem)object);
                    }
                    ++n2;
                }
                return items.toArray(new IProcessContextItem[items.size()]);
            }
            catch (Exception exception) {}
        }
        return new IProcessContextItem[0];
    }

    public static final IProcessContextItem getProcessContextItem(final IProcessContextNode node) {
        final AtomicReference ctxItem = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                Boolean value;
                if (node.getProcessContext().getProperties().containsKey("CanAttach") && (value = (Boolean)node.getProcessContext().getProperties().get("CanAttach")) != null && value.booleanValue()) {
                    ProcessContextItem item = new ProcessContextItem();
                    item.setProperty("id", node.getProcessContext().getID());
                    item.setProperty("name", node.getProcessContext().getName());
                    item.setProperty("path", ProcessDataHelper.getProcessContextNodePath(node));
                    ctxItem.set(item);
                }
            }
        });
        return (IProcessContextItem)ctxItem.get();
    }

    protected static final String getProcessContextNodePath(IProcessContextNode node) {
        String path = null;
        while (node.getParent() instanceof IProcessContextNode) {
            node = (IProcessContextNode)node.getParent();
            path = String.valueOf(node.getProcessContext().getName()) + (path != null ? "/" + path : "");
        }
        return path;
    }

    public static final IProcessContextNode[] getProcessContextNodes(final IPeerNode peerNode, final IProcessContextItem item) {
        final ArrayList nodes = new ArrayList();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IRuntimeModelLookupService lkup = (IRuntimeModelLookupService)ModelManager.getRuntimeModel(peerNode).getService(IRuntimeModelLookupService.class);
                IModelNode[] modelNodes = null;
                if (item.getId() != null) {
                    modelNodes = lkup.lkupModelNodesById(item.getId());
                }
                if (modelNodes == null || modelNodes.length == 0) {
                    modelNodes = lkup.lkupModelNodesByName(item.getName());
                }
                if (modelNodes != null) {
                    IModelNode[] iModelNodeArray = modelNodes;
                    int n = modelNodes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModelNode node = iModelNodeArray[n2];
                        if (node instanceof IProcessContextNode && ProcessDataHelper.isValid((IProcessContextNode)node, item)) {
                            nodes.add((IProcessContextNode)node);
                        }
                        ++n2;
                    }
                }
            }
        });
        return nodes.toArray(new IProcessContextNode[nodes.size()]);
    }

    protected static final boolean isValid(IProcessContextNode node, IProcessContextItem item) {
        if (item.getName() != null && node.getProcessContext().getName().equals(item.getName())) {
            String itemPath = item.getPath();
            String nodePath = ProcessDataHelper.getProcessContextNodePath(node);
            return itemPath == null && nodePath == null || itemPath != null && itemPath.equals(nodePath);
        }
        return false;
    }
}

