/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.internal.delegates;

import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.persistence.utils.DataHelper;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepperOperationService;
import org.eclipse.tcf.te.runtime.stepper.utils.StepperHelper;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.utils.PeerDataHelper;
import org.eclipse.tcf.te.tcf.processes.core.interfaces.IProcessContextItem;
import org.eclipse.tcf.te.tcf.processes.core.util.ProcessDataHelper;
import org.eclipse.tcf.te.tcf.processes.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.processes.ui.internal.dialogs.AttachContextSelectionDialog;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.ui.delegates.AbstractDefaultContextToolbarDelegate;

public class DefaultContextToolbarDelegate
extends AbstractDefaultContextToolbarDelegate {
    public String[] getHandledStepGroupIds(IPeerNode peerNode) {
        return new String[]{"org.eclipse.tcf.te.tcf.processes.core.attachStepGroup", "org.eclipse.tcf.te.tcf.processes.core.detachStepGroup"};
    }

    public String getLabel(IPeerNode peerNode, String entry) {
        IPropertiesContainer data = DataHelper.decodePropertiesContainer((String)entry);
        String stepGroupId = this.getStepGroupId(entry);
        if ("org.eclipse.tcf.te.tcf.processes.core.attachStepGroup".equals(stepGroupId)) {
            IProcessContextItem[] items = ProcessDataHelper.decodeProcessContextItems((String)data.getStringProperty("processContextList"));
            String contexts = null;
            int count = 0;
            IProcessContextItem[] iProcessContextItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessContextItem item = iProcessContextItemArray[n2];
                contexts = contexts == null ? "" : String.valueOf(contexts) + ",";
                if (count >= 2) {
                    contexts = String.valueOf(contexts) + "..";
                    break;
                }
                contexts = String.valueOf(contexts) + item.getName();
                ++n2;
            }
            return NLS.bind((String)Messages.DefaultContextToolbarDelegate_attachContext_label, contexts);
        }
        return super.getLabel(peerNode, entry);
    }

    public String getDescription(IPeerNode peerNode, String entry) {
        IPropertiesContainer data = DataHelper.decodePropertiesContainer((String)entry);
        String stepGroupId = this.getStepGroupId(entry);
        if ("org.eclipse.tcf.te.tcf.processes.core.attachStepGroup".equals(stepGroupId)) {
            IProcessContextItem[] items = ProcessDataHelper.decodeProcessContextItems((String)data.getStringProperty("processContextList"));
            String contexts = null;
            IProcessContextItem[] iProcessContextItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessContextItem item = iProcessContextItemArray[n2];
                contexts = contexts == null ? "\t" : String.valueOf(contexts) + "\n\t";
                String path = item.getPath();
                if (path != null && path.length() > 0) {
                    contexts = String.valueOf(contexts) + path + "/";
                }
                contexts = String.valueOf(contexts) + item.getName();
                ++n2;
            }
            return NLS.bind((String)Messages.DefaultContextToolbarDelegate_attachContext_description, contexts);
        }
        return super.getDescription(peerNode, entry);
    }

    public Image getImage(IPeerNode peerNode, String entry) {
        String stepGroupId = this.getStepGroupId(entry);
        if ("org.eclipse.tcf.te.tcf.processes.core.attachStepGroup".equals(stepGroupId)) {
            return UIPlugin.getImage("OBJ_Attach");
        }
        if ("org.eclipse.tcf.te.tcf.processes.core.detachStepGroup".equals(stepGroupId)) {
            return UIPlugin.getImage("OBJ_Detach");
        }
        return super.getImage(peerNode, entry);
    }

    public boolean execute(IPeerNode peerNode, String entry, boolean showDialog) {
        String operation = null;
        String stepGroupId = this.getStepGroupId(entry);
        if ("org.eclipse.tcf.te.tcf.processes.core.attachStepGroup".equals(stepGroupId)) {
            operation = "attach";
        }
        if ("org.eclipse.tcf.te.tcf.processes.core.detachStepGroup".equals(stepGroupId)) {
            operation = "detach";
        }
        IPropertiesContainer data = DataHelper.decodePropertiesContainer((String)entry);
        IStepperOperationService stepperOperationService = StepperHelper.getService((Object)peerNode, (String)operation);
        if (stepperOperationService != null) {
            if (!showDialog) {
                showDialog |= !stepperOperationService.validateStepData((Object)peerNode, operation, data);
            }
        } else {
            return false;
        }
        if (showDialog) {
            AttachContextSelectionDialog dialog = null;
            if ("org.eclipse.tcf.te.tcf.processes.core.attachStepGroup".equals(stepGroupId)) {
                dialog = new AttachContextSelectionDialog(Display.getDefault().getActiveShell(), null);
            }
            if (dialog != null) {
                data.setProperty("contextList", (Object)PeerDataHelper.encodeContextList((IPeerNode[])new IPeerNode[]{peerNode}));
                dialog.setupData(data);
                if (dialog.open() == 0) {
                    data = new PropertiesContainer();
                    dialog.extractData(data);
                    data.setProperty("contextList", null);
                } else {
                    return false;
                }
            }
        }
        StepperHelper.scheduleStepperJob((Object)peerNode, (String)operation, (IStepperOperationService)stepperOperationService, (IPropertiesContainer)data, null, null);
        return true;
    }

    public boolean validate(IPeerNode peerNode, String entry) {
        String operation = null;
        String stepGroupId = this.getStepGroupId(entry);
        if ("org.eclipse.tcf.te.tcf.processes.core.attachStepGroup".equals(stepGroupId)) {
            operation = "attach";
        }
        if ("org.eclipse.tcf.te.tcf.processes.core.detachStepGroup".equals(stepGroupId)) {
            operation = "detach";
        }
        if (operation != null) {
            IPropertiesContainer data = DataHelper.decodePropertiesContainer((String)entry);
            IStepperOperationService stepperOperationService = StepperHelper.getService((Object)peerNode, (String)operation);
            if (stepperOperationService != null) {
                return stepperOperationService.validateStepData((Object)peerNode, operation, data);
            }
        }
        return super.validate(peerNode, entry);
    }
}

