/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.search;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IUIService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.ui.interfaces.IProcessMonitorUIDelegate;
import org.eclipse.tcf.te.tcf.processes.ui.navigator.runtime.LabelProviderDelegate;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.processes.ui.search.GeneralSearchable;
import org.eclipse.tcf.te.tcf.processes.ui.search.ProcessStateSearchable;
import org.eclipse.tcf.te.tcf.processes.ui.search.ProcessUserSearchable;
import org.eclipse.tcf.te.ui.interfaces.ISearchable;
import org.eclipse.tcf.te.ui.utils.CompositeSearchable;

public class ProcessSearchable
extends CompositeSearchable {
    ILabelProvider labelProvider = new LabelProviderDelegate();

    public ProcessSearchable(IPeerNode node) {
        ISearchable[] searchables;
        IUIService service = (IUIService)ServiceManager.getInstance().getService((Object)node, IUIService.class);
        IProcessMonitorUIDelegate delegate = service != null ? (IProcessMonitorUIDelegate)service.getDelegate((Object)node, IProcessMonitorUIDelegate.class) : null;
        ISearchable[] iSearchableArray = searchables = delegate != null ? delegate.getSearchables(node) : null;
        if (searchables == null) {
            searchables = new ISearchable[]{new GeneralSearchable(), new ProcessUserSearchable(), new ProcessStateSearchable()};
        }
        this.setSearchables(searchables);
    }

    public String getSearchTitle(final Object rootElement) {
        final AtomicReference<IPeerNode> node = new AtomicReference<IPeerNode>();
        if (rootElement instanceof IRuntimeModel) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (rootElement instanceof IRuntimeModel) {
                        node.set(((IRuntimeModel)rootElement).getPeerNode());
                    }
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
        } else if (rootElement != null) {
            node.set(rootElement instanceof IAdaptable ? (IPeerNode)((IAdaptable)rootElement).getAdapter(IPeerNode.class) : (IPeerNode)Platform.getAdapterManager().getAdapter(rootElement, IPeerNode.class));
        }
        String label = Messages.getStringDelegated(node.get(), "ProcessSearchable_SearchTitle");
        return label != null ? label : Messages.ProcessSearchable_SearchTitle;
    }

    public String getSearchMessage(final Object rootElement) {
        if (rootElement == null || rootElement instanceof IRuntimeModel) {
            final AtomicReference node = new AtomicReference();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (rootElement instanceof IRuntimeModel) {
                        node.set(((IRuntimeModel)rootElement).getPeerNode());
                    }
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            String label = Messages.getStringDelegated(node.get(), "ProcessSearchable_PromptFindInProcessList");
            return label != null ? label : Messages.ProcessSearchable_PromptFindInProcessList;
        }
        IPeerNode node = rootElement instanceof IAdaptable ? (IPeerNode)((IAdaptable)rootElement).getAdapter(IPeerNode.class) : (IPeerNode)Platform.getAdapterManager().getAdapter(rootElement, IPeerNode.class);
        String label = Messages.getStringDelegated(node, "ProcessSearchable_PromptFindUnderProcess");
        String message = label != null ? label : Messages.ProcessSearchable_PromptFindUnderProcess;
        String rootName = "\"" + this.getElementName(rootElement) + "\"";
        message = NLS.bind((String)message, (Object)rootName);
        return message;
    }

    public String getCustomMessage(final Object rootElement, String key) {
        final AtomicReference<IPeerNode> node = new AtomicReference<IPeerNode>();
        if (rootElement instanceof IRuntimeModel) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (rootElement instanceof IRuntimeModel) {
                        node.set(((IRuntimeModel)rootElement).getPeerNode());
                    }
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
        } else if (rootElement != null) {
            node.set(rootElement instanceof IAdaptable ? (IPeerNode)((IAdaptable)rootElement).getAdapter(IPeerNode.class) : (IPeerNode)Platform.getAdapterManager().getAdapter(rootElement, IPeerNode.class));
        }
        String message = Messages.getStringDelegated(node.get(), key);
        return message;
    }

    private String getElementName(final Object rootElement) {
        if (rootElement == null || rootElement instanceof IRuntimeModel) {
            final AtomicReference node = new AtomicReference();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    node.set(((IRuntimeModel)rootElement).getPeerNode());
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            String label = Messages.getStringDelegated(node.get(), "ProcessSearchable_ProcessList");
            return label != null ? label : Messages.ProcessSearchable_ProcessList;
        }
        return this.labelProvider.getText(rootElement);
    }

    public String getElementText(Object element) {
        return this.getElementName(element);
    }
}

