/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.terminals.ui.launcher;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.terminals.core.launcher.TerminalsLauncher;
import org.eclipse.tcf.te.tcf.terminals.ui.controls.TerminalsWizardConfigurationPanel;
import org.eclipse.tcf.te.tcf.terminals.ui.launcher.TerminalsMementoHandler;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.terminals.interfaces.IConfigurationPanel;
import org.eclipse.tcf.te.ui.terminals.interfaces.IMementoHandler;
import org.eclipse.tcf.te.ui.terminals.launcher.AbstractLauncherDelegate;

public class TerminalsLauncherDelegate
extends AbstractLauncherDelegate {
    private final IMementoHandler mementoHandler = new TerminalsMementoHandler();

    public IConfigurationPanel getPanel(BaseDialogPageControl parentControl) {
        return new TerminalsWizardConfigurationPanel(parentControl);
    }

    public boolean needsUserConfiguration() {
        return true;
    }

    public void execute(IPropertiesContainer properties, ICallback callback) {
        Object element;
        Assert.isNotNull((Object)properties);
        ISelection selection = (ISelection)properties.getProperty("selection");
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IPeerNode) {
            final IPeerNode peerNode = (IPeerNode)element;
            final AtomicReference<IPeer> peer = new AtomicReference<IPeer>();
            if (Protocol.isDispatchThread()) {
                peer.set(peerNode.getPeer());
            } else {
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        peer.set(peerNode.getPeer());
                    }
                });
            }
            if (peer.get() != null) {
                TerminalsLauncher launcher = new TerminalsLauncher();
                launcher.launch((IPeer)peer.get(), properties, callback);
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (IMementoHandler.class.equals((Object)adapter)) {
            return this.mementoHandler;
        }
        return super.getAdapter(adapter);
    }
}

