/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class CopyRemoteResourcesToWcOperation
extends AbstractActionOperation {
    protected SVNEntryReference entry;
    protected IResource resource;

    public CopyRemoteResourcesToWcOperation(SVNEntryReference entry, IResource resource) {
        super("Operation_CopyRemoteToWC", SVNMessages.class);
        this.entry = entry;
        this.resource = resource;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource repositoryResource = SVNUtility.asRepositoryResource(this.entry.path, true);
        IRepositoryLocation location = repositoryResource.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            this.writeToConsole(0, "svn copy \"" + this.entry.path + "@" + this.entry.pegRevision + "\" \"" + FileUtility.getWorkingCopyPath(this.resource) + "\"\n");
            proxy.copyLocal(new SVNEntryRevisionReference[]{new SVNEntryRevisionReference(this.entry, null)}, FileUtility.getWorkingCopyPath(this.resource), 0L, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }

    public ISchedulingRule getSchedulingRule() {
        return this.resource instanceof IProject ? this.resource : this.resource.getParent();
    }
}

