/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.synchronize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.provider.ThreeWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.provider.ResourceDiff;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.internal.core.history.LocalFileRevision;
import org.eclipse.team.internal.core.mapping.ResourceVariantFileRevision;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.operation.local.IRemoteStatusOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.resource.events.IResourceStatesListener;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.synchronize.IRemoteStatusCache;
import org.eclipse.team.svn.core.synchronize.PersistentRemoteStatusCache;
import org.eclipse.team.svn.core.synchronize.RemoteStatusCache;
import org.eclipse.team.svn.core.synchronize.ResourceVariantComparator;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ILoggedOperationFactory;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSVNSubscriber
extends Subscriber
implements IResourceStatesListener {
    protected static final IResourceVariantComparator RV_COMPARATOR = new ResourceVariantComparator();
    public static final String CONTIGOUS_PREF_NODE = "contigous";
    public static final String CONTIGOUS_REPORT_DEFAULT = "true";
    protected static final QualifiedName REMOTE_CACHE_KEY = new QualifiedName("org.eclipse.team.svn", "remote-cache-key");
    protected IRemoteStatusCache statusCache;
    protected Set<IResource> oldResources;
    protected String name;

    public AbstractSVNSubscriber(boolean usePersistentCache, String name) {
        this.name = name;
        this.statusCache = usePersistentCache ? new PersistentRemoteStatusCache(REMOTE_CACHE_KEY) : new RemoteStatusCache();
        SVNRemoteStorage.instance().addResourceStatesListener(ResourceStatesChangedEvent.class, this);
        this.oldResources = new HashSet<IResource>();
    }

    public static boolean getSynchInfoContigous() {
        return Boolean.parseBoolean(SVNTeamPlugin.instance().getPreferences().node("synch_info").get(CONTIGOUS_PREF_NODE, CONTIGOUS_REPORT_DEFAULT));
    }

    public static void setSynchInfoContigous(boolean isContigous) {
        SVNTeamPlugin.instance().getPreferences().node("synch_info").put(CONTIGOUS_PREF_NODE, String.valueOf(isContigous));
        SVNTeamPlugin.instance().savePreferences();
    }

    public boolean isSynchronizedWithRepository() throws TeamException {
        return this.statusCache.containsData();
    }

    public String getName() {
        return this.name;
    }

    public boolean isSupervised(IResource resource) {
        return FileUtility.isConnected(resource) && !FileUtility.isSVNInternals(resource) && !FileUtility.isIgnored(resource);
    }

    public IResource[] members(IResource resource) throws TeamException {
        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
        if (IStateFilter.SF_INTERNAL_INVALID.accept(local) || IStateFilter.SF_IGNORED.accept(local) && !IStateFilter.SF_UNVERSIONED_EXTERNAL.accept(local)) {
            return FileUtility.NO_CHILDREN;
        }
        return this.statusCache.allMembers(resource);
    }

    public IResource[] roots() {
        ArrayList<IProject> roots = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (FileUtility.isConnected((IResource)projects[i])) {
                roots.add(projects[i]);
            }
            ++i;
        }
        return roots.toArray(new IResource[roots.size()]);
    }

    public IDiff getDiff(IResource resource) throws CoreException {
        AbstractSVNSyncInfo info = (AbstractSVNSyncInfo)this.getSyncInfo(resource);
        if (info == null || info.getKind() == 0) {
            return null;
        }
        int direction = SyncInfo.getDirection((int)info.getKind());
        ResourceDiff local = null;
        if (direction == 4 || direction == 12) {
            int kind = AbstractSVNSubscriber.syncKind2DiffKind(info.getLocalKind());
            if (resource.getType() == 1) {
                IFileRevision before = this.asFileState(info.getBase());
                LocalFileRevision after = new LocalFileRevision((IFile)local);
                local = new ResourceDiff(info.getLocal(), kind, 0, before, (IFileRevision)after);
            } else {
                local = new ResourceDiff(info.getLocal(), kind, 0, null, null);
            }
        }
        ResourceDiff remote = null;
        if (direction == 8 || direction == 12) {
            int kind = AbstractSVNSubscriber.syncKind2DiffKind(info.getRemoteKind());
            if (info.getLocal().getType() == 1) {
                IFileRevision before = this.asFileState(info.getBase());
                IFileRevision after = this.asFileState(info.getRemote());
                remote = new ResourceDiff(info.getLocal(), kind, 0, before, after);
            } else {
                remote = new ResourceDiff(info.getLocal(), kind);
            }
        }
        return new ThreeWayDiff(local, remote);
    }

    private static int syncKind2DiffKind(int kind) {
        return (kind = SyncInfo.getChange((int)kind)) == 1 ? 1 : (kind == 2 ? 2 : (kind == 3 ? 4 : 0));
    }

    private IFileRevision asFileState(IResourceVariant variant) {
        return variant == null ? null : new ResourceVariantFileRevision(variant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncInfo getSyncInfo(IResource resource) throws TeamException {
        ILocalResource localStatus;
        if (!this.isSupervised(resource)) {
            return null;
        }
        IResourceChange remoteStatus = SVNRemoteStorage.instance().resourceChangeFromBytes(this.statusCache.getBytes(resource));
        ILocalResource iLocalResource = localStatus = this.statusCache.containsData() ? SVNRemoteStorage.instance().asLocalResourceDirty(resource) : SVNRemoteStorage.instance().asLocalResource(resource);
        if (!IStateFilter.SF_INTERNAL_INVALID.accept(localStatus) || remoteStatus != null) {
            SyncInfo info = this.getSVNSyncInfo(localStatus, remoteStatus);
            if (info != null) {
                info.init();
                int kind = info.getKind();
                if (SyncInfo.getChange((int)kind) == 2 && (SyncInfo.getDirection((int)kind) & 4) != 0 && !resource.exists()) {
                    Set<IResource> set = this.oldResources;
                    synchronized (set) {
                        this.oldResources.add(resource);
                    }
                }
                if (localStatus.hasTreeConflict() && !resource.exists()) {
                    Set<IResource> set = this.oldResources;
                    synchronized (set) {
                        this.oldResources.add(resource);
                    }
                }
            }
            return info;
        }
        return null;
    }

    public IResourceVariantComparator getResourceComparator() {
        return RV_COMPARATOR;
    }

    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        ArrayList<IResource> resourcesToOperateList = new ArrayList<IResource>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource current = iResourceArray[n2];
            if (FileUtility.isConnected(current)) {
                resourcesToOperateList.add(current);
            }
            ++n2;
        }
        IResource[] operableData = resourcesToOperateList.toArray(new IResource[0]);
        HashSet<IResource> refreshScope = this.clearRemoteStatusesImpl(operableData);
        this.resourcesStateChangedImpl(refreshScope.toArray(new IResource[refreshScope.size()]));
        if (AbstractSVNSubscriber.getSynchInfoContigous()) {
            UpdateStatusOperation op = new UpdateStatusOperation(operableData, depth);
            ProgressMonitorUtility.doTaskExternal(op, monitor);
        } else {
            this.resourcesStateChangedImpl(this.findChanges(operableData, depth, monitor, SVNTeamPlugin.instance().getOptionProvider().getLoggedOperationFactory()));
        }
    }

    public void clearRemoteStatuses(IResource[] resources) throws TeamException {
        HashSet<IResource> refreshScope = this.clearRemoteStatusesImpl(resources);
        this.resourcesStateChangedImpl(refreshScope.toArray(new IResource[refreshScope.size()]));
    }

    @Override
    public void resourcesStateChanged(ResourceStatesChangedEvent event) {
        try {
            if (event.type == 0) {
                this.resourcesStateChangedImpl(event.getResourcesRecursivelly());
            }
        }
        catch (TeamException e) {
            LoggedOperation.reportError(this.getClass().getName(), e);
        }
    }

    protected HashSet<IResource> clearRemoteStatusesImpl(IResource[] resources) throws TeamException {
        return this.clearRemoteStatusesImpl(this.statusCache, resources);
    }

    protected HashSet<IResource> clearRemoteStatusesImpl(IRemoteStatusCache cache, IResource[] resources) throws TeamException {
        final HashSet<IResource> refreshSet = new HashSet<IResource>();
        cache.traverse(resources, 2, new IRemoteStatusCache.ICacheVisitor(){

            public void visit(IPath current, byte[] data) {
                IResource resource = SVNRemoteStorage.instance().resourceChangeFromBytes(data).getResource();
                if (resource != null) {
                    refreshSet.add(resource);
                }
            }
        });
        int i = 0;
        while (i < resources.length) {
            cache.flushBytes(resources[i], 2);
            ++i;
        }
        return refreshSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resourcesStateChangedImpl(IResource[] resources) throws TeamException {
        HashSet<IResource> allResources = new HashSet<IResource>(Arrays.asList(resources));
        int i = 0;
        while (i < resources.length) {
            allResources.addAll(Arrays.asList(this.statusCache.allMembers(resources[i])));
            ++i;
        }
        Set<IResource> set = this.oldResources;
        synchronized (set) {
            for (IResource resource : this.oldResources) {
                SVNChangeStatus status;
                if (resource.getLocation() == null || (status = SVNUtility.getSVNInfoForNotConnected(resource)) != null && (status.textStatus == 4 || status.textStatus == 6)) continue;
                allResources.add(resource);
            }
            IResource[] refreshSet = allResources.toArray(new IResource[allResources.size()]);
            if (CoreExtensionsManager.instance().getOptionProvider().isSVNCacheEnabled()) {
                IResource[] parents = FileUtility.getParents(refreshSet, false);
                int i2 = 0;
                while (i2 < parents.length) {
                    try {
                        SVNRemoteStorage.instance().getRegisteredChildren((IContainer)parents[i2]);
                    }
                    catch (Exception ex) {
                        LoggedOperation.reportError(SVNMessages.getErrorString("Error_CheckCache"), ex);
                    }
                    ++i2;
                }
            }
            this.fireTeamResourceChange((ISubscriberChangeEvent[])SubscriberChangeEvent.asSyncChangedDeltas((Subscriber)this, (IResource[])refreshSet));
        }
    }

    protected IResource[] findChanges(IResource[] resources, int depth, IProgressMonitor monitor, ILoggedOperationFactory operationWrapperFactory) {
        CompositeOperation op = new CompositeOperation("", SVNMessages.class);
        final IRemoteStatusOperation rStatusOp = this.addStatusOperation(op, resources, depth);
        if (rStatusOp == null) {
            return FileUtility.NO_CHILDREN;
        }
        op.setOperationName(rStatusOp.getId());
        final ArrayList changes = new ArrayList();
        op.add(new AbstractActionOperation("Operation_FetchChanges", SVNMessages.class){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                SVNEntryStatus[] statuses = rStatusOp.getStatuses();
                if (statuses != null) {
                    IResource resource;
                    HashMap<IResource, IResourceChange> resourcesMap = new HashMap<IResource, IResourceChange>();
                    int i = 0;
                    while (i < statuses.length && !monitor.isCanceled()) {
                        IResourceChange resourceChange;
                        if (AbstractSVNSubscriber.this.isIncoming(statuses[i]) && (resourceChange = AbstractSVNSubscriber.this.handleResourceChange(rStatusOp, statuses[i])) != null) {
                            resource = resourceChange.getResource();
                            resourcesMap.put(resource, resourceChange);
                        }
                        ++i;
                    }
                    if (!resourcesMap.isEmpty()) {
                        IResource[] resources = resourcesMap.keySet().toArray(new IResource[0]);
                        FileUtility.reorder(resources, true);
                        int i2 = 0;
                        while (i2 < resources.length && !monitor.isCanceled()) {
                            resource = resources[i2];
                            final IResourceChange resourceChange = (IResourceChange)resourcesMap.get(resource);
                            final 2 self = this;
                            this.protectStep(new IUnprotectedOperation(){

                                public void run(IProgressMonitor monitor) throws Exception {
                                    ProgressMonitorUtility.setTaskInfo(monitor, self, String.valueOf(resourceChange.getRevision()));
                                    (this).AbstractSVNSubscriber.this.statusCache.setBytes(resourceChange.getResource(), SVNRemoteStorage.instance().resourceChangeAsBytes(resourceChange));
                                }
                            }, monitor, resources.length);
                            changes.add(resourceChange.getResource());
                            ++i2;
                        }
                    }
                }
            }
        }, new IActionOperation[]{rStatusOp});
        ProgressMonitorUtility.doTaskExternal(op, monitor, operationWrapperFactory);
        return changes.toArray(new IResource[changes.size()]);
    }

    protected abstract boolean isIncoming(SVNEntryStatus var1);

    protected abstract IResourceChange handleResourceChange(IRemoteStatusOperation var1, SVNEntryStatus var2);

    protected abstract SyncInfo getSVNSyncInfo(ILocalResource var1, IResourceChange var2) throws TeamException;

    protected abstract IRemoteStatusOperation addStatusOperation(CompositeOperation var1, IResource[] var2, int var3);

    public class UpdateStatusOperation
    extends AbstractActionOperation
    implements ILoggedOperationFactory {
        protected IResource[] resources;
        protected int depth;

        public UpdateStatusOperation(IResource[] resources, int depth) {
            super("Operation_UpdateStatus", SVNMessages.class);
            ArrayList<Object> tResources = new ArrayList<Object>();
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getType() == 8) {
                    tResources.addAll(Arrays.asList(((IWorkspaceRoot)resource).getProjects()));
                } else {
                    tResources.add(resource);
                }
                ++n2;
            }
            this.resources = resources;
            this.depth = depth;
        }

        public IActionOperation getLogged(IActionOperation operation) {
            return new LoggedOperation(operation){

                protected void handleError(IStatus errorStatus) {
                    UpdateStatusOperation.this.reportStatus(errorStatus);
                }
            };
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            Map<IProject, List<IResource>> project2Resources = SVNUtility.splitWorkingCopies(this.resources);
            Iterator<List<IResource>> it = project2Resources.values().iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                List<IResource> entry = it.next();
                final IResource[] wcResources = entry.toArray(new IResource[entry.size()]);
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        AbstractSVNSubscriber.this.resourcesStateChangedImpl(AbstractSVNSubscriber.this.findChanges(wcResources, UpdateStatusOperation.this.depth, monitor, UpdateStatusOperation.this));
                    }
                }, monitor, project2Resources.size());
            }
        }
    }
}

