/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCache;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCacheInfo;
import org.eclipse.team.svn.revision.graph.operation.BaseFetchOperation;
import org.eclipse.team.svn.revision.graph.operation.MergeLogEntryCallback;

public class FetchNewMergeInfoOperation
extends BaseFetchOperation {
    protected long lastRepositoryRevision;

    public FetchNewMergeInfoOperation(IRepositoryResource resource, RepositoryCache repositoryCache, long lastRepositoryRevision, boolean isSkipFetchErrors) {
        super("Operation_FetchNewMergeInfo", resource, repositoryCache, isSkipFetchErrors);
        this.lastRepositoryRevision = lastRepositoryRevision;
    }

    protected void prepareData(IProgressMonitor monitor) throws Exception {
        RepositoryCacheInfo cacheInfo = this.repositoryCache.getCacheInfo();
        long startRevision = cacheInfo.getMergeLastProcessedRevision() + 1L;
        long endRevision = this.lastRepositoryRevision;
        boolean bl = this.canRun = this.lastRepositoryRevision > cacheInfo.getMergeLastProcessedRevision();
        if (this.canRun) {
            this.logOptions = 524288L;
            this.revProps = new String[]{""};
            this.logEntryCallback = new MergeLogEntryCallback((IActionOperation)this, monitor, (int)(endRevision - startRevision + 1L), this.repositoryCache);
            cacheInfo.setMergeSkippedRevisions(startRevision, endRevision);
            cacheInfo.setMergeLastProcessedRevision(endRevision);
            cacheInfo.save();
        }
    }

    protected long getStartSkippedRevision() {
        return this.repositoryCache.getCacheInfo().getMergeStartSkippedRevision();
    }

    protected long getEndSkippedRevision() {
        return this.repositoryCache.getCacheInfo().getMergeEndSkippedRevision();
    }
}

