/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCache;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCacheInfo;
import org.eclipse.team.svn.revision.graph.operation.BaseFetchOperation;

public class LogEntriesCallback
implements BaseFetchOperation.ISVNLogEntryCallbackWithError {
    protected static final int REVISIONS_COUNT_FOR_SAVE = 50000;
    protected IActionOperation op;
    protected int totalWork;
    protected IProgressMonitor monitor;
    protected int currentWork;
    protected RepositoryCache repositoryCache;
    protected int processedRevisionsCount;
    protected Throwable error;

    public LogEntriesCallback(IActionOperation op, IProgressMonitor monitor, int totalWork, RepositoryCache repositoryCache) {
        this.op = op;
        this.monitor = monitor;
        this.totalWork = totalWork;
        this.repositoryCache = repositoryCache;
    }

    public void next(SVNLogEntry log) {
        this.addEntry(log);
    }

    protected void addEntry(SVNLogEntry entry) {
        if (this.error == null) {
            ProgressMonitorUtility.setTaskInfo((IProgressMonitor)this.monitor, (IActionOperation)this.op, (String)SVNRevisionGraphMessages.format((String)SVNRevisionGraphMessages.LogEntriesCallback_Message, (Object)entry.revision));
            ProgressMonitorUtility.progress((IProgressMonitor)this.monitor, (int)(++this.currentWork), (int)this.totalWork);
            try {
                this.repositoryCache.addEntry(entry);
                if (++this.processedRevisionsCount % 50000 == 0) {
                    this.repositoryCache.save(this.monitor);
                }
                this.updateSkippedRevisions();
            }
            catch (Throwable e) {
                this.error = e;
                this.monitor.setCanceled(true);
            }
        }
    }

    protected boolean updateSkippedRevisions() {
        boolean hasRevisionsToProcess = true;
        RepositoryCacheInfo cacheInfo = this.repositoryCache.getCacheInfo();
        long start = cacheInfo.getStartSkippedRevision();
        long end = cacheInfo.getEndSkippedRevision();
        if (start > --end) {
            end = 0L;
            start = 0L;
            hasRevisionsToProcess = false;
        }
        this.repositoryCache.getCacheInfo().setSkippedRevisions(start, end);
        return hasRevisionsToProcess;
    }

    public boolean skipRevision() {
        ++this.currentWork;
        return this.updateSkippedRevisions();
    }

    public void retryRevision() {
    }

    public Throwable getError() {
        return this.error;
    }
}

