/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.generic;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.AssociationObjectFactories;
import org.eclipse.wb.core.model.association.AssociationObjectFactory;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.generic.ContainerObjectValidator;
import org.eclipse.wb.internal.core.model.generic.ContainerObjectValidators;
import org.eclipse.wb.internal.core.model.generic.FlowContainer;
import org.eclipse.wb.internal.core.model.generic.FlowContainerConfigurable;
import org.eclipse.wb.internal.core.model.generic.FlowContainerConfiguration;
import org.eclipse.wb.internal.core.model.util.predicate.ExpressionPredicate;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FlowContainerFactory {
    private final JavaInfo m_javaInfo;
    private final boolean m_forCanvas;

    public FlowContainerFactory(JavaInfo javaInfo, boolean forCanvas) {
        this.m_javaInfo = javaInfo;
        this.m_forCanvas = forCanvas;
    }

    public List<FlowContainer> get() {
        List containers = Lists.newArrayList();
        this.addConfigurableContainers(containers);
        return containers;
    }

    private void addConfigurableContainers(List<FlowContainer> containers) {
        List<FlowContainerConfiguration> configurations = this.getConfigurations();
        for (FlowContainerConfiguration configuration : configurations) {
            FlowContainerConfigurable container = new FlowContainerConfigurable(this.m_javaInfo, configuration);
            containers.add(container);
        }
    }

    public List<FlowContainerConfiguration> getConfigurations() {
        return (List)ExecutionUtils.runObject((RunnableObjectEx)new RunnableObjectEx<List<FlowContainerConfiguration>>(){

            public List<FlowContainerConfiguration> runObject() throws Exception {
                return FlowContainerFactory.this.getConfigurationsEx();
            }
        }, (String)"Exception during reading flow container configurations for %s", (Object[])new Object[]{this.m_javaInfo});
    }

    private List<FlowContainerConfiguration> getConfigurationsEx() {
        List configurations = Lists.newArrayList();
        for (String prefix : this.getConfigurationPrefixes()) {
            FlowContainerConfiguration configuration = this.createConfiguration(prefix);
            configurations.add(configuration);
        }
        return configurations;
    }

    private List<String> getConfigurationPrefixes() {
        List prefixes = Lists.newArrayList();
        this.addConfigurationPrefixes(prefixes, "flowContainer");
        if (this.m_forCanvas) {
            this.addConfigurationPrefixes(prefixes, "flowContainer.canvas");
        } else {
            this.addConfigurationPrefixes(prefixes, "flowContainer.tree");
        }
        return prefixes;
    }

    private void addConfigurationPrefixes(List<String> prefixes, String basePrefix) {
        int i = 0;
        while (i < 10) {
            String prefix = String.valueOf(basePrefix) + (i == 0 ? "" : "." + i);
            if ("true".equals(this.getParameter(prefix))) {
                prefixes.add(prefix);
            }
            ++i;
        }
    }

    private FlowContainerConfiguration createConfiguration(String prefix) {
        return new FlowContainerConfiguration(this.getHorizontalPredicate(prefix, true), this.getRtlPredicate(prefix, true), this.getAssociation(prefix), this.getComponentValidator(prefix), this.getReferenceValidator(prefix), this.getGroupName(prefix));
    }

    private ContainerObjectValidator getComponentValidator(String prefix) {
        String validatorExpression = this.getParameter(String.valueOf(prefix) + ".component-validator");
        if (validatorExpression != null) {
            return ContainerObjectValidators.forComponentExpression((String)validatorExpression);
        }
        String componentString = this.getComponentString(prefix);
        Assert.isNotNull((Object)componentString, (String)"No 'component' validator.");
        String[] componentTypes = StringUtils.split((String)componentString);
        return ContainerObjectValidators.forList((String[])componentTypes);
    }

    private String getComponentString(String prefix) {
        String componentString = this.getParameter(String.valueOf(prefix) + ".component");
        if (componentString == null) {
            componentString = this.getParameter("flowContainer.defaultComponent");
        }
        return componentString;
    }

    private ContainerObjectValidator getReferenceValidator(String prefix) {
        String validatorExpression = this.getParameter(String.valueOf(prefix) + ".reference-validator");
        if (validatorExpression != null) {
            return ContainerObjectValidators.forReferenceExpression((String)validatorExpression);
        }
        String referenceString = this.getReferenceString(prefix);
        Assert.isNotNull((Object)referenceString, (String)"No 'reference' validator.");
        String[] referenceTypes = StringUtils.split((String)referenceString);
        return ContainerObjectValidators.forList((String[])referenceTypes);
    }

    private String getReferenceString(String prefix) {
        String referenceString = this.getParameter(String.valueOf(prefix) + ".reference");
        if (referenceString == null) {
            referenceString = this.getParameter(String.valueOf(prefix) + ".component");
        }
        if (referenceString == null) {
            referenceString = this.getParameter("flowContainer.defaultReference");
        }
        return referenceString;
    }

    private Predicate<Object> getHorizontalPredicate(String prefix, boolean def) {
        String horizontalString = this.getParameter(String.valueOf(prefix) + ".horizontal");
        if (horizontalString == null) {
            return Predicates.alwaysTrue();
        }
        return new ExpressionPredicate(horizontalString);
    }

    private Predicate<Object> getRtlPredicate(String prefix, boolean def) {
        String rtlString = this.getParameter(String.valueOf(prefix) + ".rtl");
        if (rtlString == null) {
            return Predicates.alwaysFalse();
        }
        return new ExpressionPredicate(rtlString);
    }

    private AssociationObjectFactory getAssociation(String prefix) {
        String associationString = this.getParameter(String.valueOf(prefix) + ".association");
        if (associationString == null) {
            return AssociationObjectFactories.no();
        }
        return FlowContainerFactory.getAssociation_invocationChild(associationString);
    }

    private static AssociationObjectFactory getAssociation_invocationChild(String associationString) {
        associationString = StringUtils.removeStart((String)associationString, (String)"invocationChild ");
        Assert.isTrue((boolean)associationString.startsWith("%parent%."), (String)"Association 'invocationChild' should start with %%parent%%., but '%s' found.", (Object[])new Object[]{associationString});
        return AssociationObjectFactories.invocationChild(associationString, false);
    }

    private String getGroupName(String prefix) {
        return this.getParameter(String.valueOf(prefix) + ".group");
    }

    private String getParameter(String name) {
        return JavaInfoUtils.getParameter(this.m_javaInfo, name);
    }
}

