/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util.factory;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.IPaletteSite;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.palette.command.factory.FactoryAddCommand;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.description.AbstractInvocationDescription;
import org.eclipse.wb.internal.core.model.description.ConstructorDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.model.variable.NamesManager;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.dialogfields.AbstractValidationTitleAreaDialog;
import org.eclipse.wb.internal.core.utils.dialogfields.ComboDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogFieldUtils;
import org.eclipse.wb.internal.core.utils.dialogfields.IDialogFieldListener;
import org.eclipse.wb.internal.core.utils.dialogfields.IStringButtonAdapter;
import org.eclipse.wb.internal.core.utils.dialogfields.StringButtonDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.StringDialogField;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.jdt.ui.JdtUiUtils;
import org.eclipse.wb.internal.core.utils.jdt.ui.PackageRootAndPackageSelectionDialogField;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryCreateAction
extends Action {
    private final JavaInfo m_component;
    private final AstEditor m_editor;
    private final CreationInfo m_creationInfo = new CreationInfo();
    private final List<InvocationInfo> m_invocations = Lists.newArrayList();
    private IPackageFragmentRoot m_sourceFolder;
    private IPackageFragment m_package;
    private String m_className;
    private String m_qualifiedClassName;
    private String m_methodName;
    private CategoryInfo m_paletteCategory;
    private boolean m_canPreview;
    private List<String> m_generate_methodComments;
    private String m_generate_methodHeader;
    private String m_generate_methodSignature;
    private List<String> m_generate_methodBody;
    private String m_generate_invocationArguments;

    public FactoryCreateAction(JavaInfo component) {
        this.m_component = component;
        this.m_editor = this.m_component.getEditor();
        this.setImageDescriptor(DesignerPlugin.getImageDescriptor((String)"actions/factory/factory_new.png"));
        this.setText(ModelMessages.FactoryCreateAction_text);
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                FactoryCreateAction.this.fillCollections();
            }
        });
    }

    private void fillCollections() {
        if (this.m_component.getCreationSupport() instanceof ConstructorCreationSupport) {
            ConstructorCreationSupport creationSupport = (ConstructorCreationSupport)this.m_component.getCreationSupport();
            ClassInstanceCreation creation = creationSupport.getCreation();
            this.m_creationInfo.m_expression = creation;
            List<Expression> arguments = DomGenerics.arguments(creation);
            ConstructorDescription description = creationSupport.getDescription();
            this.fillArguments(this.m_creationInfo.m_arguments, arguments, description);
        }
        for (ASTNode relatedNode : this.m_component.getRelatedNodes()) {
            if (relatedNode.getLocationInParent() != MethodInvocation.EXPRESSION_PROPERTY) continue;
            MethodInvocation invocation = (MethodInvocation)relatedNode.getParent();
            String signature = AstNodeUtils.getMethodSignature(invocation);
            MethodDescription description = this.m_component.getDescription().getMethod(signature);
            if (description == null || description.hasTrueTag("noFactory")) continue;
            InvocationInfo invocationInfo = new InvocationInfo();
            invocationInfo.m_expression = invocation;
            invocationInfo.m_invocation = invocation;
            invocationInfo.m_signature = signature;
            this.m_invocations.add(invocationInfo);
            List<Expression> arguments = DomGenerics.arguments(invocation);
            this.fillArguments(invocationInfo.m_arguments, arguments, description);
            for (ArgumentInfo argument : invocationInfo.m_arguments) {
                if (!argument.m_hasVariables) continue;
                invocationInfo.m_canExtract = false;
            }
            invocationInfo.m_extract = true;
        }
    }

    private void fillArguments(List<ArgumentInfo> argumentInfos, List<Expression> arguments, AbstractInvocationDescription description) {
        int i = 0;
        while (i < arguments.size()) {
            Expression argument = arguments.get(i);
            ParameterDescription parameter = description.getParameter(i);
            ArgumentInfo argumentInfo = new ArgumentInfo();
            argumentInfo.m_description = parameter;
            argumentInfo.m_expression = argument;
            argumentInfo.m_parameter = argumentInfo.m_hasVariables = FactoryCreateAction.hasVariables(argument);
            argumentInfo.m_source = this.m_editor.getExternalSource((ASTNode)argument, null);
            argumentInfo.m_parameterName = parameter.getName();
            argumentInfos.add(argumentInfo);
            ++i;
        }
    }

    private static boolean hasVariables(Expression expression) {
        final boolean[] hasVariables = new boolean[1];
        expression.accept(new ASTVisitor(){

            public void endVisit(ThisExpression node) {
                hasVariables[0] = hasVariables[0] | true;
            }

            public void endVisit(SimpleName node) {
                hasVariables[0] = hasVariables[0] | AstNodeUtils.isVariable((ASTNode)node);
            }
        });
        return hasVariables[0];
    }

    public void run() {
        FactoryCreateDialog dialog = new FactoryCreateDialog();
        if (dialog.open() == 0) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    FactoryCreateAction.this.generate(true);
                    FactoryCreateAction.this.m_editor.commitChanges();
                }
            });
            IDesignPageSite pageSite = IDesignPageSite.Helper.getSite((ObjectInfo)this.m_component);
            if (pageSite != null) {
                pageSite.reparse();
            }
        }
    }

    private ICompilationUnit findFactoryUnit() throws Exception {
        IPackageFragment currentPackage = (IPackageFragment)this.m_editor.getModelUnit().getParent();
        List<ICompilationUnit> factoryUnits = FactoryDescriptionHelper.getFactoryUnits(this.m_editor, currentPackage);
        return !factoryUnits.isEmpty() ? factoryUnits.get(0) : null;
    }

    private String getFactoryPreviewSource() throws Exception {
        ICompilationUnit factoryUnit = this.m_editor.getModelUnit().getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
        try {
            String className = "__wbp_tmpUnit";
            String source = "";
            PackageDeclaration packageDeclaration = this.m_editor.getAstUnit().getPackage();
            if (packageDeclaration != null) {
                source = String.valueOf(source) + "package " + packageDeclaration.getName().toString() + ";\n";
            }
            source = String.valueOf(source) + StringUtils.join((Object[])new String[]{"class " + className + " {", "  private int ___filler___ = 0;", "}"}, (String)"\n");
            factoryUnit.getBuffer().setContents(source);
            AstEditor factoryEditor = new AstEditor(factoryUnit);
            this.generateFactory(factoryEditor, className);
            TypeDeclaration typeDeclaration = AstNodeUtils.getTypeByName(factoryEditor.getAstUnit(), className);
            String indentation = factoryEditor.getGeneration().getIndentation(1);
            String string = String.valueOf(indentation) + factoryEditor.getSource((ASTNode)typeDeclaration.getMethods()[0]);
            return string;
        }
        finally {
            factoryUnit.discardWorkingCopy();
        }
    }

    private void generate(boolean replaceWithFactory) throws Exception {
        boolean sameCompilationUnit;
        String factoryUnitName = String.valueOf(this.m_className) + ".java";
        ICompilationUnit factoryUnit = this.m_package.getCompilationUnit(factoryUnitName);
        if (!factoryUnit.exists()) {
            String eol = this.m_editor.getGeneration().getEndOfLine();
            String factoryUnitSource = StringUtils.join((Object[])new String[]{"package " + this.m_package.getElementName() + ";", "", "public final class " + this.m_className + " {", "}"}, (String)eol);
            this.m_package.createCompilationUnit(factoryUnitName, factoryUnitSource, false, null);
        }
        AstEditor factoryEditor = (sameCompilationUnit = this.m_editor.getModelUnit().equals(factoryUnit)) ? this.m_editor : new AstEditor(factoryUnit);
        this.generateFactory(factoryEditor, this.m_className);
        factoryUnit.save(null, true);
        factoryUnit.getBuffer().save(null, true);
        ProjectUtils.waitForAutoBuild();
        if (this.m_paletteCategory != null) {
            String id = "custom_" + System.currentTimeMillis();
            String name = this.m_generate_methodSignature;
            String description = "Class: " + this.m_qualifiedClassName + "\nMethod: " + this.m_generate_methodSignature;
            IPaletteSite.Helper.getSite(this.m_component).addCommand(new FactoryAddCommand(id, name, description, true, this.m_qualifiedClassName, this.m_generate_methodSignature, true, this.m_paletteCategory));
        }
        if (replaceWithFactory) {
            String creationSource = "";
            creationSource = String.valueOf(creationSource) + (sameCompilationUnit ? "" : String.valueOf(this.m_qualifiedClassName) + ".") + this.m_methodName;
            creationSource = String.valueOf(creationSource) + "(";
            creationSource = String.valueOf(creationSource) + this.m_generate_invocationArguments;
            creationSource = String.valueOf(creationSource) + ")";
            this.m_editor.replaceExpression(this.m_creationInfo.m_expression, creationSource);
            for (InvocationInfo invocation : this.m_invocations) {
                if (!invocation.m_extract) continue;
                this.m_editor.removeEnclosingStatement((ASTNode)invocation.m_invocation);
            }
        }
    }

    private void generateFactory(AstEditor factoryEditor, String className) throws Exception {
        TypeDeclaration typeDeclaration = AstNodeUtils.getTypeByName(factoryEditor.getAstUnit(), className);
        BodyDeclarationTarget target = new BodyDeclarationTarget(typeDeclaration, false);
        MethodDeclaration methodDeclaration = factoryEditor.addMethodDeclaration(this.m_generate_methodHeader, this.m_generate_methodBody, target);
        factoryEditor.setJavadoc((BodyDeclaration)methodDeclaration, (String[])Iterables.toArray(this.m_generate_methodComments, String.class));
        factoryEditor.commitChanges();
    }

    private void prepareFactoryMethod() {
        Set usedIdentifiers = Sets.newTreeSet();
        String componentTypeName = this.m_component.getDescription().getComponentClass().getName();
        String componentName = FactoryCreateAction.generateUniqueIdentifier(usedIdentifiers, NamesManager.getName(this.m_component));
        this.m_qualifiedClassName = String.valueOf(this.m_package.getElementName()) + "." + this.m_className;
        this.m_generate_methodSignature = String.valueOf(this.m_methodName) + "(";
        this.m_generate_invocationArguments = "";
        this.m_generate_methodComments = Lists.newArrayList();
        this.m_generate_methodComments.add("@wbp.factory");
        String header = "";
        header = String.valueOf(header) + "public static " + this.m_component.getDescription().getComponentClass().getName() + " ";
        header = String.valueOf(header) + this.m_methodName + "(";
        boolean firstParameter = true;
        List parameters = Lists.newArrayList();
        for (ArgumentInfo argument : this.m_creationInfo.m_arguments) {
            if (!argument.m_parameter) continue;
            parameters.add(argument);
        }
        for (InvocationInfo invocation : this.m_invocations) {
            if (!invocation.m_extract) continue;
            for (ArgumentInfo argument : invocation.m_arguments) {
                if (!argument.m_parameter) continue;
                parameters.add(argument);
            }
        }
        for (ArgumentInfo argument : parameters) {
            argument.m_parameterName = argument.m_description.isParent() ? "parent" : FactoryCreateAction.generateUniqueIdentifier(usedIdentifiers, argument.m_description.getName());
            if (!firstParameter) {
                header = String.valueOf(header) + ", ";
                this.m_generate_methodSignature = String.valueOf(this.m_generate_methodSignature) + ",";
                this.m_generate_invocationArguments = String.valueOf(this.m_generate_invocationArguments) + ", ";
            }
            firstParameter = false;
            header = String.valueOf(header) + argument.m_description.getType().getName();
            header = String.valueOf(header) + " ";
            header = String.valueOf(header) + argument.m_parameterName;
            if (!argument.m_description.isParent()) {
                String descriptionSource = argument.m_source;
                if (descriptionSource.equals("getClass()")) {
                    descriptionSource = "{wbp_class}";
                }
                this.m_generate_methodComments.add("@wbp.factory.parameter.source " + argument.m_parameterName + " " + descriptionSource);
            }
            this.m_generate_methodSignature = String.valueOf(this.m_generate_methodSignature) + argument.m_description.getType().getName();
            this.m_generate_invocationArguments = String.valueOf(this.m_generate_invocationArguments) + argument.m_source;
        }
        header = String.valueOf(header) + ")";
        this.m_generate_methodSignature = String.valueOf(this.m_generate_methodSignature) + ")";
        this.m_generate_methodHeader = header;
        String creationSource = this.getFactorySource(this.m_creationInfo);
        List bodyLines = Lists.newArrayList();
        bodyLines.add(String.valueOf(componentTypeName) + " " + componentName + " = " + creationSource + ";");
        for (InvocationInfo invocation : this.m_invocations) {
            if (!invocation.m_extract) continue;
            bodyLines.add(String.valueOf(componentName) + this.getFactorySource(invocation) + ";");
        }
        bodyLines.add("return " + componentName + ";");
        this.m_generate_methodBody = bodyLines;
    }

    private static String generateUniqueIdentifier(final Set<String> usedIdentifiers, String baseName) {
        String newIdentifier = CodeUtils.generateUniqueName(baseName, new Predicate<String>(){

            public boolean apply(String t) {
                return !usedIdentifiers.contains(t);
            }
        });
        usedIdentifiers.add(newIdentifier);
        return newIdentifier;
    }

    private String getFactorySource(final AbstractInvocationInfo invocation) {
        return this.m_editor.getExternalSource((ASTNode)invocation.m_expression, new Function<ASTNode, String>(){

            public String apply(ASTNode from) {
                MethodInvocation invocationNode;
                for (ArgumentInfo argument : invocation.m_arguments) {
                    if (!argument.m_parameter || argument.m_expression != from) continue;
                    return argument.m_parameterName;
                }
                if (from instanceof MethodInvocation && (invocationNode = (MethodInvocation)from).getExpression() == null && invocationNode.getName().getIdentifier().equals("getClass") && invocationNode.arguments().isEmpty()) {
                    TypeDeclaration enclosingType = AstNodeUtils.getEnclosingType((ASTNode)invocationNode);
                    return String.valueOf(AstNodeUtils.getFullyQualifiedName(enclosingType, false)) + ".class";
                }
                if (invocation instanceof InvocationInfo) {
                    InvocationInfo methodInvocation = (InvocationInfo)invocation;
                    if (from == methodInvocation.m_invocation.getExpression()) {
                        return "";
                    }
                }
                return null;
            }
        });
    }

    private String validate() throws Exception {
        this.m_canPreview = false;
        if (this.m_sourceFolder == null || !this.m_sourceFolder.exists()) {
            return ModelMessages.FactoryCreateAction_validateInvalidSourceFolder;
        }
        if (this.m_package == null || !this.m_package.exists()) {
            return ModelMessages.FactoryCreateAction_validateInvalidPackage;
        }
        if (this.m_package.getElementName().length() == 0) {
            return ModelMessages.FactoryCreateAction_validateDefaultPackage;
        }
        this.m_canPreview = true;
        this.prepareFactoryMethod();
        IStatus status = JavaConventions.validateJavaTypeName((String)this.m_className);
        if (this.m_className.length() == 0) {
            return ModelMessages.FactoryCreateAction_validateEmptyClass;
        }
        if (this.m_className.indexOf(46) != -1) {
            return ModelMessages.FactoryCreateAction_validateDotInClass;
        }
        if (status.getSeverity() != 0) {
            return status.getMessage();
        }
        status = JavaConventions.validateMethodName((String)this.m_methodName);
        if (this.m_methodName.length() == 0) {
            return ModelMessages.FactoryCreateAction_validateEmptyMethod;
        }
        if (status.getSeverity() != 0) {
            return status.getMessage();
        }
        IType factoryType = this.m_editor.getJavaProject().findType(this.m_qualifiedClassName);
        if (factoryType != null && CodeUtils.findMethodSingleType(factoryType, this.m_generate_methodSignature) != null) {
            return "Method " + this.m_generate_methodSignature + " already exists.";
        }
        return null;
    }

    private static abstract class AbstractInvocationInfo {
        Expression m_expression;
        List<ArgumentInfo> m_arguments = Lists.newArrayList();

        private AbstractInvocationInfo() {
        }
    }

    private static final class ArgumentInfo {
        ParameterDescription m_description;
        Expression m_expression;
        boolean m_hasVariables = false;
        boolean m_parameter = false;
        String m_source;
        String m_parameterName;

        private ArgumentInfo() {
        }
    }

    private static final class CreationInfo
    extends AbstractInvocationInfo {
        private CreationInfo() {
        }
    }

    private final class FactoryCreateDialog
    extends AbstractValidationTitleAreaDialog {
        private List<CategoryInfo> m_paletteCategories;
        private PackageRootAndPackageSelectionDialogField m_packageField;
        private StringButtonDialogField m_classField;
        private StringDialogField m_methodField;
        private ComboDialogField m_categoryField;
        private SourceViewer m_previewViewer;
        private static final int CREATE_ID = 1025;
        private Composite m_fieldsContainer;

        public FactoryCreateDialog() {
            super(DesignerPlugin.getShell(), (AbstractUIPlugin)DesignerPlugin.getDefault(), ModelMessages.FactoryCreateAction_dialogShellTitle, ModelMessages.FactoryCreateAction_dialogTitle, DesignerPlugin.getImage((String)"actions/factory/factory_banner.png"), ModelMessages.FactoryCreateAction_dialogMessage);
            this.setShellStyle(67696);
        }

        protected void createControls(Composite container) {
            this.m_fieldsContainer = container;
            GridLayoutFactory.create((Composite)container).columns(3);
            this.createParametersComposite(container);
            Label separator = new Label(container, 258);
            GridDataFactory.create((Control)separator).spanH(3).hintVC(1).grabH().fillH();
            SashForm sashForm = new SashForm(container, 512);
            GridDataFactory.create((Control)sashForm).spanH(3).grab().fill();
            this.createArgumentsInvocationsComposite((Composite)sashForm);
            this.createPreviewComposite((Composite)sashForm);
            sashForm.setWeights(new int[]{1, 1});
        }

        private void createParametersComposite(Composite parent) {
            this.m_packageField = new PackageRootAndPackageSelectionDialogField(60, ModelMessages.FactoryCreateAction_dialogPackageSourceFolder, ModelMessages.FactoryCreateAction_dialogPackageSourceFolderBrowse, ModelMessages.FactoryCreateAction_dialogPackagePackage, ModelMessages.FactoryCreateAction_dialogPackagePackageBrowse);
            this.m_packageField.setDialogFieldListener(this.m_validateListener);
            this.m_packageField.doFillIntoGrid(this.m_fieldsContainer, 3);
            this.m_packageField.setPackage((IPackageFragment)FactoryCreateAction.this.m_editor.getModelUnit().getParent());
            this.m_classField = new StringButtonDialogField(new IStringButtonAdapter(){

                public void changeControlPressed(DialogField field) {
                    ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                        public void run() throws Exception {
                            IType type = JdtUiUtils.selectClassType(FactoryCreateDialog.this.getShell(), FactoryCreateAction.this.m_editor.getJavaProject());
                            if (type != null) {
                                ICompilationUnit compilationUnit = type.getCompilationUnit();
                                FactoryCreateDialog.this.m_classField.setTextWithoutUpdate(type.getElementName());
                                FactoryCreateDialog.this.m_packageField.setPackage((IPackageFragment)compilationUnit.getParent());
                            }
                        }
                    });
                }
            });
            this.m_classField.setButtonLabel(ModelMessages.FactoryCreateAction_classBrowse);
            this.doCreateField((DialogField)this.m_classField, ModelMessages.FactoryCreateAction_classLabel);
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    ICompilationUnit factoryUnit = FactoryCreateAction.this.findFactoryUnit();
                    if (factoryUnit != null) {
                        FactoryCreateDialog.this.m_classField.setText(factoryUnit.findPrimaryType().getElementName());
                    } else {
                        FactoryCreateDialog.this.m_classField.setFocus();
                    }
                }
            });
            this.m_methodField = new StringDialogField();
            this.doCreateField((DialogField)this.m_methodField, ModelMessages.FactoryCreateAction_methodLabel);
            this.m_methodField.setText("create" + CodeUtils.getShortClass(FactoryCreateAction.this.m_component.getDescription().getComponentClass().getName()));
            this.m_categoryField = new ComboDialogField(8);
            this.m_categoryField.setLabelText(ModelMessages.FactoryCreateAction_paletteCategoryLabel);
            this.m_categoryField.setDialogFieldListener(new IDialogFieldListener(){

                public void dialogFieldChanged(DialogField field) {
                    if (FactoryCreateDialog.this.m_paletteCategories != null) {
                        int selectionIndex = FactoryCreateDialog.this.m_categoryField.getSelectionIndex();
                        if (selectionIndex >= 1) {
                            FactoryCreateAction.this.m_paletteCategory = (CategoryInfo)FactoryCreateDialog.this.m_paletteCategories.get(selectionIndex - 1);
                        } else {
                            FactoryCreateAction.this.m_paletteCategory = null;
                        }
                    }
                }
            });
            DialogFieldUtils.fillControls((Composite)this.m_fieldsContainer, (DialogField)this.m_categoryField, (int)2, (int)40);
            this.fillPaletteCategories();
            this.m_categoryField.selectItem(0);
            Button managerButton = new Button(this.m_fieldsContainer, 0);
            GridDataFactory.create((Control)managerButton).fillH();
            managerButton.setText(ModelMessages.FactoryCreateAction_paletteManagerButton);
            managerButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    IPaletteSite.Helper.getSite(FactoryCreateAction.this.m_component).editPalette();
                    FactoryCreateDialog.this.fillPaletteCategories();
                }
            });
        }

        private void createArgumentsInvocationsComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayoutFactory.create((Composite)composite).noMargins();
            new Label(composite, 0).setText(ModelMessages.FactoryCreateAction_dialogArgumentsHint);
            Tree tree = new Tree(composite, 2080);
            GridDataFactory.create((Control)tree).hintC(150, 12).grab().fill();
            tree.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 32) {
                        TreeItem item = (TreeItem)event.item;
                        if (item.getGrayed()) {
                            item.setChecked(!item.getChecked());
                            return;
                        }
                        if (item.getData() instanceof InvocationInfo) {
                            InvocationInfo invocation = (InvocationInfo)item.getData();
                            invocation.m_extract = item.getChecked();
                        } else if (item.getData() instanceof ArgumentInfo) {
                            ArgumentInfo argument = (ArgumentInfo)item.getData();
                            if (argument.m_hasVariables) {
                                item.setChecked(true);
                                return;
                            }
                            argument.m_parameter = item.getChecked();
                        }
                        FactoryCreateDialog.this.validateAll();
                    }
                }
            });
            TreeItem creationItem = new TreeItem(tree, 0);
            creationItem.setImage(DesignerPlugin.getImage((String)"actions/factory/folder.png"));
            creationItem.setText(ModelMessages.FactoryCreateAction_dialogArgumentsCreation);
            creationItem.setGrayed(true);
            creationItem.setChecked(true);
            for (ArgumentInfo argument : ((FactoryCreateAction)FactoryCreateAction.this).m_creationInfo.m_arguments) {
                TreeItem item = new TreeItem(creationItem, 0);
                item.setData((Object)argument);
                item.setImage(DesignerPlugin.getImage((String)"actions/factory/argument_can_parameter.gif"));
                item.setText(String.valueOf(argument.m_parameterName) + " = " + argument.m_source);
                if (!argument.m_hasVariables) continue;
                item.setImage(DesignerPlugin.getImage((String)"actions/factory/argument_must_parameter.gif"));
                item.setChecked(true);
            }
            TreeItem invocationsItem = new TreeItem(tree, 0);
            invocationsItem.setText(ModelMessages.FactoryCreateAction_dialogArgumentsInvocations);
            invocationsItem.setImage(DesignerPlugin.getImage((String)"actions/factory/folder.png"));
            invocationsItem.setGrayed(true);
            invocationsItem.setChecked(true);
            for (InvocationInfo invocation : FactoryCreateAction.this.m_invocations) {
                if (!invocation.m_canExtract) continue;
                TreeItem invocationItem = new TreeItem(invocationsItem, 0);
                invocationItem.setData((Object)invocation);
                invocationItem.setImage(DesignerPlugin.getImage((String)"actions/factory/invocation.gif"));
                invocationItem.setText(invocation.m_signature);
                invocationItem.setChecked(invocation.m_extract);
                for (ArgumentInfo argument : invocation.m_arguments) {
                    TreeItem item = new TreeItem(invocationItem, 0);
                    item.setData((Object)argument);
                    item.setImage(DesignerPlugin.getImage((String)"actions/factory/argument_can_parameter.gif"));
                    item.setText(String.valueOf(argument.m_parameterName) + " = " + argument.m_source);
                }
            }
            UiUtils.expandAll((Tree)tree);
        }

        private void createPreviewComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayoutFactory.create((Composite)composite).noMargins();
            new Label(composite, 0).setText(ModelMessages.FactoryCreateAction_dialogPreview);
            this.m_previewViewer = JdtUiUtils.createJavaSourceViewer(composite, 2816);
            GridDataFactory.create((Control)this.m_previewViewer.getControl()).hintVC(12).grab().fill();
        }

        private void fillPaletteCategories() {
            CategoryInfo selectedCategory = FactoryCreateAction.this.m_paletteCategory;
            this.m_categoryField.setItems(new String[0]);
            this.m_categoryField.addItem(ModelMessages.FactoryCreateAction_dialogCategoryNo);
            IPaletteSite paletteSite = IPaletteSite.Helper.getSite(FactoryCreateAction.this.m_component);
            if (paletteSite != null) {
                PaletteInfo palette = paletteSite.getPalette();
                this.m_paletteCategories = palette.getCategories();
                for (CategoryInfo category : this.m_paletteCategories) {
                    this.m_categoryField.addItem(category.getName());
                }
            }
            UiUtils.setVisibleItemCount((Combo)this.m_categoryField.getComboControl(null), (int)this.m_categoryField.getItemCount());
            this.m_categoryField.selectItem(0);
            if (selectedCategory != null) {
                this.m_categoryField.selectItem(selectedCategory.getName());
            }
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 1025, ModelMessages.FactoryCreateAction_dialogCreateButton, false);
            super.createButtonsForButtonBar(parent);
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            if (buttonId == 1025) {
                ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        FactoryCreateAction.this.generate(false);
                        FactoryCreateDialog.this.validateAll();
                    }
                });
            }
        }

        protected String validate() throws Exception {
            FactoryCreateAction.this.m_sourceFolder = this.m_packageField.getRoot();
            FactoryCreateAction.this.m_package = this.m_packageField.getPackage();
            FactoryCreateAction.this.m_className = this.m_classField.getText();
            FactoryCreateAction.this.m_methodName = this.m_methodField.getText();
            String message = FactoryCreateAction.this.validate();
            if (FactoryCreateAction.this.m_canPreview) {
                ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        JdtUiUtils.setJavaSourceForViewer(FactoryCreateDialog.this.m_previewViewer, FactoryCreateAction.this.getFactoryPreviewSource());
                    }
                });
            } else {
                JdtUiUtils.setJavaSourceForViewer(this.m_previewViewer, ModelMessages.FactoryCreateAction_dialogNoPreview);
            }
            return message;
        }

        protected void setValid(boolean enabled) {
            super.setValid(enabled);
            Button button = this.getButton(1025);
            button.setEnabled(enabled);
        }

        protected final void doCreateField(DialogField dialogField, String labelText) {
            dialogField.setLabelText(labelText);
            dialogField.setDialogFieldListener(this.m_validateListener);
            DialogFieldUtils.fillControls((Composite)this.m_fieldsContainer, (DialogField)dialogField, (int)3, (int)40);
        }
    }

    private static final class InvocationInfo
    extends AbstractInvocationInfo {
        MethodInvocation m_invocation;
        boolean m_canExtract = true;
        boolean m_extract = false;
        String m_signature;

        private InvocationInfo() {
        }
    }
}

