/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.description.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.property.IConfigurablePropertyObject;

public abstract class AbstractConfigurableDescription {
    private final Map<String, Object> m_parameters = Maps.newHashMap();

    public final void addParameter(String name, String value) {
        Assert.isTrue((!this.m_parameters.containsKey(name) ? 1 : 0) != 0, (String)MessageFormat.format("Duplicate declaration of parameter ''{0}''.", name));
        this.m_parameters.put(name, value);
    }

    public final void addListParameter(String name, String value) {
        List list = (List)this.m_parameters.get(name);
        if (list == null) {
            list = Lists.newArrayList();
            this.m_parameters.put(name, list);
        }
        list.add(value);
    }

    public final void configure(EditorContext context, IConfigurablePropertyObject configurableObject) throws Exception {
        configurableObject.configure(context, this.m_parameters);
    }
}

