/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.findReferences;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.core.findReferences.Declarators;
import org.eclipse.xtend.core.jvmmodel.AnonymousClassUtil;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.ReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.imports.StaticallyImportedMemberProvider;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XtypePackage;

public class XtendReferenceFinder
extends ReferenceFinder {
    @Inject
    @Extension
    private StaticallyImportedMemberProvider _staticallyImportedMemberProvider;
    @Inject
    @Extension
    private AnonymousClassUtil _anonymousClassUtil;
    @Inject
    private Declarators declarators;

    public void findReferencesInDescription(final TargetURIs targetURIs, final IResourceDescription resourceDescription, IReferenceFinder.IResourceAccess resourceAccess, final IReferenceFinder.Acceptor acceptor, final IProgressMonitor monitor) {
        Declarators.DeclaratorsData _declaratorData = this.declarators.getDeclaratorData(targetURIs, resourceAccess);
        Set<QualifiedName> names = _declaratorData.getDeclaratorNames();
        boolean _isCanceled = monitor.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        Iterable _importedNames = resourceDescription.getImportedNames();
        final Set importedNames = IterableExtensions.toSet((Iterable)_importedNames);
        Functions.Function1<QualifiedName, Boolean> _function = new Functions.Function1<QualifiedName, Boolean>(){

            public Boolean apply(QualifiedName it) {
                return importedNames.contains(it);
            }
        };
        boolean _exists = IterableExtensions.exists(names, (Functions.Function1)_function);
        if (_exists) {
            URI _uRI = resourceDescription.getURI();
            IUnitOfWork<Object, ResourceSet> _function_1 = new IUnitOfWork<Object, ResourceSet>(){

                public Object exec(ResourceSet it) throws Exception {
                    URI _uRI = resourceDescription.getURI();
                    Resource _resource = it.getResource(_uRI, true);
                    XtendReferenceFinder.this.findReferences(targetURIs, _resource, acceptor, monitor);
                    return null;
                }
            };
            resourceAccess.readOnly(_uRI, (IUnitOfWork)_function_1);
        }
    }

    protected void findLocalReferencesFromElement(TargetURIs targetURIs, EObject sourceCandidate, Resource localResource, IReferenceFinder.Acceptor acceptor) {
        boolean _not;
        boolean _isStatic;
        boolean _and;
        boolean _isPackageFragment;
        boolean _matched = false;
        if (!_matched && sourceCandidate instanceof XAbstractFeatureCall && (_isPackageFragment = ((XAbstractFeatureCall)sourceCandidate).isPackageFragment())) {
            _matched = true;
            return;
        }
        super.findLocalReferencesFromElement(targetURIs, sourceCandidate, localResource, acceptor);
        boolean _matched_1 = false;
        if (!_matched_1 && sourceCandidate instanceof XImportDeclaration) {
            boolean _isWildcard;
            _and = false;
            _isStatic = ((XImportDeclaration)sourceCandidate).isStatic();
            _and = !_isStatic ? false : (_not = !(_isWildcard = ((XImportDeclaration)sourceCandidate).isWildcard()));
            if (_and) {
                _matched_1 = true;
                this.addReferenceToFeatureFromStaticImport((XImportDeclaration)sourceCandidate, targetURIs, acceptor);
            }
        }
        if (!_matched_1 && sourceCandidate instanceof XFeatureCall) {
            boolean _isStatic2;
            _and = false;
            XExpression _actualReceiver = ((XFeatureCall)sourceCandidate).getActualReceiver();
            boolean _equals = Objects.equal((Object)_actualReceiver, null);
            _and = !_equals ? false : (_isStatic2 = ((XFeatureCall)sourceCandidate).isStatic());
            if (_and) {
                _matched_1 = true;
                this.addReferenceToTypeFromStaticImport((XAbstractFeatureCall)sourceCandidate, targetURIs, acceptor);
            }
        }
        if (!_matched_1 && sourceCandidate instanceof XMemberFeatureCall) {
            boolean _isStaticWithDeclaringType;
            _matched_1 = true;
            _and = false;
            _isStatic = ((XMemberFeatureCall)sourceCandidate).isStatic();
            _and = !_isStatic ? false : (_not = !(_isStaticWithDeclaringType = ((XMemberFeatureCall)sourceCandidate).isStaticWithDeclaringType()));
            if (_and) {
                this.addReferenceToTypeFromStaticImport((XAbstractFeatureCall)sourceCandidate, targetURIs, acceptor);
            }
        }
        if (!_matched_1 && sourceCandidate instanceof AnonymousClass) {
            _matched_1 = true;
            this.addReferencesToSuper((AnonymousClass)sourceCandidate, targetURIs, acceptor);
        }
    }

    protected void addReferencesToSuper(AnonymousClass anonymousClass, TargetURIs targetURISet, IReferenceFinder.Acceptor acceptor) {
        JvmConstructor superConstructor;
        XConstructorCall constructorCall = anonymousClass.getConstructorCall();
        JvmGenericType superType = this._anonymousClassUtil.getSuperType(anonymousClass);
        if (superType != null) {
            this.addReferenceIfTarget((EObject)superType, targetURISet, (EObject)constructorCall, XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, acceptor);
        }
        if ((superConstructor = this._anonymousClassUtil.getSuperTypeConstructor(anonymousClass)) != null) {
            this.addReferenceIfTarget((EObject)superConstructor, targetURISet, (EObject)constructorCall, XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, acceptor);
        }
    }

    protected void addReferenceToFeatureFromStaticImport(final XImportDeclaration importDeclaration, final TargetURIs targetURISet, final IReferenceFinder.Acceptor acceptor) {
        Iterable _allFeatures = this._staticallyImportedMemberProvider.getAllFeatures(importDeclaration);
        Procedures.Procedure1<JvmFeature> _function = new Procedures.Procedure1<JvmFeature>(){

            public void apply(JvmFeature it) {
                XtendReferenceFinder.this.addReferenceIfTarget((EObject)it, targetURISet, (EObject)importDeclaration, XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE, acceptor);
            }
        };
        IterableExtensions.forEach((Iterable)_allFeatures, (Procedures.Procedure1)_function);
    }

    protected void addReferenceToTypeFromStaticImport(XAbstractFeatureCall sourceCandidate, TargetURIs targetURISet, IReferenceFinder.Acceptor acceptor) {
        JvmIdentifiableElement feature = sourceCandidate.getFeature();
        if (feature instanceof JvmMember) {
            JvmDeclaredType type = ((JvmMember)feature).getDeclaringType();
            this.addReferenceIfTarget((EObject)type, targetURISet, (EObject)sourceCandidate, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, acceptor);
        }
    }

    protected void addReferenceIfTarget(EObject candidate, TargetURIs targetURISet, EObject sourceElement, EReference reference, IReferenceFinder.Acceptor acceptor) {
        URI candidateURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)candidate);
        boolean _contains = targetURISet.contains(candidateURI);
        if (_contains) {
            URI sourceURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)sourceElement);
            acceptor.accept(sourceElement, sourceURI, reference, -1, candidate, candidateURI);
        }
    }
}

