/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.jvmmodel;

import com.google.common.collect.Iterables;
import com.google.inject.ImplementedBy;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendEnumLiteral;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.JvmModelAssociator;

@ImplementedBy(value=Impl.class)
public interface IXtendJvmAssociations
extends IJvmModelAssociations {
    public JvmDeclaredType getInferredType(XtendTypeDeclaration var1);

    public JvmGenericType getInferredType(AnonymousClass var1);

    public JvmGenericType getInferredType(XtendClass var1);

    public JvmGenericType getInferredType(XtendInterface var1);

    public JvmAnnotationType getInferredAnnotationType(XtendAnnotationType var1);

    public JvmEnumerationType getInferredEnumerationType(XtendEnum var1);

    public JvmConstructor getInferredConstructor(XtendClass var1);

    public JvmConstructor getInferredConstructor(XtendConstructor var1);

    public JvmOperation getDirectlyInferredOperation(XtendFunction var1);

    public JvmOperation getDispatchOperation(XtendFunction var1);

    public JvmField getJvmField(XtendField var1);

    public JvmField getJvmField(XtendEnumLiteral var1);

    public JvmFormalParameter getJvmParameter(XtendParameter var1);

    public XtendClass getXtendClass(JvmGenericType var1);

    public XtendInterface getXtendInterface(JvmGenericType var1);

    public XtendFunction getXtendFunction(JvmOperation var1);

    public XtendConstructor getXtendConstructor(JvmConstructor var1);

    public XtendField getXtendField(JvmField var1);

    public AnonymousClass getAnonymousClass(JvmDeclaredType var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    public static class Impl
    extends JvmModelAssociator
    implements IXtendJvmAssociations {
        @Override
        public JvmDeclaredType getInferredType(XtendTypeDeclaration xtendType) {
            JvmDeclaredType firstOrNull = this.getFirstOrNull(this.getJvmElements(xtendType), JvmDeclaredType.class);
            return firstOrNull;
        }

        @Override
        public JvmGenericType getInferredType(AnonymousClass anonymousClass) {
            JvmGenericType firstOrNull = this.getFirstOrNull(this.getJvmElements(anonymousClass), JvmGenericType.class);
            return firstOrNull;
        }

        @Override
        public JvmGenericType getInferredType(XtendClass xtendClass) {
            JvmGenericType firstOrNull = this.getFirstOrNull(this.getJvmElements(xtendClass), JvmGenericType.class);
            return firstOrNull;
        }

        @Override
        public JvmGenericType getInferredType(XtendInterface xtendInterface) {
            JvmGenericType firstOrNull = this.getFirstOrNull(this.getJvmElements(xtendInterface), JvmGenericType.class);
            return firstOrNull;
        }

        @Override
        public JvmAnnotationType getInferredAnnotationType(XtendAnnotationType xtendAnnotation) {
            JvmAnnotationType firstOrNull = this.getFirstOrNull(this.getJvmElements(xtendAnnotation), JvmAnnotationType.class);
            return firstOrNull;
        }

        @Override
        public JvmEnumerationType getInferredEnumerationType(XtendEnum xtendEnum) {
            JvmEnumerationType firstOrNull = this.getFirstOrNull(this.getJvmElements(xtendEnum), JvmEnumerationType.class);
            return firstOrNull;
        }

        @Override
        public JvmConstructor getInferredConstructor(XtendClass xtendClass) {
            JvmConstructor firstOrNull = this.getFirstOrNull(this.getJvmElements(xtendClass), JvmConstructor.class);
            return firstOrNull;
        }

        @Override
        public JvmConstructor getInferredConstructor(XtendConstructor xtendConstructor) {
            JvmConstructor firstOrNull = this.getFirstOrNull(this.getJvmElements(xtendConstructor), JvmConstructor.class);
            return firstOrNull;
        }

        @Override
        public JvmOperation getDirectlyInferredOperation(XtendFunction xtendFunction) {
            Iterable jvmElements = Iterables.filter((Iterable)this.getJvmElements(xtendFunction), JvmOperation.class);
            String expectedName = xtendFunction.getName();
            if (xtendFunction.isDispatch()) {
                expectedName = "_" + expectedName;
            }
            for (JvmOperation jvmOperation : jvmElements) {
                if (!jvmOperation.getSimpleName().equals(expectedName)) continue;
                return jvmOperation;
            }
            return null;
        }

        @Override
        public JvmOperation getDispatchOperation(XtendFunction dispatchFunction) {
            if (!dispatchFunction.isDispatch()) {
                throw new IllegalArgumentException("Function " + dispatchFunction.getName() + " is not a dispatch function");
            }
            Set jvmElements = this.getJvmElements(dispatchFunction);
            for (EObject candidate : jvmElements) {
                if (!(candidate instanceof JvmOperation) || !dispatchFunction.getName().equals(((JvmOperation)candidate).getSimpleName())) continue;
                return (JvmOperation)candidate;
            }
            return null;
        }

        @Override
        public XtendClass getXtendClass(JvmGenericType jvmType) {
            EObject primarySourceElement = this.getPrimarySourceElement((EObject)jvmType);
            if (primarySourceElement instanceof XtendClass) {
                return (XtendClass)primarySourceElement;
            }
            return null;
        }

        @Override
        public AnonymousClass getAnonymousClass(JvmDeclaredType type) {
            EObject primarySourceElement = this.getPrimarySourceElement((EObject)type);
            if (primarySourceElement instanceof AnonymousClass) {
                return (AnonymousClass)primarySourceElement;
            }
            return null;
        }

        @Override
        public XtendInterface getXtendInterface(JvmGenericType jvmType) {
            EObject primarySourceElement = this.getPrimarySourceElement((EObject)jvmType);
            if (primarySourceElement instanceof XtendInterface) {
                return (XtendInterface)primarySourceElement;
            }
            return null;
        }

        @Override
        public XtendFunction getXtendFunction(JvmOperation jvmOperation) {
            return (XtendFunction)this.getPrimarySourceElement((EObject)jvmOperation);
        }

        @Override
        public XtendConstructor getXtendConstructor(JvmConstructor jvmConstructor) {
            EObject primarySourceElement = this.getPrimarySourceElement((EObject)jvmConstructor);
            return primarySourceElement instanceof XtendConstructor ? (XtendConstructor)primarySourceElement : null;
        }

        protected <T> T getFirstOrNull(Iterable<EObject> elements, Class<T> type) {
            Iterator iterator = Iterables.filter(elements, type).iterator();
            return iterator.hasNext() ? (T)iterator.next() : null;
        }

        @Override
        public JvmField getJvmField(XtendField field) {
            return this.getFirstOrNull(this.getJvmElements(field), JvmField.class);
        }

        @Override
        public JvmField getJvmField(XtendEnumLiteral field) {
            return this.getFirstOrNull(this.getJvmElements(field), JvmField.class);
        }

        @Override
        public JvmFormalParameter getJvmParameter(XtendParameter parameter) {
            return this.getFirstOrNull(this.getJvmElements(parameter), JvmFormalParameter.class);
        }

        @Override
        public XtendField getXtendField(JvmField jvmField) {
            EObject primarySourceElement = this.getPrimarySourceElement((EObject)jvmField);
            if (primarySourceElement instanceof XtendField) {
                return (XtendField)primarySourceElement;
            }
            return null;
        }

        protected JvmIdentifiableElement getLogicalContainer(EObject object, boolean considerContainer) {
            if (object == null) {
                return null;
            }
            Map mapping = this.getLogicalContainerMapping(object.eResource());
            do {
                Set elements;
                XtendMember member;
                if (mapping.containsKey(object)) {
                    return (JvmIdentifiableElement)mapping.get(object);
                }
                EObject container = object.eContainer();
                if (container == null) {
                    return null;
                }
                if (object instanceof XtendMember && (container instanceof XtendMember ? (member = (XtendMember)container).getAnnotationInfo() != object : !(object instanceof AnonymousClass))) {
                    return null;
                }
                if (!mapping.containsKey(container) && !(elements = this.getJvmElements(container)).isEmpty()) {
                    for (EObject eObject : elements) {
                        if (!(eObject instanceof JvmIdentifiableElement)) continue;
                        return (JvmIdentifiableElement)eObject;
                    }
                }
                object = container;
            } while (considerContainer);
            return null;
        }
    }
}

