/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.richstring;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.eclipse.xtend.core.richstring.IRichStringIndentationHandler;
import org.eclipse.xtend.core.richstring.IRichStringPartAcceptor;

public class DefaultIndentationHandler
implements IRichStringIndentationHandler {
    private LinkedList<IndentationData> indentationData = Lists.newLinkedList();
    private LinkedList<LinkedList<IndentationData>> indentationDataStack = Lists.newLinkedList();

    public DefaultIndentationHandler() {
        this.indentationDataStack.add(this.indentationData);
    }

    public void popIndentation() {
        this.indentationData.removeLast();
        if (this.indentationData.isEmpty() && this.indentationDataStack.size() > 1) {
            this.indentationDataStack.removeLast();
            this.indentationData = this.indentationDataStack.getLast();
        }
    }

    public void pushTemplateIndentation(CharSequence indentation) {
        if (this.indentationData.isEmpty()) {
            this.indentationData.add(new TemplateIndentationData(indentation));
        } else {
            String currentIndentation = this.getTotalIndentation();
            if (indentation.toString().startsWith(currentIndentation)) {
                String trimmedIndentation = indentation.toString().substring(currentIndentation.length());
                this.indentationData.add(new TemplateIndentationData(trimmedIndentation));
            } else {
                LinkedList newIndentationData = Lists.newLinkedList();
                newIndentationData.add(new TemplateIndentationData(indentation));
                this.indentationDataStack.add(newIndentationData);
                this.indentationData = newIndentationData;
            }
        }
    }

    public void pushSemanticIndentation(CharSequence indentation) {
        if (this.indentationData.isEmpty()) {
            this.indentationData.add(new SemanticIndentationData(indentation));
        } else {
            String currentIndentation = this.getTotalIndentation();
            if (indentation.toString().startsWith(currentIndentation)) {
                String trimmedIndentation = indentation.toString().substring(currentIndentation.length());
                this.indentationData.add(new SemanticIndentationData(trimmedIndentation));
            } else {
                LinkedList newIndentationData = Lists.newLinkedList();
                newIndentationData.add(new SemanticIndentationData(indentation));
                this.indentationDataStack.add(newIndentationData);
                this.indentationData = newIndentationData;
            }
        }
    }

    public CharSequence getTotalSemanticIndentation() {
        StringBuilder result = new StringBuilder();
        for (IndentationData data : this.indentationData) {
            if (!(data instanceof SemanticIndentationData)) continue;
            result.append(data.value);
        }
        return result.toString();
    }

    public String getTotalIndentation() {
        StringBuilder result = new StringBuilder();
        for (IndentationData data : this.indentationData) {
            result.append(data.value);
        }
        return result.toString();
    }

    public void accept(IRichStringPartAcceptor acceptor) {
        for (IndentationData data : this.indentationData) {
            data.accept(acceptor);
        }
    }

    protected static abstract class IndentationData {
        protected CharSequence value;

        protected IndentationData(CharSequence value) {
            this.value = value;
        }

        protected abstract void accept(IRichStringPartAcceptor var1);

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " [" + this.value + "]";
        }
    }

    protected static class SemanticIndentationData
    extends IndentationData {
        protected SemanticIndentationData(CharSequence value) {
            super(value);
        }

        protected void accept(IRichStringPartAcceptor acceptor) {
            acceptor.acceptSemanticText(this.value, null);
        }
    }

    protected static class TemplateIndentationData
    extends IndentationData {
        protected TemplateIndentationData(CharSequence value) {
            super(value);
        }

        protected void accept(IRichStringPartAcceptor acceptor) {
            acceptor.acceptTemplateText(this.value, null);
        }
    }
}

