/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.jdt;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.xtext.common.types.access.AbstractTypeProviderFactory;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.access.jdt.IJdtTypeProvider;
import org.eclipse.xtext.common.types.access.jdt.IWorkingCopyOwnerProvider;
import org.eclipse.xtext.common.types.access.jdt.JdtTypeProvider;
import org.eclipse.xtext.common.types.access.jdt.NullJdtTypeProvider;

@Singleton
public class JdtTypeProviderFactory
extends AbstractTypeProviderFactory {
    @Inject
    private IJavaProjectProvider javaProjectProvider;
    @Inject
    private IWorkingCopyOwnerProvider copyOwnerProvider;

    public JdtTypeProviderFactory() {
    }

    public JdtTypeProviderFactory(IJavaProjectProvider javaProjectProvider) {
        this.javaProjectProvider = javaProjectProvider;
    }

    public IJdtTypeProvider createTypeProvider(ResourceSet resourceSet) {
        if (resourceSet == null) {
            throw new IllegalArgumentException("resourceSet may not be null.");
        }
        IJavaProject javaProject = this.javaProjectProvider.getJavaProject(resourceSet);
        IJdtTypeProvider result = this.createJdtTypeProvider(javaProject, resourceSet);
        return result;
    }

    protected IJdtTypeProvider createJdtTypeProvider(IJavaProject javaProject, ResourceSet resourceSet) {
        if (javaProject == null) {
            return new NullJdtTypeProvider(resourceSet);
        }
        return new JdtTypeProvider(javaProject, resourceSet, this.getIndexedJvmTypeAccess(), (WorkingCopyOwner)(this.copyOwnerProvider == null ? DefaultWorkingCopyOwner.PRIMARY : this.copyOwnerProvider.getWorkingCopyOwner(javaProject, resourceSet)));
    }

    public IJdtTypeProvider createTypeProvider() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

