/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.os;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.os.ExecutableFinder;
import org.openqa.selenium.os.OsProcess;
import org.openqa.selenium.os.UnixProcess;

public class CommandLine {
    private OsProcess process;

    public CommandLine(String executable, String ... args) {
        this.process = new UnixProcess(executable, args);
    }

    public CommandLine(String[] cmdarray) {
        String executable = cmdarray[0];
        int length = cmdarray.length - 1;
        String[] args = new String[length];
        System.arraycopy(cmdarray, 1, args, 0, length);
        this.process = new UnixProcess(executable, args);
    }

    @VisibleForTesting
    Map<String, String> getEnvironment() {
        return this.process.getEnvironment();
    }

    public void setEnvironmentVariables(Map<String, String> environment) {
        for (Map.Entry<String, String> entry : environment.entrySet()) {
            this.setEnvironmentVariable(entry.getKey(), entry.getValue());
        }
    }

    public void setEnvironmentVariable(String name, String value) {
        this.process.setEnvironmentVariable(name, value);
    }

    public void setDynamicLibraryPath(String newLibraryPath) {
        if (newLibraryPath != null) {
            this.setEnvironmentVariable(CommandLine.getLibraryPathPropertyName(), newLibraryPath);
        }
    }

    public static String getLibraryPathPropertyName() {
        switch (Platform.getCurrent()) {
            case MAC: {
                return "DYLD_LIBRARY_PATH";
            }
            case WINDOWS: 
            case XP: 
            case VISTA: {
                return "PATH";
            }
        }
        return "LD_LIBRARY_PATH";
    }

    @Deprecated
    public static String find(String executable) {
        return new ExecutableFinder().find(executable);
    }

    public void executeAsync() {
        this.process.executeAsync();
    }

    public void execute() {
        this.executeAsync();
        this.waitFor();
    }

    public void waitFor() {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new WebDriverException(e);
        }
    }

    public boolean isSuccessful() {
        return this.getExitCode() == 0;
    }

    public int getExitCode() {
        return this.process.getExitCode();
    }

    public String getStdOut() {
        return this.process.getStdOut();
    }

    public int destroy() {
        return this.process.destroy();
    }

    public void setInput(String allInput) {
        this.process.setInput(allInput);
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.process.setWorkingDirectory(new File(workingDirectory));
    }

    public String toString() {
        return this.process.toString();
    }

    public void copyOutputTo(OutputStream out) {
        this.process.copyOutputTo(out);
    }
}

