/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.responseprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.search.Grouping;
import org.apache.solr.search.grouping.distributed.ShardResponseProcessor;
import org.apache.solr.search.grouping.distributed.command.QueryCommandResult;
import org.apache.solr.search.grouping.distributed.shardresultserializer.TopGroupsResultTransformer;

public class TopGroupsShardResponseProcessor
implements ShardResponseProcessor {
    public void process(ResponseBuilder rb, ShardRequest shardRequest) {
        Sort groupSort = rb.getGroupingSpec().getGroupSort();
        String[] fields = rb.getGroupingSpec().getFields();
        String[] queries = rb.getGroupingSpec().getQueries();
        Sort sortWithinGroup = rb.getGroupingSpec().getSortWithinGroup();
        int groupOffsetDefault = rb.getGroupingSpec().getResponseFormat() == Grouping.Format.simple || rb.getGroupingSpec().isMain() ? 0 : rb.getGroupingSpec().getGroupOffset();
        int docsPerGroupDefault = rb.getGroupingSpec().getGroupLimit();
        HashMap commandTopGroups = new HashMap();
        for (String field : fields) {
            commandTopGroups.put(field, new ArrayList());
        }
        HashMap commandTopDocs = new HashMap();
        for (String query : queries) {
            commandTopDocs.put(query, new ArrayList());
        }
        TopGroupsResultTransformer serializer = new TopGroupsResultTransformer(rb);
        for (ShardResponse srsp : shardRequest.responses) {
            NamedList secondPhaseResult = (NamedList)srsp.getSolrResponse().getResponse().get("secondPhase");
            Object result = serializer.transformToNative(secondPhaseResult, groupSort, sortWithinGroup, srsp.getShard());
            for (String field : commandTopGroups.keySet()) {
                TopGroups topGroups = (TopGroups)result.get(field);
                if (topGroups == null) continue;
                ((List)commandTopGroups.get(field)).add(topGroups);
            }
            for (String query : queries) {
                ((List)commandTopDocs.get(query)).add((QueryCommandResult)result.get(query));
            }
        }
        try {
            for (String groupField : commandTopGroups.keySet()) {
                List topGroups = (List)commandTopGroups.get(groupField);
                if (topGroups.isEmpty()) continue;
                TopGroups[] topGroupsArr = new TopGroups[topGroups.size()];
                rb.mergedTopGroups.put(groupField, (TopGroups<String>)TopGroups.merge((TopGroups[])topGroups.toArray(topGroupsArr), (Sort)groupSort, (Sort)sortWithinGroup, (int)groupOffsetDefault, (int)docsPerGroupDefault));
            }
            for (String query : commandTopDocs.keySet()) {
                List queryCommandResults = (List)commandTopDocs.get(query);
                ArrayList<TopDocs> topDocs = new ArrayList<TopDocs>(queryCommandResults.size());
                int mergedMatches = 0;
                for (QueryCommandResult queryCommandResult : queryCommandResults) {
                    topDocs.add(queryCommandResult.getTopDocs());
                    mergedMatches += queryCommandResult.getMatches();
                }
                int topN = rb.getGroupingSpec().getOffset() + rb.getGroupingSpec().getLimit();
                TopDocs mergedTopDocs = TopDocs.merge((Sort)sortWithinGroup, (int)topN, (TopDocs[])topDocs.toArray(new TopDocs[topDocs.size()]));
                rb.mergedQueryCommandResults.put(query, new QueryCommandResult(mergedTopDocs, mergedMatches));
            }
            HashMap<Object, ShardDoc> resultIds = new HashMap<Object, ShardDoc>();
            int i = 0;
            for (TopGroups<String> topGroups : rb.mergedTopGroups.values()) {
                for (GroupDocs group : topGroups.groups) {
                    for (ScoreDoc scoreDoc : group.scoreDocs) {
                        ShardDoc solrDoc = (ShardDoc)scoreDoc;
                        solrDoc.positionInResponse = i++;
                        resultIds.put(solrDoc.id, solrDoc);
                    }
                }
            }
            for (QueryCommandResult queryCommandResult : rb.mergedQueryCommandResults.values()) {
                for (ScoreDoc scoreDoc : queryCommandResult.getTopDocs().scoreDocs) {
                    ShardDoc solrDoc = (ShardDoc)scoreDoc;
                    solrDoc.positionInResponse = i++;
                    resultIds.put(solrDoc.id, solrDoc);
                }
            }
            rb.resultIds = resultIds;
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }
}

