/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.script.IScriptDataSourceEventHandler;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.mozilla.javascript.Scriptable;

public class ScriptDataSourceRuntime
extends DataSourceRuntime {
    private IScriptDataSourceEventHandler scriptEventHandler;

    ScriptDataSourceRuntime(IScriptDataSourceDesign dataSource, Scriptable sharedScope, ScriptContext cx) {
        super(dataSource, sharedScope, cx);
        Object[] params = new Object[]{dataSource, sharedScope};
        logger.entering(ScriptDataSourceRuntime.class.getName(), "ScriptDataSourceRuntime", params);
        if (this.getEventHandler() instanceof IScriptDataSourceEventHandler) {
            this.scriptEventHandler = (IScriptDataSourceEventHandler)this.getEventHandler();
        }
        logger.exiting(ScriptDataSourceRuntime.class.getName(), "ScriptDataSourceRuntime");
        logger.log(Level.FINER, "ScriptDataSourceRuntime starts up");
    }

    @Override
    public void openOdiDataSource(IDataSource odiDataSource) throws DataException {
        this.open();
        super.openOdiDataSource(odiDataSource);
    }

    @Override
    public void closeOdiDataSource() throws DataException {
        this.close();
        super.closeOdiDataSource();
    }

    private void open() throws DataException {
        if (this.scriptEventHandler != null) {
            try {
                this.scriptEventHandler.handleOpen(this);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }

    private void close() throws DataException {
        if (this.scriptEventHandler != null) {
            try {
                this.scriptEventHandler.handleClose(this);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }

    @Override
    public String getExtensionID() {
        return "SCRIPT";
    }

    @Override
    public Map getAllExtensionProperties() {
        return null;
    }

    @Override
    public String getExtensionProperty(String name) {
        return null;
    }

    @Override
    public void setExtensionProperty(String name, String value) {
    }
}

