/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.core.vm;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.report.debug.core.i18n.Messages;
import org.eclipse.birt.report.debug.internal.core.vm.VMBreakPoint;
import org.eclipse.birt.report.debug.internal.core.vm.VMConstants;
import org.eclipse.birt.report.debug.internal.core.vm.VMException;
import org.eclipse.birt.report.debug.internal.core.vm.VMListener;
import org.eclipse.birt.report.debug.internal.core.vm.VMStackFrame;
import org.eclipse.birt.report.debug.internal.core.vm.VMValue;
import org.eclipse.birt.report.debug.internal.core.vm.VMVariable;
import org.eclipse.birt.report.debug.internal.core.vm.rm.RMClient;
import org.eclipse.birt.report.debug.internal.core.vm.rm.RMValue;
import org.eclipse.birt.report.debug.internal.core.vm.rm.RMVariable;

public class ReportVMClient
extends RMClient
implements VMConstants {
    private static final Logger logger = Logger.getLogger(ReportVMClient.class.getName());
    private Socket requestSocket;
    private ObjectOutputStream requestWriter;
    private ObjectInputStream requestReader;
    private Socket eventSocket;
    private ObjectInputStream eventReader;
    private Thread eventDispatchThread;
    private boolean isTerminated;
    private boolean isConnected;
    private List vmListeners = new ArrayList();
    private List deferredBreakPoints = new LinkedList();

    public void connect(int listenPort) throws VMException {
        try {
            this.connect(null, listenPort);
        }
        catch (VMException e) {
            throw new VMException(e);
        }
    }

    public void connect(InetAddress host, int listenPort) throws VMException {
        try {
            this.requestSocket = new Socket("localhost", listenPort);
            this.requestWriter = new ObjectOutputStream(this.requestSocket.getOutputStream());
            this.requestReader = new ObjectInputStream(this.requestSocket.getInputStream());
            this.eventSocket = new Socket("localhost", listenPort);
            this.eventReader = new ObjectInputStream(this.eventSocket.getInputStream());
            this.isTerminated = false;
            this.isConnected = true;
            logger.info(Messages.getString("ReportVMClient.ServerConnected"));
            this.addDeferredBreakPoints();
            this.startEventDispatch();
        }
        catch (Exception e) {
            throw new VMException(e);
        }
    }

    public void disconnect() {
        if (!this.isConnected) {
            return;
        }
        this.isConnected = false;
        try {
            this.requestReader.close();
            this.requestWriter.close();
            this.eventReader.close();
        }
        catch (IOException iOException) {
            logger.warning(Messages.getString("ReportVMClient.ServerShutDown"));
        }
        try {
            this.requestSocket.close();
            this.eventSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.eventDispatchThread.isAlive()) {
            this.eventDispatchThread.interrupt();
        }
        this.eventDispatchThread = null;
        this.requestReader = null;
        this.requestWriter = null;
        this.eventReader = null;
        this.requestSocket = null;
        this.eventSocket = null;
        logger.info(Messages.getString("ReportVMClient.ClientDisconnected"));
    }

    private void startEventDispatch() {
        this.eventDispatchThread = new Thread(new Runnable(){

            public void run() {
                logger.info(Messages.getString("ReportVMClient.EnterEventDispatching"));
                while (!ReportVMClient.this.isTerminated) {
                    try {
                        int event = ReportVMClient.this.eventReader.readInt();
                        logger.info(String.valueOf(Messages.getString("ReportVMClient.ReceivedVMEvent")) + event + "|" + EVENT_NAMES[event]);
                        if (event == 10) {
                            ReportVMClient.this.isTerminated = true;
                        }
                        int i = 0;
                        while (i < ReportVMClient.this.vmListeners.size()) {
                            ((VMListener)ReportVMClient.this.vmListeners.get(i)).handleEvent(event, null);
                            ++i;
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        ReportVMClient.this.isTerminated = true;
                        break;
                    }
                    catch (IOException iOException) {
                        logger.warning(Messages.getString("ReportVMClient.ServerShuttingDown"));
                        ReportVMClient.this.isTerminated = true;
                        break;
                    }
                    catch (Exception e) {
                        ReportVMClient.this.isTerminated = true;
                        e.printStackTrace();
                        break;
                    }
                }
            }
        }, "Client Event Dispatcher");
        this.eventDispatchThread.start();
    }

    public VMStackFrame[] getStackFrames() throws VMException {
        Object rt = this.sendRequest(20);
        if (rt instanceof VMStackFrame[]) {
            VMStackFrame[] fms = (VMStackFrame[])rt;
            int i = 0;
            while (i < fms.length) {
                this.hookVM(fms[i].getVariables());
                ++i;
            }
            return (VMStackFrame[])rt;
        }
        return NO_FRAMES;
    }

    public VMStackFrame getStackFrame(int index) throws VMException {
        Object rt = this.sendRequest(274, index);
        if (rt instanceof VMStackFrame) {
            this.hookVM(((VMStackFrame)rt).getVariables());
            return (VMStackFrame)rt;
        }
        return null;
    }

    public VMValue evaluate(String expression) throws VMException {
        Object rt = this.sendRequest(273, expression);
        if (rt instanceof VMValue) {
            ((RMValue)rt).attach(this);
            return (VMValue)rt;
        }
        return null;
    }

    public VMVariable[] getVariables() throws VMException {
        Object rt = this.sendRequest(19);
        if (rt instanceof VMVariable[]) {
            this.hookVM((VMVariable[])rt);
            return (VMVariable[])rt;
        }
        return NO_VARS;
    }

    protected VMVariable[] getMembers(long rid) throws VMException {
        Object rt = this.sendRequest(275, rid);
        if (rt instanceof VMVariable[]) {
            this.hookVM((VMVariable[])rt);
            return (VMVariable[])rt;
        }
        return NO_VARS;
    }

    private void hookVM(VMVariable[] vars) {
        if (vars instanceof RMVariable[]) {
            RMVariable[] rvars = (RMVariable[])vars;
            int i = 0;
            while (i < rvars.length) {
                RMValue val = (RMValue)vars[i].getValue();
                if (val != null) {
                    val.attach(this);
                    this.hookVM(val.getLocalMembers());
                }
                ++i;
            }
        }
    }

    public void suspend() throws VMException {
        this.sendRequest(2);
    }

    public void resume() throws VMException {
        this.sendRequest(1);
    }

    public void step() throws VMException {
        this.sendRequest(3);
    }

    public void stepInto() throws VMException {
        this.sendRequest(4);
    }

    public void stepOut() throws VMException {
        this.sendRequest(5);
    }

    public void terminate() throws VMException {
        this.sendRequest(6);
    }

    public boolean isSuspended() throws VMException {
        if (this.isTerminated || !this.isConnected) {
            return false;
        }
        Object rt = this.sendRequest(18);
        if (rt instanceof Boolean) {
            return (Boolean)rt;
        }
        return false;
    }

    public boolean isTerminated() throws VMException {
        if (this.isTerminated || !this.isConnected) {
            return true;
        }
        Object rt = this.sendRequest(17);
        if (rt instanceof Boolean) {
            boolean terminated = (Boolean)rt;
            if (terminated) {
                this.isTerminated = true;
            }
            return terminated;
        }
        return true;
    }

    public void addVMListener(VMListener listener) {
        if (!this.vmListeners.contains(listener)) {
            this.vmListeners.add(listener);
        }
    }

    public void removeVMListener(VMListener listener) {
        this.vmListeners.remove(listener);
    }

    public void addBreakPoint(VMBreakPoint bp) throws VMException {
        if (!this.isTerminated && this.isConnected) {
            this.sendRequest(257, bp);
        } else {
            this.deferredBreakPoints.add(bp);
        }
    }

    public void removeBreakPoint(VMBreakPoint bp) throws VMException {
        if (!this.isTerminated && this.isConnected) {
            this.sendRequest(259, bp);
        } else {
            this.deferredBreakPoints.remove(bp);
        }
    }

    public void modifyBreakPoint(VMBreakPoint bp) throws VMException {
        if (!this.isTerminated && this.isConnected) {
            this.sendRequest(258, bp);
        } else {
            int idx = this.deferredBreakPoints.indexOf(bp);
            if (idx != -1) {
                this.deferredBreakPoints.set(idx, bp);
            }
        }
    }

    public void clearBreakPoints() throws VMException {
        if (!this.isTerminated && this.isConnected) {
            this.sendRequest(9);
        } else {
            this.deferredBreakPoints.clear();
        }
    }

    private Object sendRequest(int op) throws VMException {
        return this.sendRequest(op, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object sendRequest(int op, Object arg) throws VMException {
        if (this.isTerminated || !this.isConnected) {
            logger.warning(String.valueOf(Messages.getString("ReportVMClient.RequestIgnored.ServerDisconnected")) + op);
            return null;
        }
        Socket socket = this.requestSocket;
        synchronized (socket) {
            try {
                this.requestWriter.writeInt(op);
                if ((op & 0x100) != 0) {
                    this.requestWriter.writeObject(arg);
                }
                this.requestWriter.flush();
                if ((op & 0x10) != 0) {
                    return this.requestReader.readObject();
                }
            }
            catch (IOException iOException) {
                logger.warning(String.valueOf(Messages.getString("ReportVMClient.RequestIgnored.ServerShuttingDown")) + op);
            }
            catch (Exception e) {
                throw new VMException(e);
            }
        }
        return null;
    }

    private void addDeferredBreakPoints() throws VMException {
        int i = 0;
        while (i < this.deferredBreakPoints.size()) {
            this.addBreakPoint((VMBreakPoint)this.deferredBreakPoints.get(i));
            ++i;
        }
        this.deferredBreakPoints.clear();
    }
}

