/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import java.util.Collection;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;

public class ContentEmitterVisitor
implements IContentVisitor {
    IContentEmitter emitter;

    public ContentEmitterVisitor(IContentEmitter emitter) {
        this.emitter = emitter;
    }

    @Override
    public Object visit(IContent content, Object value) throws BirtException {
        return content.accept(this, value);
    }

    @Override
    public Object visitContent(IContent content, Object value) throws BirtException {
        this.emitter.startContent(content);
        return value;
    }

    @Override
    public Object visitPage(IPageContent page, Object value) throws BirtException {
        return value;
    }

    @Override
    public Object visitContainer(IContainerContent container, Object value) throws BirtException {
        this.emitter.startContainer(container);
        this.visitChildren(container, value);
        this.emitter.endContainer(container);
        return value;
    }

    @Override
    public Object visitTable(ITableContent table, Object value) throws BirtException {
        this.emitter.startTable(table);
        this.visitChildren(table, value);
        this.emitter.endTable(table);
        return value;
    }

    @Override
    public Object visitTableBand(ITableBandContent tableBand, Object value) throws BirtException {
        this.emitter.startTableBand(tableBand);
        this.visitChildren(tableBand, value);
        this.emitter.endTableBand(tableBand);
        return value;
    }

    @Override
    public Object visitRow(IRowContent row, Object value) throws BirtException {
        this.emitter.startRow(row);
        this.visitChildren(row, value);
        this.emitter.endRow(row);
        return value;
    }

    @Override
    public Object visitCell(ICellContent cell, Object value) throws BirtException {
        this.emitter.startCell(cell);
        this.visitChildren(cell, value);
        this.emitter.endCell(cell);
        return value;
    }

    @Override
    public Object visitText(ITextContent text, Object value) throws BirtException {
        this.emitter.startText(text);
        return value;
    }

    @Override
    public Object visitLabel(ILabelContent label, Object value) throws BirtException {
        this.emitter.startLabel(label);
        return value;
    }

    @Override
    public Object visitAutoText(IAutoTextContent autoText, Object value) throws BirtException {
        this.emitter.startAutoText(autoText);
        return value;
    }

    @Override
    public Object visitData(IDataContent data, Object value) throws BirtException {
        this.emitter.startData(data);
        return value;
    }

    @Override
    public Object visitImage(IImageContent image, Object value) throws BirtException {
        this.emitter.startImage(image);
        return value;
    }

    @Override
    public Object visitForeign(IForeignContent foreign, Object value) throws BirtException {
        this.emitter.startForeign(foreign);
        return value;
    }

    public Object visitChildren(IContent content, Object value) throws BirtException {
        Collection list = content.getChildren();
        if (list == null) {
            return value;
        }
        for (Object child : list) {
            if (!(child instanceof IContent)) continue;
            this.visit((IContent)child, value);
        }
        return value;
    }

    @Override
    public Object visitList(IListContent list, Object value) throws BirtException {
        this.emitter.startList(list);
        this.visitChildren(list, value);
        this.emitter.endList(list);
        return value;
    }

    @Override
    public Object visitListBand(IListBandContent listBand, Object value) throws BirtException {
        this.emitter.startListBand(listBand);
        this.visitChildren(listBand, value);
        this.emitter.endListBand(listBand);
        return value;
    }

    @Override
    public Object visitGroup(IGroupContent group, Object value) throws BirtException {
        this.emitter.startGroup(group);
        this.visitChildren(group, value);
        this.emitter.endGroup(group);
        return null;
    }

    @Override
    public Object visitListGroup(IListGroupContent group, Object value) throws BirtException {
        this.emitter.startListGroup(group);
        this.visitChildren(group, value);
        this.emitter.endListGroup(group);
        return null;
    }

    @Override
    public Object visitTableGroup(ITableGroupContent group, Object value) throws BirtException {
        this.emitter.startTableGroup(group);
        this.visitChildren(group, value);
        this.emitter.endTableGroup(group);
        return null;
    }
}

