/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core;

import org.eclipse.bpmn2.modeler.core.Messages;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class LifecycleEvent {
    public EventType eventType;
    public Object target;
    public IContext context;
    public IFeatureProvider featureProvider;
    public boolean doit = true;

    public LifecycleEvent(EventType eventType, Object target) {
        this.eventType = eventType;
        this.target = target;
    }

    public LifecycleEvent(EventType eventType, IFeatureProvider featureProvider, IContext context, Object target) {
        this.eventType = eventType;
        this.featureProvider = featureProvider;
        this.context = context;
        this.target = target;
    }

    public static void notify(EventType eventType, Object target) {
        if (target != null) {
            LifecycleEvent.notify(new LifecycleEvent(eventType, target));
        }
    }

    public static void notify(LifecycleEvent lifecycleEvent) {
        TargetRuntime rt = TargetRuntime.getCurrentRuntime();
        rt.notify(lifecycleEvent);
    }

    public String toString() {
        String s = String.valueOf(Messages.LifecycleEvent_Event_Prefix) + (Object)((Object)this.eventType);
        if (this.target instanceof PictogramElement) {
            EObject o = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)this.target);
            if (o != null) {
                s = String.valueOf(s) + " " + o.eClass().getName();
            }
        } else if (this.target instanceof EObject) {
            EObject o = (EObject)this.target;
            s = String.valueOf(s) + " " + o.eClass().getName();
        }
        return s;
    }

    public static enum EventType {
        EDITOR_STARTUP,
        EDITOR_INITIALIZED,
        EDITOR_SHUTDOWN,
        BUSINESSOBJECT_CREATED,
        BUSINESSOBJECT_INITIALIZED,
        BUSINESSOBJECT_DELETED,
        PICTOGRAMELEMENT_CAN_ADD,
        PICTOGRAMELEMENT_ADDED,
        PICTOGRAMELEMENT_UPDATE_NEEDED,
        PICTOGRAMELEMENT_CAN_UPDATE,
        PICTOGRAMELEMENT_UPDATE,
        PICTOGRAMELEMENT_CAN_LAYOUT,
        PICTOGRAMELEMENT_LAYOUT,
        PICTOGRAMELEMENT_CAN_MOVE,
        PICTOGRAMELEMENT_PRE_MOVE,
        PICTOGRAMELEMENT_POST_MOVE,
        PICTOGRAMELEMENT_CAN_RESIZE,
        PICTOGRAMELEMENT_PRE_RESIZE,
        PICTOGRAMELEMENT_POST_RESIZE,
        PICTOGRAMELEMENT_CAN_DELETE,
        PICTOGRAMELEMENT_DELETED,
        TRANSACTION_STARTING,
        TRANSACTION_INTERRUPTED,
        TRANSACTION_CLOSED,
        COMMAND_UNDO,
        COMMAND_REDO;

    }
}

