/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.modeler.core.features.BaseElementFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.Messages;
import org.eclipse.bpmn2.modeler.core.features.containers.participant.CreateParticipantReferenceFeature;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public class BPMNDiagramFeatureContainer
extends BaseElementFeatureContainer {
    @Override
    public Object getApplyObject(IContext context) {
        PictogramElement[] pes;
        if (context instanceof ICustomContext && (pes = ((ICustomContext)context).getPictogramElements()).length == 1) {
            return BusinessObjectUtil.getFirstElementOfType(pes[0], BPMNDiagram.class);
        }
        return null;
    }

    @Override
    public boolean canApplyTo(Object o) {
        return o instanceof BPMNDiagram;
    }

    @Override
    public ICreateFeature getCreateFeature(IFeatureProvider fp) {
        return null;
    }

    @Override
    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return null;
    }

    @Override
    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        return null;
    }

    @Override
    public IDirectEditingFeature getDirectEditingFeature(IFeatureProvider fp) {
        return null;
    }

    @Override
    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return null;
    }

    @Override
    public IMoveShapeFeature getMoveFeature(IFeatureProvider fp) {
        return null;
    }

    @Override
    public IResizeShapeFeature getResizeFeature(IFeatureProvider fp) {
        return null;
    }

    @Override
    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return null;
    }

    @Override
    public ICustomFeature[] getCustomFeatures(IFeatureProvider fp) {
        return new ICustomFeature[]{new EnableConnectionRoutingFeature(fp), new LayoutConnectionsFeature(fp), new CreateParticipantReferenceFeature(fp)};
    }

    public class EnableConnectionRoutingFeature
    extends AbstractCustomFeature {
        Bpmn2Preferences preferences;

        public EnableConnectionRoutingFeature(IFeatureProvider fp) {
            super(fp);
            Diagram diagram = fp.getDiagramTypeProvider().getDiagram();
            EObject bo = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)diagram);
            this.preferences = Bpmn2Preferences.getInstance(bo);
        }

        public boolean canExecute(ICustomContext context) {
            return true;
        }

        public boolean isAvailable(IContext context) {
            return true;
        }

        public String getName() {
            if (this.preferences.getEnableConnectionRouting()) {
                return Messages.BPMNDiagramFeatureContainer_Disable_Name;
            }
            return Messages.BPMNDiagramFeatureContainer_Enable_Name;
        }

        public String getDescription() {
            return Messages.BPMNDiagramFeatureContainer_Disable_Enable_Description;
        }

        public void execute(ICustomContext context) {
            boolean enabled = this.preferences.getEnableConnectionRouting();
            this.preferences.setEnableConnectionRouting(!enabled);
        }
    }

    public class LayoutConnectionsFeature
    extends AbstractCustomFeature {
        boolean hasDoneChanges;

        public LayoutConnectionsFeature(IFeatureProvider fp) {
            super(fp);
            this.hasDoneChanges = false;
        }

        public String getName() {
            return Messages.BPMNDiagramFeatureContainer_Reroute_All_Name;
        }

        public String getDescription() {
            return Messages.BPMNDiagramFeatureContainer_Reroute_All_Description;
        }

        public boolean canExecute(ICustomContext context) {
            PictogramElement[] pes = context.getPictogramElements();
            EObject businessObject = BusinessObjectUtil.getBusinessObjectForPictogramElement(pes[0]);
            return businessObject instanceof BPMNDiagram;
        }

        public boolean hasDoneChanges() {
            return this.hasDoneChanges;
        }

        public void execute(ICustomContext context) {
            PictogramElement[] pes = context.getPictogramElements();
            EObject businessObject = BusinessObjectUtil.getBusinessObjectForPictogramElement(pes[0]);
            BPMNDiagram bpmnDiagram = (BPMNDiagram)businessObject;
            Diagram diagram = this.getFeatureProvider().getDiagramTypeProvider().getDiagram();
            for (DiagramElement de : bpmnDiagram.getPlane().getPlaneElement()) {
                if (!(de instanceof BPMNEdge)) continue;
                BaseElement be = ((BPMNEdge)de).getBpmnElement();
                for (PictogramElement pe : Graphiti.getLinkService().getPictogramElements(diagram, (EObject)be)) {
                    if (!(pe instanceof Connection) || !FeatureSupport.updateConnection(this.getFeatureProvider(), (Connection)pe, true)) continue;
                    this.hasDoneChanges = true;
                }
            }
        }
    }
}

