/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2CreateConnectionFeature;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2CreateFeature;
import org.eclipse.bpmn2.modeler.core.runtime.ModelDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.mm.pictograms.PictogramsFactory;
import org.eclipse.graphiti.services.Graphiti;

public class CompoundCreateFeaturePart<CONTEXT> {
    IFeature feature;
    List<CompoundCreateFeaturePart<CONTEXT>> children = new ArrayList<CompoundCreateFeaturePart<CONTEXT>>();
    Hashtable<String, String> properties = null;

    public CompoundCreateFeaturePart(IFeature feature) {
        this.feature = feature;
    }

    public boolean canCreate(IContext context) {
        if (this.feature instanceof ICreateFeature && context instanceof ICreateContext) {
            if (!((ICreateFeature)this.feature).canCreate((ICreateContext)context)) {
                return false;
            }
            if (this.children.size() > 0) {
                ContainerShape parentContainer = ((ICreateContext)context).getTargetContainer();
                CreateContext childContext = new CreateContext();
                ContainerShape targetContainer = PictogramsFactory.eINSTANCE.createContainerShape();
                childContext.setTargetContainer(targetContainer);
                EClass eClass = ((AbstractBpmn2CreateFeature)this.feature).getBusinessObjectClass();
                EObject businessObject = Bpmn2Factory.eINSTANCE.create(eClass);
                PictogramLink link = PictogramsFactory.eINSTANCE.createPictogramLink();
                link.setPictogramElement((PictogramElement)targetContainer);
                link.getBusinessObjects().add((Object)businessObject);
                targetContainer.setLink(link);
                childContext.putProperty((Object)"parent.container", (Object)BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)parentContainer));
                for (CompoundCreateFeaturePart<CONTEXT> child : this.children) {
                    if (child.canCreate((IContext)childContext)) continue;
                    return false;
                }
            }
        } else if (this.feature instanceof ICreateConnectionFeature && context instanceof ICreateConnectionContext && !((ICreateConnectionFeature)this.feature).canCreate((ICreateConnectionContext)context)) {
            return false;
        }
        return true;
    }

    public List<Object> create(IContext context) {
        ArrayList<Object> businessObjects = new ArrayList<Object>();
        if (this.feature instanceof ICreateFeature && context instanceof ICreateContext) {
            if (this.canCreate(context)) {
                Object[] created;
                Object[] objectArray = created = ((ICreateFeature)this.feature).create((ICreateContext)context);
                int n = created.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    businessObjects.add(o);
                    ++n2;
                }
            }
        } else if (this.feature instanceof ICreateConnectionFeature && context instanceof ICreateConnectionContext && this.canCreate(context)) {
            businessObjects.add(((ICreateConnectionFeature)this.feature).create((ICreateConnectionContext)context));
        }
        BaseElement businessObject = null;
        ContainerShape targetContainer = null;
        Connection connection = null;
        for (Object e : businessObjects) {
            if (e instanceof ContainerShape && targetContainer == null) {
                targetContainer = (ContainerShape)e;
                continue;
            }
            if (e instanceof Connection && connection == null) {
                connection = (Connection)e;
                continue;
            }
            if (!(e instanceof BaseElement) || businessObject != null) continue;
            businessObject = (BaseElement)e;
        }
        if (connection != null) {
            businessObject = BusinessObjectUtil.getFirstBaseElement(connection);
        }
        this.applyBusinessObjectProperties(businessObject);
        ArrayList<PictogramElement> arrayList = new ArrayList<PictogramElement>();
        int i = 0;
        while (i < this.children.size()) {
            CompoundCreateFeaturePart<CONTEXT> node = this.children.get(i);
            node.create(context, targetContainer, arrayList, businessObjects);
            ++i;
        }
        return businessObjects;
    }

    public void create(IContext context, ContainerShape targetContainer, List<PictogramElement> pictogramElements, List<Object> businessObjects) {
        PictogramElement pe2;
        String value;
        CreateContext cc;
        CreateContext childContext = null;
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        if (context instanceof ICreateContext) {
            ICreateContext cc2 = (ICreateContext)context;
            x = cc2.getX();
            y = cc2.getY();
            width = cc2.getWidth();
            height = cc2.getHeight();
        }
        PictogramElement source = null;
        PictogramElement target = null;
        int index = pictogramElements.size();
        if (this.feature instanceof ICreateFeature) {
            cc = new CreateContext();
            if (targetContainer == null) {
                targetContainer = ((ICreateContext)context).getTargetContainer();
            }
            cc.setTargetContainer(targetContainer);
            cc.setTargetConnection(((ICreateContext)context).getTargetConnection());
            value = this.getProperty("x");
            if (value != null) {
                x = targetContainer instanceof Diagram ? (x += Integer.parseInt(value)) : Integer.parseInt(value);
            }
            cc.setX(x);
            value = this.getProperty("y");
            if (value != null) {
                y = targetContainer instanceof Diagram ? (y += Integer.parseInt(value)) : Integer.parseInt(value);
            }
            cc.setY(y);
            value = this.getProperty("width");
            if (value != null) {
                width = Integer.parseInt(value);
            }
            cc.setWidth(width);
            value = this.getProperty("height");
            if (value != null) {
                height = Integer.parseInt(value);
            }
            cc.setHeight(height);
            childContext = cc;
        } else if (this.feature instanceof ICreateConnectionFeature) {
            String id;
            cc = new CreateConnectionContext();
            value = this.getProperty("source");
            if (value != null) {
                for (PictogramElement pe2 : pictogramElements) {
                    id = Graphiti.getPeService().getPropertyValue((PropertyContainer)pe2, "ToolPartID");
                    if (!value.equals(id)) continue;
                    source = pe2;
                    break;
                }
            } else if (index - 2 >= 0 && index - 2 < pictogramElements.size()) {
                source = pictogramElements.get(index - 2);
            }
            if (source == null) {
                source = ((ICreateConnectionContext)context).getSourcePictogramElement();
            }
            if ((value = this.getProperty("target")) != null) {
                for (PictogramElement pe2 : pictogramElements) {
                    id = Graphiti.getPeService().getPropertyValue((PropertyContainer)pe2, "ToolPartID");
                    if (!value.equals(id)) continue;
                    target = pe2;
                    break;
                }
            } else if (index - 1 >= 0 && index - 1 < pictogramElements.size()) {
                target = pictogramElements.get(index - 1);
            }
            if (target == null) {
                target = ((ICreateConnectionContext)context).getTargetPictogramElement();
            }
            Point sp = GraphicsUtil.getShapeCenter((AnchorContainer)source);
            Point tp = GraphicsUtil.getShapeCenter((AnchorContainer)target);
            FixPointAnchor sourceAnchor = AnchorUtil.createAnchor((AnchorContainer)source, tp);
            FixPointAnchor targetAnchor = AnchorUtil.createAnchor((AnchorContainer)target, sp);
            cc.setSourcePictogramElement(source);
            cc.setTargetPictogramElement(target);
            cc.setSourceAnchor((Anchor)sourceAnchor);
            cc.setTargetAnchor((Anchor)targetAnchor);
            childContext = cc;
        }
        List<Object> result = null;
        result = this.create((IContext)childContext);
        pe2 = null;
        Connection cn = null;
        BaseElement be = null;
        for (Object o : result) {
            if (o instanceof ContainerShape) {
                pe2 = (ContainerShape)o;
                continue;
            }
            if (o instanceof Connection) {
                cn = (Connection)o;
                continue;
            }
            if (!(o instanceof BaseElement)) continue;
            be = (BaseElement)o;
        }
        PictogramElement updatePE = null;
        if (pe2 != null) {
            pictogramElements.add(pe2);
            value = this.getProperty("ToolPartID");
            if (value != null) {
                Graphiti.getPeService().setPropertyValue((PropertyContainer)pe2, "ToolPartID", value);
            }
            updatePE = pe2;
        } else if (cn != null) {
            be = BusinessObjectUtil.getFirstBaseElement(cn);
            value = this.getProperty("ToolPartID");
            if (value != null) {
                Graphiti.getPeService().setPropertyValue((PropertyContainer)cn, "ToolPartID", value);
            }
            updatePE = cn;
        }
        this.applyBusinessObjectProperties(be);
        if (updatePE != null) {
            this.addPictogramElementToContext(context, updatePE);
            UpdateContext updateContext = new UpdateContext(updatePE);
            IUpdateFeature updateFeature = this.feature.getFeatureProvider().getUpdateFeature((IUpdateContext)updateContext);
            if (updateFeature.updateNeeded((IUpdateContext)updateContext).toBoolean()) {
                updateFeature.update((IUpdateContext)updateContext);
            }
        }
        businessObjects.add(result);
    }

    private void addPictogramElementToContext(IContext context, PictogramElement pe) {
        List pes = (List)context.getProperty((Object)"pictogram.elements");
        if (pes != null) {
            pes.add(pe);
        }
    }

    private void applyBusinessObjectProperties(BaseElement be) {
        if (be != null && this.properties != null) {
            ModelDescriptor md = TargetRuntime.getCurrentRuntime().getModelDescriptor();
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                if (!entry.getKey().startsWith("$")) continue;
                String featureName = entry.getKey().substring(1);
                EStructuralFeature feature = md.getFeature(be.eClass().getName(), featureName);
                ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(be);
                String value = entry.getValue();
                if (value.startsWith("$")) {
                    String name = value.substring(1);
                    EClassifier eClass = md.getClassifier(name);
                    EFactory factory = eClass.getEPackage().getEFactoryInstance();
                    EObject object = factory.create((EClass)eClass);
                    adapter.getFeatureDescriptor(feature).setValue(object);
                    continue;
                }
                adapter.getFeatureDescriptor(feature).setValue(value);
            }
        }
    }

    public boolean isAvailable(IContext context) {
        if (this.feature != null && !this.feature.isAvailable(context)) {
            return false;
        }
        for (CompoundCreateFeaturePart<CONTEXT> ft : this.children) {
            if (ft.isAvailable(context)) continue;
            return false;
        }
        return true;
    }

    public CompoundCreateFeaturePart<CONTEXT> addChild(IFeature feature) {
        CompoundCreateFeaturePart<CONTEXT> node = new CompoundCreateFeaturePart<CONTEXT>(feature);
        this.children.add(node);
        return node;
    }

    public EClass getBusinessObjectClass() {
        EClass eClass = null;
        if (this.feature instanceof AbstractBpmn2CreateFeature) {
            eClass = ((AbstractBpmn2CreateFeature)this.feature).getBusinessObjectClass();
        } else if (this.feature instanceof AbstractBpmn2CreateConnectionFeature) {
            eClass = ((AbstractBpmn2CreateConnectionFeature)this.feature).getBusinessObjectClass();
        }
        if (eClass == null) {
            for (CompoundCreateFeaturePart<CONTEXT> child : this.children) {
                EClass ec = child.getBusinessObjectClass();
                if (ec == null) continue;
                eClass = ec;
                break;
            }
        }
        return eClass;
    }

    public String getCreateName() {
        String createName = null;
        if (this.feature != null) {
            createName = this.feature.getName();
        }
        for (CompoundCreateFeaturePart<CONTEXT> child : this.children) {
            String cn = child.getCreateName();
            if (cn == null) continue;
            createName = cn;
        }
        return createName;
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public void setFeature(IFeature feature) {
        this.feature = feature;
    }

    public List<CompoundCreateFeaturePart<CONTEXT>> getChildren() {
        return this.children;
    }

    public void setProperties(Hashtable<String, String> properties) {
        this.getProperties().putAll(properties);
    }

    public Hashtable<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties;
    }

    public String getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }
}

