/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpmn2.modeler.core.features.BendpointConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.ConnectionRoute;
import org.eclipse.bpmn2.modeler.core.features.DetourPoints;
import org.eclipse.bpmn2.modeler.core.features.RouteSolver;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.utils.AnchorSite;
import org.eclipse.bpmn2.modeler.core.utils.AnchorType;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class ManhattanConnectionRouter
extends BendpointConnectionRouter {
    static final int offset = 10;
    static boolean testRouteSolver = false;
    Orientation orientation;

    public ManhattanConnectionRouter(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    protected void initialize() {
        super.initialize();
        Bpmn2Preferences preferences = Bpmn2Preferences.getInstance((EObject)this.ffc);
        this.orientation = preferences.getIsHorizontal() == Bpmn2Preferences.BPMNDIAttributeDefault.ALWAYS_FALSE ? Orientation.VERTICAL : Orientation.HORIZONTAL;
    }

    @Override
    public boolean routingNeeded(Connection connection) {
        if (connection instanceof FreeFormConnection) {
            Point p1;
            FreeFormConnection ffc = (FreeFormConnection)connection;
            Point p0 = GraphicsUtil.createPoint(ffc.getStart());
            int i = 0;
            while (i < ffc.getBendpoints().size()) {
                p1 = (Point)ffc.getBendpoints().get(i);
                if (!GraphicsUtil.isHorizontal(p0, p1) && !GraphicsUtil.isVertical(p0, p1)) {
                    return true;
                }
                p0 = p1;
                ++i;
            }
            p1 = GraphicsUtil.createPoint(ffc.getEnd());
            if (!GraphicsUtil.isHorizontal(p0, p1) && !GraphicsUtil.isVertical(p0, p1)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected ConnectionRoute calculateRoute() {
        if (this.isSelfConnection()) {
            return super.calculateRoute();
        }
        GraphicsUtil.debug = false;
        boolean initialUpdate = peService.getPropertyValue((PropertyContainer)this.ffc, "initial.update") != null;
        Point start = null;
        Point end = null;
        Point middle = null;
        if (this.movedBendpoint != null) {
            middle = this.movedBendpoint;
        }
        if (testRouteSolver) {
            RouteSolver solver = new RouteSolver(this.fp, this.allShapes);
            solver.solve(this.source, this.target);
        }
        ArrayList<ConnectionRoute> allRoutes = new ArrayList<ConnectionRoute>();
        AnchorSite sourceSite = AnchorSite.getSite(this.sourceAnchor);
        AnchorSite targetSite = AnchorSite.getSite(this.targetAnchor);
        AnchorSite initialSourceSite = sourceSite;
        AnchorSite initialTargetSite = targetSite;
        Point initialSourceLocation = GraphicsUtil.createPoint((Anchor)this.sourceAnchor);
        Point initialTargetLocation = GraphicsUtil.createPoint((Anchor)this.targetAnchor);
        int i = 0;
        while (i < 16) {
            if (this.shouldCalculate(sourceSite, targetSite)) {
                AnchorUtil.moveAnchor(this.sourceAnchor, initialSourceLocation);
                AnchorUtil.moveAnchor(this.targetAnchor, initialTargetLocation);
                AnchorSite.setSite(this.sourceAnchor, sourceSite);
                AnchorUtil.adjustAnchors((AnchorContainer)this.source);
                AnchorSite.setSite(this.targetAnchor, targetSite);
                AnchorUtil.adjustAnchors((AnchorContainer)this.target);
                ConnectionRoute route = new ConnectionRoute(this, allRoutes.size() + 1, this.source, this.target);
                start = GraphicsUtil.createPoint((Anchor)this.sourceAnchor);
                end = GraphicsUtil.createPoint((Anchor)this.targetAnchor);
                if (initialUpdate || middle != null || sourceSite != initialSourceSite || targetSite != initialTargetSite) {
                    int rank = 0;
                    if (AnchorType.getType((Anchor)this.targetAnchor) == AnchorType.POOL) {
                        if (middle != null) {
                            AnchorUtil.moveAnchor(this.targetAnchor, middle);
                        } else {
                            AnchorUtil.moveAnchor(this.targetAnchor, this.sourceAnchor);
                        }
                        end = GraphicsUtil.createPoint((Anchor)this.targetAnchor);
                        if (targetSite != initialTargetSite) {
                            ++rank;
                        }
                    }
                    if (AnchorType.getType((Anchor)this.sourceAnchor) == AnchorType.POOL) {
                        if (middle != null) {
                            AnchorUtil.moveAnchor(this.sourceAnchor, middle);
                        } else {
                            AnchorUtil.moveAnchor(this.sourceAnchor, this.targetAnchor);
                        }
                        start = GraphicsUtil.createPoint((Anchor)this.sourceAnchor);
                        if (sourceSite != initialSourceSite) {
                            ++rank;
                        }
                    }
                    route.setRank(rank);
                }
                route.setSourceAnchor(this.sourceAnchor);
                route.setTargetAnchor(this.targetAnchor);
                this.calculateRoute(route, this.source, start, middle, this.target, end, this.orientation);
                allRoutes.add(route);
            }
            if (i % 4 == 0) {
                sourceSite = this.getNextAnchorSite(sourceSite);
            } else {
                targetSite = this.getNextAnchorSite(targetSite);
            }
            ++i;
        }
        ConnectionRoute route = null;
        if (allRoutes.size() == 1) {
            route = (ConnectionRoute)allRoutes.get(0);
            this.optimize(route);
            GraphicsUtil.dump("Only one valid route: " + route.toString());
        } else if (allRoutes.size() > 1) {
            GraphicsUtil.dump("Optimizing Routes:\n------------------");
            for (ConnectionRoute r : allRoutes) {
                this.optimize(r);
            }
            GraphicsUtil.dump("Calculating Crossings:\n------------------");
            for (ConnectionRoute r : allRoutes) {
                if (r.getPoints().size() > 1) {
                    Point p1 = r.getPoints().get(0);
                    int i2 = 1;
                    while (i2 < r.getPoints().size()) {
                        Point p2 = r.getPoints().get(i2);
                        List<Connection> crossings = this.findCrossings(this.connection, p1, p2);
                        for (Connection c : crossings) {
                            if (c == this.connection) continue;
                            r.addCrossing(c, p1, p2);
                        }
                        ContainerShape shape = this.getCollision(p1, p2);
                        if (shape != null) {
                            r.addCollision((Shape)shape, p1, p2);
                        }
                        p1 = p2;
                        ++i2;
                    }
                }
                GraphicsUtil.dump("    " + r.toString());
            }
            GraphicsUtil.dump("Sorting Routes:\n------------------");
            Collections.sort(allRoutes);
            this.drawConnectionRoutes(allRoutes);
            route = (ConnectionRoute)allRoutes.get(0);
        }
        return route;
    }

    protected ConnectionRoute calculateRoute(ConnectionRoute route, Shape source, Point start, Point middle, Shape target, Point end, Orientation orientation) {
        if (middle != null) {
            List<Point> departure = this.calculateDeparture(source, start, middle);
            List<Point> approach = this.calculateApproach(middle, target, end);
            route.getPoints().addAll(departure);
            if (this.calculateEnroute(route, departure.get(departure.size() - 1), middle, orientation)) {
                route.getPoints().add(middle);
                if (this.calculateEnroute(route, middle, approach.get(0), orientation)) {
                    route.getPoints().addAll(approach);
                } else {
                    route.getPoints().add(end);
                }
            } else {
                route.getPoints().add(end);
            }
        } else {
            List<Point> departure = this.calculateDeparture(source, start, end);
            List<Point> approach = this.calculateApproach(start, target, end);
            if (departure.size() == 2 && approach.size() == 2 && GraphicsUtil.pointsEqual(departure.get(1), approach.get(0))) {
                route.getPoints().add(start);
                route.getPoints().add(end);
            } else {
                route.getPoints().addAll(departure);
                this.calculateEnroute(route, departure.get(departure.size() - 1), approach.get(0), orientation);
                route.getPoints().addAll(approach);
            }
        }
        return route;
    }

    private Point getVertMidpoint(Point start, Point end, double fract) {
        Point m = GraphicsUtil.createPoint(start);
        int d = (int)(fract * (double)(end.getY() - start.getY()));
        m.setY(start.getY() + d);
        return m;
    }

    private Point getHorzMidpoint(Point start, Point end, double fract) {
        Point m = GraphicsUtil.createPoint(start);
        int d = (int)(fract * (double)(end.getX() - start.getX()));
        m.setX(start.getX() + d);
        return m;
    }

    protected List<Point> calculateDeparture(Shape source, Point start, Point end) {
        AnchorSite sourceEdge = AnchorSite.getNearestEdge(source, start, end);
        ArrayList<Point> points = new ArrayList<Point>();
        Point p = GraphicsUtil.createPoint(start);
        Point m = end;
        switch (sourceEdge) {
            case TOP: 
            case BOTTOM: {
                ContainerShape shape;
                while ((shape = this.getCollision(start, m = this.getVertMidpoint(start, m, 0.45))) != null && Math.abs(m.getY() - start.getY()) > 10) {
                }
                if (shape != null) {
                    if (sourceEdge == AnchorSite.BOTTOM) {
                        m.setY(start.getY() + 10);
                    } else {
                        m.setY(start.getY() - 10);
                    }
                }
                p.setY(m.getY());
                break;
            }
            case LEFT: 
            case RIGHT: {
                ContainerShape shape;
                while ((shape = this.getCollision(start, m = this.getHorzMidpoint(start, m, 0.45))) != null && Math.abs(m.getX() - start.getX()) > 10) {
                }
                if (shape != null) {
                    if (sourceEdge == AnchorSite.RIGHT) {
                        m.setX(start.getX() + 10);
                    } else {
                        m.setX(start.getX() - 10);
                    }
                }
                p.setX(m.getX());
                break;
            }
            default: {
                return points;
            }
        }
        points.add(start);
        points.add(p);
        return points;
    }

    protected List<Point> calculateApproach(Point start, Shape target, Point end) {
        AnchorSite targetSite = AnchorSite.getNearestEdge(target, start, end);
        ArrayList<Point> points = new ArrayList<Point>();
        Point p = GraphicsUtil.createPoint(end);
        Point m = start;
        switch (targetSite) {
            case TOP: 
            case BOTTOM: {
                ContainerShape shape;
                while ((shape = this.getCollision(m = this.getVertMidpoint(m, end, 0.45), end)) != null && shape != target && Math.abs(m.getY() - end.getY()) > 10) {
                }
                if (shape != null) {
                    if (targetSite == AnchorSite.BOTTOM) {
                        m.setY(end.getY() + 10);
                    } else {
                        m.setY(end.getY() - 10);
                    }
                }
                p.setY(m.getY());
                break;
            }
            case LEFT: 
            case RIGHT: {
                ContainerShape shape;
                while ((shape = this.getCollision(m = this.getHorzMidpoint(m, end, 0.45), end)) != null && shape != target && Math.abs(m.getX() - end.getX()) > 10) {
                }
                if (shape != null) {
                    if (targetSite == AnchorSite.RIGHT) {
                        m.setX(end.getX() + 10);
                    } else {
                        m.setX(end.getX() - 10);
                    }
                }
                p.setX(m.getX());
                break;
            }
            default: {
                points.add(p);
                return points;
            }
        }
        points.add(p);
        points.add(end);
        return points;
    }

    Point createPoint(int x, int y) {
        return GraphicsUtil.createPoint(x, y);
    }

    protected boolean calculateEnroute(ConnectionRoute route, Point start, Point end, Orientation orientation) {
        Point p;
        ContainerShape shape;
        if (GraphicsUtil.pointsEqual(start, end)) {
            return false;
        }
        if (!GraphicsUtil.isSlanted(start, end) && (shape = this.getCollision(start, end)) == null) {
            return true;
        }
        int dx = Math.abs(end.getX() - start.getX());
        int dy = Math.abs(end.getY() - start.getY());
        if (orientation == Orientation.NONE) {
            orientation = dx > dy ? Orientation.HORIZONTAL : Orientation.VERTICAL;
        }
        if (orientation == Orientation.HORIZONTAL) {
            p = this.createPoint(end.getX(), start.getY());
            ContainerShape shape2 = this.getCollision(start, p);
            if (shape2 != null) {
                boolean detourUp;
                DetourPoints detour = this.getDetourPoints(shape2);
                boolean bl = detourUp = end.getY() - start.getY() < 0;
                if (p.getX() > start.getX()) {
                    p.setX(detour.topLeft.getX());
                    route.add(p);
                    if (detourUp) {
                        route.add(detour.topLeft);
                        route.add(detour.topRight);
                    } else {
                        route.add(detour.bottomLeft);
                        route.add(detour.bottomRight);
                    }
                } else {
                    p.setX(detour.topRight.getX());
                    route.add(p);
                    if (detourUp) {
                        route.add(detour.topRight);
                        route.add(detour.topLeft);
                    } else {
                        route.add(detour.bottomRight);
                        route.add(detour.bottomLeft);
                    }
                }
                p = route.get(route.size() - 1);
            } else {
                route.add(p);
            }
        } else {
            p = this.createPoint(start.getX(), end.getY());
            ContainerShape shape3 = this.getCollision(start, p);
            if (shape3 != null) {
                boolean detourLeft;
                DetourPoints detour = this.getDetourPoints(shape3);
                boolean bl = detourLeft = end.getX() - start.getX() < 0;
                if (p.getY() > start.getY()) {
                    p.setY(detour.topLeft.getY());
                    route.add(p);
                    if (detourLeft) {
                        route.add(detour.topLeft);
                        route.add(detour.bottomLeft);
                    } else {
                        route.add(detour.topRight);
                        route.add(detour.bottomRight);
                    }
                } else {
                    p.setY(detour.bottomLeft.getY());
                    route.add(p);
                    if (detourLeft) {
                        route.add(detour.bottomLeft);
                        route.add(detour.topLeft);
                    } else {
                        route.add(detour.bottomRight);
                        route.add(detour.topRight);
                    }
                }
                p = route.get(route.size() - 1);
            } else {
                route.add(p);
            }
        }
        if (route.isValid() && !this.calculateEnroute(route, p, end, orientation)) {
            return false;
        }
        return route.isValid();
    }

    protected DetourPoints getDetourPoints(ContainerShape shape) {
        DetourPoints detour = new DetourPoints(shape, 10);
        if (this.allShapes == null) {
            this.findAllShapes();
        }
        int i = 0;
        while (i < this.allShapes.size()) {
            DetourPoints d;
            ContainerShape s = (ContainerShape)this.allShapes.get(i);
            if (shape != s && detour.intersects(d = new DetourPoints(s, 10)) && !detour.contains(d)) {
                detour.merge(d);
                i = -1;
            }
            ++i;
        }
        return detour;
    }

    protected void optimize(ConnectionRoute route) {
        route.addSpecial(this.movedBendpoint);
        route.optimize();
        int size = route.getPoints().size();
        if (size > 1) {
            GraphicsUtil.LineSegment[] sourceEdges = GraphicsUtil.getEdges(this.source);
            Point p0 = route.getPoints().get(0);
            Point p1 = route.getPoints().get(1);
            AnchorSite sourceSite = route.getSourceAnchorSite();
            if (sourceSite == AnchorSite.LEFT || sourceSite == AnchorSite.RIGHT) {
                int x = sourceEdges[sourceSite.ordinal()].getStart().getX();
                if (GraphicsUtil.isVertical(p0, p1) && p0.getX() == x) {
                    route.setRank(3);
                }
            } else if (sourceSite == AnchorSite.TOP || sourceSite == AnchorSite.BOTTOM) {
                int y = sourceEdges[sourceSite.ordinal()].getStart().getY();
                if (GraphicsUtil.isHorizontal(p0, p1) && p0.getY() == y) {
                    route.setRank(3);
                }
            }
            if (size > 2) {
                if (GraphicsUtil.getLength(p0, p1) < 10.0) {
                    p0 = route.getPoints().get(1);
                    p1 = route.getPoints().get(2);
                    if (sourceSite == AnchorSite.LEFT || sourceSite == AnchorSite.RIGHT) {
                        if (GraphicsUtil.isVertical(p0, p1)) {
                            route.setRank(3);
                        }
                    } else if ((sourceSite == AnchorSite.TOP || sourceSite == AnchorSite.BOTTOM) && GraphicsUtil.isHorizontal(p0, p1)) {
                        route.setRank(3);
                    }
                }
                GraphicsUtil.LineSegment[] targetEdges = GraphicsUtil.getEdges(this.target);
                p0 = route.getPoints().get(size - 2);
                p1 = route.getPoints().get(size - 1);
                AnchorSite targetSite = route.getTargetAnchorSite();
                if (targetSite == AnchorSite.LEFT || targetSite == AnchorSite.RIGHT) {
                    int x = targetEdges[targetSite.ordinal()].getStart().getX();
                    if (GraphicsUtil.isVertical(p0, p1) && p0.getX() == x) {
                        route.setRank(3);
                    }
                } else if (targetSite == AnchorSite.TOP || targetSite == AnchorSite.BOTTOM) {
                    int y = targetEdges[targetSite.ordinal()].getStart().getY();
                    if (GraphicsUtil.isHorizontal(p0, p1) && p0.getY() == y) {
                        route.setRank(3);
                    }
                }
                if (GraphicsUtil.getLength(p0, p1) < 10.0) {
                    p0 = route.getPoints().get(size - 3);
                    p1 = route.getPoints().get(size - 2);
                    if (targetSite == AnchorSite.LEFT || targetSite == AnchorSite.RIGHT) {
                        if (GraphicsUtil.isVertical(p0, p1)) {
                            route.setRank(3);
                        }
                    } else if ((targetSite == AnchorSite.TOP || targetSite == AnchorSite.BOTTOM) && GraphicsUtil.isHorizontal(p0, p1)) {
                        route.setRank(3);
                    }
                }
            }
        }
    }

    static enum Orientation {
        HORIZONTAL,
        VERTICAL,
        NONE;

    }
}

