/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;

public class MultiUpdateFeature
extends AbstractUpdateFeature {
    protected List<IUpdateFeature> features = new ArrayList<IUpdateFeature>();
    protected boolean[] updateNeeded;
    protected boolean[] canUpdate;
    IReason reason = null;

    public MultiUpdateFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        boolean result = false;
        if (this.canUpdate == null) {
            this.canUpdate = new boolean[this.features.size()];
            int i = 0;
            for (IUpdateFeature f : this.features) {
                if (f.canUpdate(context)) {
                    this.canUpdate[i] = true;
                    result = true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.canUpdate.length) {
                if (this.canUpdate[i]) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public IReason updateNeeded(IUpdateContext context) {
        if (this.reason == null) {
            String text = null;
            this.canUpdate(context);
            this.updateNeeded = new boolean[this.features.size()];
            int i = 0;
            for (IUpdateFeature f : this.features) {
                IReason reason;
                if (this.canUpdate[i] && (reason = f.updateNeeded(context)).toBoolean()) {
                    this.updateNeeded[i] = true;
                    text = text == null ? String.valueOf(f.getName()) + ": " + reason.getText() : String.valueOf(text) + "\n" + f.getName() + ": " + reason.getText();
                }
                ++i;
            }
            this.reason = text != null ? Reason.createTrueReason(text) : Reason.createFalseReason();
        }
        return this.reason;
    }

    public boolean update(IUpdateContext context) {
        boolean updated = false;
        boolean forceUpdate = Boolean.TRUE.equals(context.getProperty((Object)"force.update.all"));
        this.updateNeeded(context);
        int i = 0;
        for (IUpdateFeature f : this.features) {
            if ((this.updateNeeded[i] || forceUpdate) && f.update(context)) {
                updated = true;
            }
            ++i;
        }
        return updated;
    }

    public void addFeature(IUpdateFeature feature) {
        if (feature != null) {
            this.features.add(feature);
        }
    }

    public List<IUpdateFeature> getFeatures() {
        return this.features;
    }
}

