/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.choreography;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyProperties;
import org.eclipse.bpmn2.modeler.core.utils.AnchorSite;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class ChoreographyUtil
implements ChoreographyProperties {
    public static final int ENV_W = 30;
    public static final int ENV_H = 18;
    public static final int ENVELOPE_HEIGHT_MODIFIER = 30;
    public static final String PARTICIPANT_REF_IDS = "choreography.activity.participant.ref.ids";
    public static final String INITIATING_PARTICIPANT_REF = "choreography.activity.initiating.participant.ref";
    public static final String MESSAGE_VISIBLE = "choreography.activity.band.message.visible";
    public static final String PARTICIPANT_BAND = "choreography.activity.band";
    public static final String MESSAGE_NAME = "choreography.messageName";
    public static final String MESSAGE_REF_IDS = "choreography.message.ref.ids";
    private static IGaService gaService = Graphiti.getGaService();
    private static IPeService peService = Graphiti.getPeService();

    public static List<BPMNShape> getParticipantBandBpmnShapes(ContainerShape choreographyActivityShape) {
        ArrayList<BPMNShape> bpmnShapes = new ArrayList<BPMNShape>();
        List<ContainerShape> containers = FeatureSupport.getParticipantBandContainerShapes(choreographyActivityShape);
        for (ContainerShape container : containers) {
            BPMNShape bpmnShape = BusinessObjectUtil.getFirstElementOfType((PictogramElement)container, BPMNShape.class);
            bpmnShapes.add(bpmnShape);
        }
        return bpmnShapes;
    }

    public static ContainerShape getChoreographyActivityShape(PictogramElement pe) {
        if (ChoreographyUtil.isChoreographyParticipantBand(pe)) {
            return (ContainerShape)pe.eContainer();
        }
        if (ChoreographyUtil.isChoreographyActivity(pe)) {
            return (ContainerShape)pe;
        }
        return null;
    }

    public static boolean isChoreographyParticipantBand(PictogramElement pe) {
        if (pe instanceof ContainerShape) {
            return ChoreographyUtil.isChoreographyActivity((PictogramElement)pe.eContainer());
        }
        return false;
    }

    public static boolean isChoreographyActivity(PictogramElement pe) {
        EObject bo;
        return pe instanceof ContainerShape && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof ChoreographyActivity;
    }

    public static boolean isChoreographyMessageLink(PictogramElement pe) {
        BaseElement o = BusinessObjectUtil.getFirstElementOfType(pe, BaseElement.class);
        if (o instanceof MessageFlow && pe instanceof Connection) {
            Connection c = (Connection)pe;
            if (c.getStart() != null && peService.getPropertyValue((PropertyContainer)c.getStart().getParent(), "choreography.messageLink") != null) {
                return true;
            }
            if (c.getEnd() != null && peService.getPropertyValue((PropertyContainer)c.getEnd().getParent(), "choreography.messageLink") != null) {
                return true;
            }
        }
        return false;
    }

    public static boolean isChoreographyMessage(PictogramElement pe) {
        BaseElement o = BusinessObjectUtil.getFirstElementOfType(pe, BaseElement.class);
        return o instanceof Message && pe instanceof ContainerShape && peService.getPropertyValue((PropertyContainer)pe, "choreography.messageLink") != null;
    }

    public static boolean removeChoreographyMessageLink(PictogramElement pe) {
        if (ChoreographyUtil.isChoreographyMessageLink(pe)) {
            Connection connection = (Connection)pe;
            peService.deletePictogramElement((PictogramElement)connection.getEnd().getParent());
            peService.deletePictogramElement((PictogramElement)connection);
            return true;
        }
        return false;
    }

    public static String getMessageRefIds(ContainerShape choreographyTaskShape) {
        String property = peService.getPropertyValue((PropertyContainer)choreographyTaskShape, MESSAGE_REF_IDS);
        if (property == null) {
            return new String();
        }
        return property;
    }

    public static String getMessageRefIds(ChoreographyTask choreographyTask) {
        if (choreographyTask.getMessageFlowRef() == null) {
            return new String();
        }
        Iterator iterator = choreographyTask.getMessageFlowRef().iterator();
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            MessageFlow message = (MessageFlow)iterator.next();
            sb.append(message.getId());
            if (!iterator.hasNext()) continue;
            sb.append(':');
        }
        return sb.toString();
    }

    public static String getMessageFlowName(MessageFlow flow) {
        String itemDefinitionName;
        if (flow.getMessageRef() == null) {
            return flow.getName();
        }
        if (flow.getMessageRef().getItemRef() == null || flow.getMessageRef().getItemRef().getStructureRef() == null) {
            return flow.getMessageRef().getName();
        }
        String messageName = flow.getMessageRef().getName();
        String text = itemDefinitionName = ExtendedPropertiesProvider.getTextValue((EObject)flow.getMessageRef().getItemRef());
        if (messageName != null && !messageName.isEmpty()) {
            text = String.valueOf(text) + "/" + messageName;
        }
        text = messageName;
        return text;
    }

    public static String getMessageName(Message mesg) {
        if (mesg.getItemRef() == null || mesg.getItemRef().getStructureRef() == null) {
            if (mesg.getName() == null) {
                return mesg.getId();
            }
            return mesg.getName();
        }
        String type = "(" + ExtendedPropertiesProvider.getTextValue((EObject)mesg.getItemRef()) + ")";
        if (mesg.getName() == null) {
            return type;
        }
        return String.valueOf(mesg.getName()) + type;
    }

    public static void updateChoreographyMessageLinks(IFeatureProvider fp, PictogramElement pe) {
        if (pe instanceof ContainerShape) {
            ContainerShape choreographyTaskShape = (ContainerShape)pe;
            BPMNShape bpmnShape = BusinessObjectUtil.getFirstElementOfType((PictogramElement)choreographyTaskShape, BPMNShape.class);
            Bounds bounds = bpmnShape.getBounds();
            int x = (int)(bounds.getX() + bounds.getWidth() / 2.0f - 15.0f);
            block0: for (FixPointAnchor anchor : AnchorUtil.getAnchors((AnchorContainer)choreographyTaskShape)) {
                AnchorSite site = AnchorSite.getSite(anchor);
                if (site != AnchorSite.TOP && site != AnchorSite.BOTTOM) continue;
                for (Connection connection : anchor.getOutgoingConnections()) {
                    AnchorContainer container = connection.getEnd().getParent();
                    if (!ChoreographyUtil.isChoreographyMessage((PictogramElement)container)) continue;
                    int y = site == AnchorSite.TOP ? (int)(bounds.getY() - 30.0f - 18.0f) : (int)(bounds.getY() + bounds.getHeight() + 30.0f);
                    gaService.setLocation(container.getGraphicsAlgorithm(), x, y);
                    continue block0;
                }
            }
        }
    }

    public static void updateParticipantBands(IFeatureProvider fp, PictogramElement pe) {
        UpdateContext updateContext = new UpdateContext(pe);
        updateContext.putProperty((Object)"force.update.all", (Object)Boolean.TRUE);
        IUpdateFeature updateFeature = fp.getUpdateFeature((IUpdateContext)updateContext);
        updateFeature.update((IUpdateContext)updateContext);
        LayoutContext layoutContext = new LayoutContext(pe);
        ILayoutFeature layoutFeature = fp.getLayoutFeature((ILayoutContext)layoutContext);
        layoutFeature.layout((ILayoutContext)layoutContext);
    }

    public static String getParticipantRefIds(ChoreographyActivity choreographyActivity) {
        if (choreographyActivity.getParticipantRefs() == null) {
            return new String();
        }
        Iterator iterator = choreographyActivity.getParticipantRefs().iterator();
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            boolean multiple;
            Participant participant = (Participant)iterator.next();
            sb.append(participant.getId());
            boolean bl = multiple = participant.getParticipantMultiplicity() != null && participant.getParticipantMultiplicity().getMaximum() > 1;
            if (multiple) {
                sb.append('*');
            }
            if (!iterator.hasNext()) continue;
            sb.append(':');
        }
        return sb.toString();
    }

    public static String getParticipantRefIds(ContainerShape choreographyActivityShape) {
        String property = peService.getPropertyValue((PropertyContainer)choreographyActivityShape, PARTICIPANT_REF_IDS);
        if (property == null) {
            return new String();
        }
        return property;
    }
}

