/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.utils.AnchorSite;
import org.eclipse.bpmn2.modeler.core.utils.AnchorType;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.mm.pictograms.PictogramsFactory;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ICreateService;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class AnchorUtil {
    public static final int CONNECTION_POINT_SIZE = 4;
    private static final IPeService peService = Graphiti.getPeService();
    private static final IGaService gaService = Graphiti.getGaService();
    private static final ICreateService createService = Graphiti.getCreateService();

    public static FixPointAnchor createAnchor(AnchorContainer ac, AnchorSite site) {
        if (ac instanceof Shape) {
            ILocation loc = peService.getLocationRelativeToDiagram((Shape)ac);
            IDimension size = GraphicsUtil.calculateSize((PictogramElement)((Shape)ac));
            int x = 0;
            int y = 0;
            switch (site) {
                case BOTTOM: {
                    x = loc.getX() + size.getWidth() / 2;
                    y = loc.getY() + size.getHeight();
                    break;
                }
                case LEFT: {
                    x = loc.getX();
                    y = loc.getY() + size.getHeight() / 2;
                    break;
                }
                case RIGHT: {
                    x = loc.getX() + size.getWidth();
                    y = loc.getY() + size.getHeight() / 2;
                    break;
                }
                case TOP: {
                    x = loc.getX() + size.getWidth() / 2;
                    y = loc.getY();
                    break;
                }
                case CENTER: {
                    x = loc.getX() + size.getWidth() / 2;
                    y = loc.getY() + size.getHeight() / 2;
                    break;
                }
            }
            return AnchorUtil.createAnchor(ac, x, y);
        }
        return null;
    }

    public static FixPointAnchor createAnchor(AnchorContainer ac, int x, int y, AnchorType at) {
        return AnchorUtil.createAnchor(ac, gaService.createPoint(x, y), at);
    }

    public static FixPointAnchor createAnchor(AnchorContainer ac, Point p, AnchorType at) {
        FixPointAnchor anchor = AnchorUtil.createBoundaryAnchor(ac, p);
        AnchorType.setType((Anchor)anchor, at);
        return anchor;
    }

    public static FixPointAnchor createAnchor(AnchorContainer ac, int x, int y) {
        return AnchorUtil.createAnchor(ac, gaService.createPoint(x, y));
    }

    public static FixPointAnchor createAnchor(AnchorContainer ac, Point p) {
        if (AnchorUtil.isConnectionAnchorContainer(ac)) {
            return (FixPointAnchor)ac.getAnchors().get(0);
        }
        if (ac instanceof Connection) {
            return AnchorUtil.createConnectionAnchor((Connection)ac);
        }
        FixPointAnchor anchor = AnchorUtil.createBoundaryAnchor(ac, p);
        AnchorType at = AnchorType.getType(ac);
        AnchorType.setType((Anchor)anchor, at);
        return anchor;
    }

    public static List<FixPointAnchor> getAnchors(AnchorContainer ac, AnchorSite site) {
        ArrayList<FixPointAnchor> result = new ArrayList<FixPointAnchor>();
        for (Anchor anchor : ac.getAnchors()) {
            if (peService.getPropertyValue((PropertyContainer)anchor, "anchor.type") == null || AnchorSite.getSite((FixPointAnchor)anchor) != site) continue;
            result.add((FixPointAnchor)anchor);
        }
        return result;
    }

    public static List<FixPointAnchor> getAnchors(AnchorContainer ac) {
        ArrayList<FixPointAnchor> result;
        block4: {
            block3: {
                result = new ArrayList<FixPointAnchor>();
                if (!(ac instanceof Connection)) break block3;
                Connection connection = (Connection)ac;
                for (ConnectionDecorator cd : connection.getConnectionDecorators()) {
                    if (!AnchorUtil.isConnectionAnchorContainer((AnchorContainer)cd)) continue;
                    for (Anchor a : cd.getAnchors()) {
                        result.add((FixPointAnchor)a);
                    }
                }
                break block4;
            }
            if (ac == null) break block4;
            for (Anchor anchor : ac.getAnchors()) {
                if (peService.getPropertyValue((PropertyContainer)anchor, "anchor.type") == null) continue;
                result.add((FixPointAnchor)anchor);
            }
        }
        return result;
    }

    public static int countAnchors(AnchorContainer ac, AnchorSite site) {
        int count = 0;
        for (Anchor anchor : ac.getAnchors()) {
            if (peService.getPropertyValue((PropertyContainer)anchor, "anchor.type") == null || AnchorSite.getSite((FixPointAnchor)anchor) != site) continue;
            ++count;
        }
        return count;
    }

    public static void moveAnchor(FixPointAnchor anchor, int x, int y) {
        AnchorUtil.moveAnchor(anchor, GraphicsUtil.createPoint(x, y));
    }

    public static void moveAnchor(FixPointAnchor anchor, Point p) {
        AnchorContainer parent = anchor.getParent();
        if (AnchorUtil.isConnectionAnchorContainer(parent)) {
            return;
        }
        if (parent instanceof Shape) {
            AnchorSite site;
            p = GraphicsUtil.createPoint(p);
            ILocation loc = peService.getLocationRelativeToDiagram((Shape)parent);
            GraphicsUtil.LineSegment edge = GraphicsUtil.findNearestEdge((Shape)parent, p);
            if (edge.isHorizontal()) {
                int y = edge.getStart().getY();
                site = y == loc.getY() ? AnchorSite.TOP : AnchorSite.BOTTOM;
                p.setY(y - loc.getY());
                int x = p.getX();
                if (x < edge.getStart().getX()) {
                    x = edge.getStart().getX();
                }
                if (x > edge.getEnd().getX()) {
                    x = edge.getEnd().getX();
                }
                p.setX(x - loc.getX());
            } else {
                int x = edge.getStart().getX();
                site = x == loc.getX() ? AnchorSite.LEFT : AnchorSite.RIGHT;
                p.setX(x - loc.getX());
                int y = p.getY();
                if (y < edge.getStart().getY()) {
                    y = edge.getStart().getY();
                }
                if (y > edge.getEnd().getY()) {
                    y = edge.getEnd().getY();
                }
                p.setY(y - loc.getY());
            }
            AnchorSite.setSite(anchor, site);
        }
        anchor.setLocation(p);
    }

    public static void moveAnchor(FixPointAnchor anchor, FixPointAnchor refAnchor) {
        AnchorContainer parent = anchor.getParent();
        if (AnchorUtil.isConnectionAnchorContainer(parent)) {
            return;
        }
        AnchorContainer refParent = refAnchor.getParent();
        AnchorSite refSite = AnchorSite.getSite(refAnchor);
        Point p = GraphicsUtil.createPoint((Anchor)refAnchor);
        if (parent instanceof Shape && refParent instanceof Shape && refSite != null) {
            AnchorSite site;
            GraphicsUtil.LineSegment refEdge = GraphicsUtil.getEdges((Shape)refParent)[refSite.ordinal()];
            ILocation loc = peService.getLocationRelativeToDiagram((Shape)parent);
            GraphicsUtil.LineSegment edge = GraphicsUtil.findNearestEdge((Shape)parent, refEdge.getStart(), refEdge.getEnd());
            if (edge.isHorizontal()) {
                int y = edge.getStart().getY();
                site = y == loc.getY() ? AnchorSite.TOP : AnchorSite.BOTTOM;
                p.setY(y - loc.getY());
                int x = p.getX();
                if (x < edge.getStart().getX()) {
                    x = edge.getStart().getX();
                }
                if (x > edge.getEnd().getX()) {
                    x = edge.getEnd().getX();
                }
                p.setX(x - loc.getX());
            } else {
                int x = edge.getStart().getX();
                site = x == loc.getX() ? AnchorSite.LEFT : AnchorSite.RIGHT;
                p.setX(x - loc.getX());
                int y = p.getY();
                if (y < edge.getStart().getY()) {
                    y = edge.getStart().getY();
                }
                if (y > edge.getEnd().getY()) {
                    y = edge.getEnd().getY();
                }
                p.setY(y - loc.getY());
            }
            AnchorSite.setSite(anchor, site);
            anchor.setLocation(p);
        } else {
            AnchorUtil.moveAnchor(anchor, p);
        }
    }

    public static List<Connection> getConnections(AnchorContainer ac, AnchorSite site) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (Anchor a : ac.getAnchors()) {
            if (peService.getPropertyValue((PropertyContainer)a, "anchor.type") == null || site != AnchorSite.getSite((FixPointAnchor)a)) continue;
            connections.addAll((Collection<Connection>)a.getIncomingConnections());
            connections.addAll((Collection<Connection>)a.getOutgoingConnections());
        }
        return connections;
    }

    public static void adjustAnchors(AnchorContainer ac) {
        if (ac instanceof ConnectionDecorator) {
            for (Anchor a : ac.getAnchors()) {
                String property = peService.getPropertyValue((PropertyContainer)a, "anchor.type");
                if (property == null || !a.getIncomingConnections().isEmpty() || !a.getOutgoingConnections().isEmpty()) continue;
                peService.deletePictogramElement((PictogramElement)ac);
                return;
            }
        } else if (ac != null) {
            AnchorUtil.deleteUnusedAnchors(ac);
            AnchorUtil.relocateAnchors(ac);
        }
    }

    public static AnchorContainer getAnchorContainer(Anchor anchor) {
        AnchorContainer ac = anchor.getParent();
        return ac;
    }

    private static FixPointAnchor createBoundaryAnchor(AnchorContainer ac, Point p) {
        FixPointAnchor anchor = peService.createFixPointAnchor(ac);
        AnchorUtil.moveAnchor(anchor, p);
        gaService.createInvisibleRectangle((PictogramElement)anchor);
        return anchor;
    }

    private static FixPointAnchor createConnectionAnchor(Connection connection) {
        Diagram diagram = peService.getDiagramForPictogramElement((PictogramElement)connection);
        ConnectionDecorator decorator = createService.createConnectionDecorator(connection, true, 0.5, true);
        peService.setPropertyValue((PropertyContainer)decorator, "connection.point", Boolean.TRUE.toString());
        Rectangle rectangle = createService.createRectangle((GraphicsAlgorithmContainer)decorator);
        rectangle.setFilled(Boolean.valueOf(true));
        rectangle.setForeground(Graphiti.getGaService().manageColor(diagram, StyleUtil.CLASS_FOREGROUND));
        rectangle.setX(-2);
        rectangle.setY(-2);
        rectangle.setWidth(4);
        rectangle.setHeight(4);
        PictogramLink link = AnchorUtil.createPictogramLink((PictogramElement)decorator);
        BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection);
        link.getBusinessObjects().add((Object)be);
        FixPointAnchor anchor = createService.createFixPointAnchor((AnchorContainer)decorator);
        AnchorSite.setSite(anchor, AnchorSite.CENTER);
        AnchorType.setType((Anchor)anchor, AnchorType.CONNECTION);
        anchor.setLocation(GraphicsUtil.createPoint(2, 2));
        peService.setPropertyValue((PropertyContainer)anchor, "connection.point", Boolean.TRUE.toString());
        createService.createInvisibleRectangle((PictogramElement)anchor);
        ConnectionAnchorAdapter.adapt((Anchor)anchor);
        return anchor;
    }

    private static boolean isConnectionAnchorContainer(AnchorContainer ac) {
        return Boolean.TRUE.toString().equals(peService.getPropertyValue((PropertyContainer)ac, "connection.point"));
    }

    private static void deleteUnusedAnchors(AnchorContainer ac) {
        if (ac != null) {
            ArrayList<Anchor> deleted = new ArrayList<Anchor>();
            for (Anchor a : ac.getAnchors()) {
                String property = peService.getPropertyValue((PropertyContainer)a, "anchor.type");
                if (property == null || !a.getIncomingConnections().isEmpty() || !a.getOutgoingConnections().isEmpty()) continue;
                deleted.add(a);
            }
            for (Anchor a : deleted) {
                peService.deletePictogramElement((PictogramElement)a);
            }
        }
    }

    private static void relocateAnchors(AnchorContainer ac) {
        IDimension size = GraphicsUtil.calculateSize((PictogramElement)ac);
        AnchorUtil.relocateAnchors(ac, size.getWidth(), size.getHeight());
    }

    private static void relocateAnchors(AnchorContainer ac, int w, int h) {
        AnchorSite site;
        FixPointAnchor anchor;
        AnchorType at;
        if (ac == null || AnchorUtil.isConnectionAnchorContainer(ac)) {
            return;
        }
        int topCount = 0;
        int bottomCount = 0;
        int leftCount = 0;
        int rightCount = 0;
        int topOffset = 0;
        int bottomOffset = 0;
        int leftOffset = 0;
        int rightOffset = 0;
        ArrayList<FixPointAnchor> topAnchors = null;
        ArrayList<FixPointAnchor> bottomAnchors = null;
        ArrayList<FixPointAnchor> leftAnchors = null;
        ArrayList<FixPointAnchor> rightAnchors = null;
        for (Anchor a : ac.getAnchors()) {
            at = AnchorType.getType(a);
            if (at != AnchorType.ACTIVITY && at != AnchorType.MESSAGELINK) continue;
            anchor = (FixPointAnchor)a;
            site = AnchorSite.getSite(anchor);
            switch (site) {
                case BOTTOM: {
                    ++bottomCount;
                    if (bottomAnchors == null) {
                        bottomAnchors = new ArrayList<FixPointAnchor>();
                    }
                    bottomAnchors.add(anchor);
                    break;
                }
                case CENTER: {
                    break;
                }
                case LEFT: {
                    ++leftCount;
                    if (leftAnchors == null) {
                        leftAnchors = new ArrayList<FixPointAnchor>();
                    }
                    leftAnchors.add(anchor);
                    break;
                }
                case RIGHT: {
                    ++rightCount;
                    if (rightAnchors == null) {
                        rightAnchors = new ArrayList<FixPointAnchor>();
                    }
                    rightAnchors.add(anchor);
                    break;
                }
                case TOP: {
                    ++topCount;
                    if (topAnchors == null) {
                        topAnchors = new ArrayList<FixPointAnchor>();
                    }
                    topAnchors.add(anchor);
                    break;
                }
            }
        }
        for (Anchor a : ac.getAnchors()) {
            AnchorSite site2;
            at = AnchorType.getType(a);
            if (at == AnchorType.ACTIVITY) {
                FixPointAnchor anchor2 = (FixPointAnchor)a;
                site2 = AnchorSite.getSite(anchor2);
                switch (site2) {
                    case BOTTOM: {
                        int index = AnchorUtil.calculateIndex(anchor2, bottomAnchors);
                        bottomOffset = index >= 0 ? (index + 1) * w / (bottomCount + 1) : (bottomOffset += w / (bottomCount + 1));
                        anchor2.setLocation(gaService.createPoint(bottomOffset, h));
                        break;
                    }
                    case CENTER: {
                        break;
                    }
                    case LEFT: {
                        int index = AnchorUtil.calculateIndex(anchor2, leftAnchors);
                        leftOffset = index >= 0 ? (index + 1) * w / (leftCount + 1) : (leftOffset += h / (leftCount + 1));
                        anchor2.setLocation(gaService.createPoint(0, leftOffset));
                        break;
                    }
                    case RIGHT: {
                        int index = AnchorUtil.calculateIndex(anchor2, rightAnchors);
                        rightOffset = index >= 0 ? (index + 1) * w / (rightCount + 1) : (rightOffset += h / (rightCount + 1));
                        anchor2.setLocation(gaService.createPoint(w, rightOffset));
                        break;
                    }
                    case TOP: {
                        int index = AnchorUtil.calculateIndex(anchor2, topAnchors);
                        topOffset = index >= 0 ? (index + 1) * w / (topCount + 1) : (topOffset += w / (topCount + 1));
                        anchor2.setLocation(gaService.createPoint(topOffset, 0));
                        break;
                    }
                }
                continue;
            }
            if (at == AnchorType.GATEWAY || at == AnchorType.MESSAGELINK) {
                anchor = (FixPointAnchor)a;
                site = AnchorSite.getSite(anchor);
                switch (site) {
                    case BOTTOM: {
                        anchor.setLocation(gaService.createPoint(w / 2, h));
                        break;
                    }
                    case CENTER: {
                        break;
                    }
                    case LEFT: {
                        anchor.setLocation(gaService.createPoint(0, h / 2));
                        break;
                    }
                    case RIGHT: {
                        anchor.setLocation(gaService.createPoint(w, h / 2));
                        break;
                    }
                    case TOP: {
                        anchor.setLocation(gaService.createPoint(w / 2, 0));
                        break;
                    }
                }
                continue;
            }
            if (at != AnchorType.POOL) continue;
            anchor = (FixPointAnchor)a;
            Point p = anchor.getLocation();
            if (p.getX() > w) {
                p.setX(w);
            }
            if (p.getY() > h) {
                p.setY(h);
            }
            site2 = AnchorSite.getSite(anchor);
            switch (site2) {
                case BOTTOM: {
                    anchor.setLocation(gaService.createPoint(p.getX(), h));
                    break;
                }
                case CENTER: {
                    break;
                }
                case LEFT: {
                    anchor.setLocation(gaService.createPoint(0, p.getY()));
                    break;
                }
                case RIGHT: {
                    anchor.setLocation(gaService.createPoint(w, p.getY()));
                    break;
                }
                case TOP: {
                    anchor.setLocation(gaService.createPoint(p.getX(), 0));
                    break;
                }
            }
        }
    }

    private static FixPointAnchor getOpposite(FixPointAnchor anchor) {
        Anchor a = null;
        if (anchor.getOutgoingConnections().isEmpty()) {
            if (anchor.getIncomingConnections().isEmpty()) {
                return null;
            }
            a = ((Connection)anchor.getIncomingConnections().get(0)).getStart();
        } else {
            a = ((Connection)anchor.getOutgoingConnections().get(0)).getEnd();
        }
        return a instanceof FixPointAnchor ? (FixPointAnchor)a : null;
    }

    private static int calculateIndex(FixPointAnchor anchor, List<FixPointAnchor> all) {
        return -1;
    }

    private static PictogramLink createPictogramLink(PictogramElement pe) {
        PictogramLink ret = null;
        Diagram diagram = Graphiti.getPeService().getDiagramForPictogramElement(pe);
        if (diagram != null) {
            ret = PictogramsFactory.eINSTANCE.createPictogramLink();
            ret.setPictogramElement(pe);
            diagram.getPictogramLinks().add((Object)ret);
        }
        return ret;
    }

    private static class ConnectionAnchorAdapter
    extends AdapterImpl {
        Anchor anchor;
        private boolean deleting = false;

        public static ConnectionAnchorAdapter adapt(Anchor anchor) {
            return new ConnectionAnchorAdapter(anchor);
        }

        private ConnectionAnchorAdapter(Anchor anchor) {
            this.anchor = anchor;
            anchor.eAdapters().add((Object)this);
            this.setTarget((Notifier)anchor);
        }

        public void notifyChanged(Notification notification) {
            int et;
            if (!this.deleting && notification.getNotifier() == this.anchor && (et = notification.getEventType()) == 4 && this.anchor.getIncomingConnections().isEmpty() && this.anchor.getOutgoingConnections().isEmpty()) {
                this.deleting = true;
                if (this.anchor.eContainer() != null) {
                    Graphiti.getPeService().deletePictogramElement((PictogramElement)this.anchor.getParent());
                }
            }
        }
    }
}

