/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CallChoreography;
import org.eclipse.bpmn2.CallableElement;
import org.eclipse.bpmn2.CategoryValue;
import org.eclipse.bpmn2.Choreography;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.CorrelationPropertyRetrievalExpression;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Group;
import org.eclipse.bpmn2.ImplicitThrowEvent;
import org.eclipse.bpmn2.IntermediateCatchEvent;
import org.eclipse.bpmn2.IntermediateThrowEvent;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.ReceiveTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubChoreography;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.Transaction;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.ParticipantBandKind;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectPropertyProvider;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.AbstractConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.MultiUpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.label.UpdateLabelFeature;
import org.eclipse.bpmn2.modeler.core.model.ModelHandler;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.MmFactory;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;

public class FeatureSupport {
    public static boolean isValidFlowElementTarget(ITargetContext context) {
        boolean intoDiagram = context.getTargetContainer() instanceof Diagram;
        boolean intoLane = FeatureSupport.isTargetLane(context) && FeatureSupport.isTargetLaneOnTop(context);
        boolean intoParticipant = FeatureSupport.isTargetParticipant(context);
        boolean intoFlowElementContainer = FeatureSupport.isTargetFlowElementsContainer(context);
        boolean intoGroup = FeatureSupport.isTargetGroup(context);
        return (intoDiagram || intoLane || intoParticipant || intoFlowElementContainer) && !intoGroup;
    }

    public static boolean isValidArtifactTarget(ITargetContext context) {
        boolean intoDiagram = context.getTargetContainer() instanceof Diagram;
        boolean intoLane = FeatureSupport.isTargetLane(context) && FeatureSupport.isTargetLaneOnTop(context);
        boolean intoParticipant = FeatureSupport.isTargetParticipant(context);
        boolean intoSubProcess = FeatureSupport.isTargetSubProcess(context);
        boolean intoSubChoreography = FeatureSupport.isTargetSubChoreography(context);
        boolean intoGroup = FeatureSupport.isTargetGroup(context);
        return (intoDiagram || intoLane || intoParticipant || intoSubProcess || intoSubChoreography) && !intoGroup;
    }

    public static boolean isChoreographyParticipantBand(PictogramElement element) {
        EObject container;
        if (element != null && (container = element.eContainer()) instanceof PictogramElement) {
            PictogramElement containerElem = (PictogramElement)container;
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(containerElem);
            if (bo instanceof ChoreographyActivity) {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidDataTarget(ITargetContext context) {
        EObject containerBO = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
        boolean intoDiagram = containerBO instanceof BPMNDiagram;
        boolean intoSubProcess = containerBO instanceof FlowElementsContainer;
        if (intoSubProcess || intoDiagram) {
            return true;
        }
        if (FeatureSupport.isTargetLane(context) && FeatureSupport.isTargetLaneOnTop(context)) {
            return true;
        }
        return FeatureSupport.isTargetParticipant(context);
    }

    public static boolean isTargetSubProcess(ITargetContext context) {
        return BusinessObjectUtil.containsElementOfType((PictogramElement)context.getTargetContainer(), SubProcess.class);
    }

    public static boolean isTargetSubChoreography(ITargetContext context) {
        return BusinessObjectUtil.containsElementOfType((PictogramElement)context.getTargetContainer(), SubChoreography.class);
    }

    public static boolean isTargetLane(ITargetContext context) {
        return FeatureSupport.isLane((PictogramElement)context.getTargetContainer());
    }

    public static boolean isLane(PictogramElement element) {
        return element instanceof ContainerShape && BusinessObjectUtil.containsElementOfType(element, Lane.class);
    }

    public static Lane getTargetLane(ITargetContext context) {
        ContainerShape element = context.getTargetContainer();
        return BusinessObjectUtil.getFirstElementOfType((PictogramElement)element, Lane.class);
    }

    public static boolean isTargetGroup(ITargetContext context) {
        Group group = BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getTargetContainer(), Group.class);
        return group != null;
    }

    public static boolean isTargetParticipant(ITargetContext context) {
        return FeatureSupport.isParticipant((PictogramElement)context.getTargetContainer());
    }

    public static boolean isParticipant(PictogramElement element) {
        return element instanceof ContainerShape && BusinessObjectUtil.containsElementOfType(element, Participant.class) && !FeatureSupport.isChoreographyParticipantBand(element);
    }

    public static Participant getTargetParticipant(ITargetContext context) {
        ContainerShape element = context.getTargetContainer();
        return BusinessObjectUtil.getFirstElementOfType((PictogramElement)element, Participant.class);
    }

    public static SubProcess getTargetSubProcess(ITargetContext context) {
        ContainerShape element = context.getTargetContainer();
        return BusinessObjectUtil.getFirstElementOfType((PictogramElement)element, SubProcess.class);
    }

    public static boolean isTargetFlowElementsContainer(ITargetContext context) {
        return BusinessObjectUtil.containsElementOfType((PictogramElement)context.getTargetContainer(), FlowElementsContainer.class);
    }

    public static FlowElementsContainer getTargetFlowElementsContainer(ITargetContext context) {
        ContainerShape element = context.getTargetContainer();
        return BusinessObjectUtil.getFirstElementOfType((PictogramElement)element, FlowElementsContainer.class);
    }

    public static boolean isLaneOnTop(Lane lane) {
        return lane.getChildLaneSet() == null || lane.getChildLaneSet().getLanes().isEmpty();
    }

    public static boolean isTargetLaneOnTop(ITargetContext context) {
        Lane lane = BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getTargetContainer(), Lane.class);
        return lane.getChildLaneSet() == null || lane.getChildLaneSet().getLanes().isEmpty();
    }

    public static EObject getTargetObject(ITargetContext context) {
        ContainerShape targetContainer = context.getTargetContainer();
        EObject targetObject = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)targetContainer);
        if (targetObject instanceof BPMNDiagram) {
            targetObject = ((BPMNDiagram)targetObject).getPlane().getBpmnElement();
        }
        if (targetObject instanceof Lane) {
            while (targetObject != null) {
                if ((targetObject = targetObject.eContainer()) instanceof FlowElementsContainer) break;
            }
        }
        if (targetObject instanceof Collaboration && !(targetObject instanceof Choreography)) {
            Collaboration collaboration = (Collaboration)targetObject;
            for (Participant p : collaboration.getParticipants()) {
                if (p.getProcessRef() == null) continue;
                targetObject = p.getProcessRef();
                break;
            }
        }
        if (targetObject instanceof Participant) {
            targetObject = ((Participant)targetObject).getProcessRef();
        }
        return targetObject;
    }

    public static boolean isHorizontal(ContainerShape container) {
        EObject parent = container.eContainer();
        if (parent instanceof PictogramElement && BusinessObjectUtil.getFirstElementOfType((PictogramElement)parent, ChoreographyActivity.class) != null) {
            return false;
        }
        String v = Graphiti.getPeService().getPropertyValue((PropertyContainer)container, "isHorizontal");
        if (v == null) {
            BPMNShape bpmnShape = DIUtils.findBPMNShape(BusinessObjectUtil.getFirstBaseElement((PictogramElement)container));
            if (bpmnShape != null) {
                return bpmnShape.isIsHorizontal();
            }
            return Bpmn2Preferences.getInstance((EObject)container).isHorizontalDefault();
        }
        return Boolean.parseBoolean(v);
    }

    public static void setHorizontal(ContainerShape container, boolean isHorizontal) {
        Graphiti.getPeService().setPropertyValue((PropertyContainer)container, "isHorizontal", Boolean.toString(isHorizontal));
        BPMNShape bs = BusinessObjectUtil.getFirstElementOfType((PictogramElement)container, BPMNShape.class);
        if (bs != null) {
            bs.setIsHorizontal(isHorizontal);
        }
    }

    public static boolean isHorizontal(IContext context) {
        Object v = context.getProperty((Object)"isHorizontal");
        if (v == null) {
            Bpmn2Preferences preferences = Bpmn2Preferences.getInstance();
            return preferences.isHorizontalDefault();
        }
        return (Boolean)v;
    }

    public static void setHorizontal(IContext context, boolean isHorizontal) {
        context.putProperty((Object)"isHorizontal", (Object)isHorizontal);
    }

    public static boolean isBpmnShape(PictogramElement pe) {
        return pe instanceof ContainerShape && BusinessObjectUtil.getFirstBaseElement(pe) != null && BusinessObjectUtil.getFirstElementOfType(pe, BPMNShape.class) != null;
    }

    public static List<PictogramElement> getContainerChildren(ContainerShape container) {
        ArrayList<PictogramElement> list = new ArrayList<PictogramElement>();
        for (PictogramElement pe : container.getChildren()) {
            if (ShapeDecoratorUtil.isActivityBorder(pe) || ShapeDecoratorUtil.isValidationDecorator(pe) || FeatureSupport.isLabelShape(pe)) continue;
            list.add(pe);
        }
        return list;
    }

    public static List<PictogramElement> getContainerDecorators(ContainerShape container) {
        ArrayList<PictogramElement> list = new ArrayList<PictogramElement>();
        for (PictogramElement pe : container.getChildren()) {
            if (!ShapeDecoratorUtil.isActivityBorder(pe)) continue;
            list.add(pe);
        }
        return list;
    }

    public static void setContainerChildrenVisible(IFeatureProvider fp, ContainerShape container, boolean visible) {
        ArrayList list = new ArrayList();
        list.addAll(container.getChildren());
        for (PictogramElement pe : list) {
            if (ShapeDecoratorUtil.isActivityBorder(pe)) continue;
            if (ShapeDecoratorUtil.isEventSubProcessDecorator(pe)) {
                pe.setVisible(!visible);
            } else {
                pe.setVisible(visible);
            }
            if (visible) {
                FeatureSupport.updateLabel(fp, pe, null);
            }
            if (!(pe instanceof AnchorContainer)) continue;
            AnchorContainer ac = (AnchorContainer)pe;
            for (Anchor a : ac.getAnchors()) {
                for (Connection c : a.getOutgoingConnections()) {
                    c.setVisible(visible);
                    if (visible) {
                        FeatureSupport.updateLabel(fp, (PictogramElement)c, null);
                    }
                    for (ConnectionDecorator decorator : c.getConnectionDecorators()) {
                        decorator.setVisible(visible);
                    }
                }
            }
        }
    }

    public static ContainerShape getRootContainer(ContainerShape container) {
        ContainerShape parent = container.getContainer();
        BaseElement bo = BusinessObjectUtil.getFirstElementOfType((PictogramElement)parent, BaseElement.class);
        if (bo != null && (bo instanceof Lane || bo instanceof Participant)) {
            return FeatureSupport.getRootContainer(parent);
        }
        return container;
    }

    public static Participant getTargetParticipant(ITargetContext context, ModelHandler handler) {
        if (context.getTargetContainer() instanceof Diagram) {
            return handler.getInternalParticipant();
        }
        BaseElement bo = BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getTargetContainer(), BaseElement.class);
        if (bo instanceof Participant) {
            return (Participant)bo;
        }
        return handler.getParticipant(bo);
    }

    public static Shape getShape(ContainerShape container, String property, String expectedValue) {
        IPeService peService = Graphiti.getPeService();
        for (Shape shape : peService.getAllContainedShapes(container)) {
            String value = peService.getPropertyValue((PropertyContainer)shape, property);
            if (value == null || !value.equals(expectedValue)) continue;
            return shape;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static ContainerShape getFirstLaneInContainer(ContainerShape root) {
        block2: {
            block3: {
                laneShapes = BusinessObjectUtil.getChildElementsOfType(root, Lane.class);
                if (laneShapes.isEmpty() || !((result = (iterator = laneShapes.iterator()).next()) instanceof ContainerShape)) break block2;
                ga = result.getGraphicsAlgorithm();
                if (!FeatureSupport.isHorizontal(root)) ** GOTO lbl14
                while (iterator.hasNext()) {
                    currentShape = iterator.next();
                    if (!(currentShape instanceof ContainerShape) || currentShape.getGraphicsAlgorithm().getY() >= ga.getY()) continue;
                    result = currentShape;
                }
                break block3;
lbl-1000:
                // 1 sources

                {
                    currentShape = iterator.next();
                    if (!(currentShape instanceof ContainerShape) || currentShape.getGraphicsAlgorithm().getX() >= ga.getX()) continue;
                    result = currentShape;
lbl14:
                    // 3 sources

                    ** while (iterator.hasNext())
                }
            }
            return (ContainerShape)result;
        }
        return root;
    }

    /*
     * Unable to fully structure code
     */
    public static ContainerShape getLastLaneInContainer(ContainerShape root) {
        block2: {
            block3: {
                laneShapes = BusinessObjectUtil.getChildElementsOfType(root, Lane.class);
                if (laneShapes.isEmpty() || !((result = (iterator = laneShapes.iterator()).next()) instanceof ContainerShape)) break block2;
                ga = result.getGraphicsAlgorithm();
                if (!FeatureSupport.isHorizontal(root)) ** GOTO lbl14
                while (iterator.hasNext()) {
                    currentShape = iterator.next();
                    if (!(currentShape instanceof ContainerShape) || currentShape.getGraphicsAlgorithm().getY() <= ga.getY()) continue;
                    result = currentShape;
                }
                break block3;
lbl-1000:
                // 1 sources

                {
                    currentShape = iterator.next();
                    if (!(currentShape instanceof ContainerShape) || currentShape.getGraphicsAlgorithm().getX() <= ga.getX()) continue;
                    result = currentShape;
lbl14:
                    // 3 sources

                    ** while (iterator.hasNext())
                }
            }
            return (ContainerShape)result;
        }
        return root;
    }

    public static List<PictogramElement> getPoolOrLaneChildren(ContainerShape containerShape) {
        ArrayList<PictogramElement> children = new ArrayList<PictogramElement>();
        for (PictogramElement pe : containerShape.getChildren()) {
            BaseElement be = BusinessObjectUtil.getFirstElementOfType(pe, BaseElement.class);
            if (!(pe instanceof ContainerShape) || FeatureSupport.isLane(pe) || be == null) continue;
            children.add(pe);
        }
        return children;
    }

    public static List<PictogramElement> getPoolAndLaneDescendants(ContainerShape containerShape) {
        ArrayList<PictogramElement> children = new ArrayList<PictogramElement>();
        FeatureSupport.collectChildren(containerShape, children, false);
        return children;
    }

    public static void collectChildren(ContainerShape containerShape, List<PictogramElement> descendants, boolean includeLanes) {
        for (PictogramElement pe : containerShape.getChildren()) {
            if (!(pe instanceof ContainerShape)) continue;
            if (FeatureSupport.isLane(pe)) {
                if (includeLanes) {
                    descendants.add(pe);
                }
                FeatureSupport.collectChildren((ContainerShape)pe, descendants, includeLanes);
                continue;
            }
            if (!FeatureSupport.isBpmnShape(pe)) continue;
            descendants.add(pe);
            for (Anchor a : ((ContainerShape)pe).getAnchors()) {
                for (Connection c : a.getIncomingConnections()) {
                    if (!(c instanceof FreeFormConnection) || descendants.contains(c)) continue;
                    descendants.add((PictogramElement)c);
                }
                for (Connection c : a.getOutgoingConnections()) {
                    if (!(c instanceof FreeFormConnection) || descendants.contains(c)) continue;
                    descendants.add((PictogramElement)c);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasBpmnDiagram(BaseElement baseElement) {
        CallableElement ce;
        Process process = null;
        if (baseElement instanceof Participant) {
            process = ((Participant)baseElement).getProcessRef();
        } else if (baseElement instanceof CallActivity && (ce = ((CallActivity)baseElement).getCalledElementRef()) instanceof Process) {
            process = (Process)ce;
        }
        if (process != null) {
            baseElement = process;
        }
        try {
            BPMNDiagram d;
            Definitions definitions = ModelUtil.getDefinitions(baseElement);
            Iterator iterator = definitions.getDiagrams().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((d = (BPMNDiagram)iterator.next()).getPlane().getBpmnElement() != baseElement);
            return true;
        }
        catch (Exception exception) {}
        return false;
    }

    public static List<ContainerShape> findGroupedShapes(ContainerShape groupShape) {
        Diagram diagram = null;
        EObject parent = groupShape.eContainer();
        while (parent != null) {
            if (parent instanceof Diagram) {
                diagram = (Diagram)parent;
                break;
            }
            parent = parent.eContainer();
        }
        ArrayList<ContainerShape> list = new ArrayList<ContainerShape>();
        if (diagram != null && FeatureSupport.isGroupShape((PictogramElement)groupShape)) {
            TreeIterator iter = diagram.eAllContents();
            while (iter.hasNext()) {
                EObject child = (EObject)iter.next();
                if (!(child instanceof ContainerShape) || child == groupShape || list.contains(child) || FeatureSupport.isLabelShape((PictogramElement)((ContainerShape)child))) continue;
                ContainerShape shape = (ContainerShape)child;
                if (FeatureSupport.isGroupShape((PictogramElement)shape)) {
                    if (!GraphicsUtil.contains((Shape)groupShape, (Shape)shape) || list.contains(shape)) continue;
                    list.add(shape);
                    continue;
                }
                if (!GraphicsUtil.contains((Shape)groupShape, (Shape)shape)) continue;
                if (!list.contains(shape)) {
                    list.add(shape);
                }
                while (!(shape.getContainer() instanceof Diagram)) {
                    shape = shape.getContainer();
                }
                if (list.contains(shape) || shape == groupShape) continue;
                list.add(shape);
            }
        }
        return list;
    }

    public static boolean isGroupShape(PictogramElement shape) {
        return BusinessObjectUtil.getFirstBaseElement(shape) instanceof Group;
    }

    public static List<EObject> findMessageReferences(Diagram diagram, Message message) {
        EObject o;
        ArrayList<EObject> result = new ArrayList<EObject>();
        Definitions definitions = ModelUtil.getDefinitions(message);
        TreeIterator iter = definitions.eAllContents();
        while (iter.hasNext()) {
            o = (EObject)iter.next();
            if (o instanceof MessageFlow && ((MessageFlow)o).getMessageRef() == message) {
                result.add(o);
            }
            if (o instanceof MessageEventDefinition && ((MessageEventDefinition)o).getMessageRef() == message) {
                result.add(o);
            }
            if (o instanceof Operation && (((Operation)o).getInMessageRef() == message || ((Operation)o).getOutMessageRef() == message)) {
                result.add(o);
            }
            if (o instanceof ReceiveTask && ((ReceiveTask)o).getMessageRef() == message) {
                result.add(o);
            }
            if (o instanceof SendTask && ((SendTask)o).getMessageRef() == message) {
                result.add(o);
            }
            if (!(o instanceof CorrelationPropertyRetrievalExpression) || ((CorrelationPropertyRetrievalExpression)o).getMessageRef() != message) continue;
            result.add(o);
        }
        if (diagram != null) {
            iter = diagram.eResource().getAllContents();
            while (iter.hasNext()) {
                o = (EObject)iter.next();
                if (!(o instanceof ContainerShape) || FeatureSupport.isLabelShape((PictogramElement)((ContainerShape)o)) || BusinessObjectUtil.getFirstBaseElement((PictogramElement)((ContainerShape)o)) != message) continue;
                result.add(o);
            }
        }
        return result;
    }

    public static List<EClass> getAllowedEventDefinitions(Event event, Object parentContainer) {
        BaseElement eventOwner = null;
        if (parentContainer instanceof BaseElement) {
            eventOwner = (BaseElement)parentContainer;
        }
        if (event instanceof BoundaryEvent && ((BoundaryEvent)event).getAttachedToRef() != null) {
            eventOwner = ((BoundaryEvent)event).getAttachedToRef();
        } else {
            EObject parent = event.eContainer();
            while (parent != null) {
                if (parent instanceof FlowElementsContainer) {
                    eventOwner = (BaseElement)parent;
                    break;
                }
                parent = parent.eContainer();
            }
        }
        ArrayList<EClass> allowedItems = new ArrayList<EClass>();
        if (event instanceof BoundaryEvent) {
            if (eventOwner instanceof Transaction) {
                allowedItems.add(Bpmn2Package.eINSTANCE.getCancelEventDefinition());
            }
            allowedItems.add(Bpmn2Package.eINSTANCE.getCompensateEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getConditionalEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getErrorEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getEscalationEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getMessageEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getSignalEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getTimerEventDefinition());
        } else if (event instanceof IntermediateCatchEvent) {
            allowedItems.add(Bpmn2Package.eINSTANCE.getConditionalEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getLinkEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getMessageEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getSignalEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getTimerEventDefinition());
        } else if (event instanceof StartEvent) {
            if (eventOwner instanceof SubProcess) {
                allowedItems.add(Bpmn2Package.eINSTANCE.getCompensateEventDefinition());
                allowedItems.add(Bpmn2Package.eINSTANCE.getErrorEventDefinition());
                allowedItems.add(Bpmn2Package.eINSTANCE.getEscalationEventDefinition());
            }
            allowedItems.add(Bpmn2Package.eINSTANCE.getConditionalEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getMessageEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getSignalEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getTimerEventDefinition());
        } else if (event instanceof EndEvent) {
            if (eventOwner instanceof Transaction) {
                allowedItems.add(Bpmn2Package.eINSTANCE.getCancelEventDefinition());
            }
            allowedItems.add(Bpmn2Package.eINSTANCE.getCompensateEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getErrorEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getEscalationEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getMessageEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getSignalEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getTerminateEventDefinition());
        } else if (event instanceof ImplicitThrowEvent) {
            allowedItems.add(Bpmn2Package.eINSTANCE.getCompensateEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getEscalationEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getLinkEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getMessageEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getSignalEventDefinition());
        } else if (event instanceof IntermediateThrowEvent) {
            allowedItems.add(Bpmn2Package.eINSTANCE.getCompensateEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getEscalationEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getLinkEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getMessageEventDefinition());
            allowedItems.add(Bpmn2Package.eINSTANCE.getSignalEventDefinition());
        }
        return allowedItems;
    }

    public static boolean updateConnection(IFeatureProvider fp, Connection connection) {
        boolean layoutChanged = false;
        LayoutContext layoutContext = new LayoutContext((PictogramElement)connection);
        ILayoutFeature layoutFeature = fp.getLayoutFeature((ILayoutContext)layoutContext);
        if (layoutFeature != null) {
            layoutFeature.layout((ILayoutContext)layoutContext);
            layoutChanged = layoutFeature.hasDoneChanges();
        }
        boolean updateChanged = false;
        UpdateContext updateContext = new UpdateContext((PictogramElement)connection);
        IUpdateFeature updateFeature = fp.getUpdateFeature((IUpdateContext)updateContext);
        if (updateFeature != null && updateFeature.updateNeeded((IUpdateContext)updateContext).toBoolean()) {
            updateFeature.update((IUpdateContext)updateContext);
            updateChanged = updateFeature.hasDoneChanges();
        }
        if (layoutChanged) {
            FeatureSupport.updateLabel(fp, (PictogramElement)connection, null);
        }
        return layoutChanged || updateChanged;
    }

    public static boolean updateConnection(IFeatureProvider fp, Connection connection, boolean force) {
        AbstractConnectionRouter.setForceRouting(connection, force);
        return FeatureSupport.updateConnection(fp, connection);
    }

    public static void updateConnections(IFeatureProvider fp, AnchorContainer ac, List<Connection> alreadyUpdated) {
        Connection c;
        int ci;
        Anchor a;
        int ai = 0;
        while (ai < ac.getAnchors().size()) {
            a = (Anchor)ac.getAnchors().get(ai);
            ci = 0;
            while (ci < a.getIncomingConnections().size()) {
                c = (Connection)a.getIncomingConnections().get(ci);
                if (c instanceof FreeFormConnection && !alreadyUpdated.contains(c)) {
                    FeatureSupport.updateConnection(fp, c, true);
                    alreadyUpdated.add(c);
                }
                ++ci;
            }
            ++ai;
        }
        ai = 0;
        while (ai < ac.getAnchors().size()) {
            a = (Anchor)ac.getAnchors().get(ai);
            ci = 0;
            while (ci < a.getOutgoingConnections().size()) {
                c = (Connection)a.getOutgoingConnections().get(ci);
                if (c instanceof FreeFormConnection && !alreadyUpdated.contains(c)) {
                    FeatureSupport.updateConnection(fp, c, true);
                    alreadyUpdated.add(c);
                }
                ++ci;
            }
            ++ai;
        }
    }

    public static void updateConnections(IFeatureProvider fp, AnchorContainer ac) {
        ArrayList<Connection> alreadyUpdated = new ArrayList<Connection>();
        if (ac instanceof ContainerShape) {
            for (Shape child : ((ContainerShape)ac).getChildren()) {
                if (!(child instanceof ContainerShape)) continue;
                FeatureSupport.updateConnections(fp, (AnchorContainer)child, alreadyUpdated);
            }
        }
        FeatureSupport.updateConnections(fp, ac, alreadyUpdated);
    }

    public static void updateCategoryValues(IFeatureProvider fp, List<ContainerShape> shapes) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (ContainerShape cs : shapes) {
            FeatureSupport.updateCategoryValues(fp, (PictogramElement)cs);
            for (Anchor a : cs.getAnchors()) {
                for (Connection c : a.getIncomingConnections()) {
                    if (connections.contains(c)) continue;
                    connections.add(c);
                }
                for (Connection c : a.getOutgoingConnections()) {
                    if (connections.contains(c)) continue;
                    connections.add(c);
                }
            }
        }
        for (Connection c : connections) {
            FeatureSupport.updateCategoryValues(fp, (PictogramElement)c);
        }
    }

    public static void updateCategoryValues(IFeatureProvider fp, PictogramElement pe) {
        Resource resource = ObjectPropertyProvider.getResource((EObject)pe);
        if (Bpmn2Preferences.getInstance(resource).getPropagateGroupCategories()) {
            Diagram diagram = fp.getDiagramTypeProvider().getDiagram();
            FlowElement flowElement = BusinessObjectUtil.getFirstElementOfType(pe, FlowElement.class);
            if (flowElement == null) {
                return;
            }
            flowElement.getCategoryValueRef().clear();
            if (pe instanceof ContainerShape) {
                for (Group group : ModelUtil.getAllObjectsOfType(resource, Group.class)) {
                    CategoryValue cv = group.getCategoryValueRef();
                    if (cv == null) continue;
                    block1: for (PictogramElement groupShape : Graphiti.getLinkService().getPictogramElements(diagram, (EObject)group)) {
                        if (!(groupShape instanceof ContainerShape)) continue;
                        for (ContainerShape flowElementShape : FeatureSupport.findGroupedShapes((ContainerShape)groupShape)) {
                            FlowElement fe = BusinessObjectUtil.getFirstElementOfType((PictogramElement)flowElementShape, FlowElement.class);
                            if (fe != flowElement) continue;
                            fe.getCategoryValueRef().add(cv);
                            continue block1;
                        }
                    }
                }
            } else if (pe instanceof Connection && flowElement instanceof SequenceFlow) {
                SequenceFlow sf = (SequenceFlow)flowElement;
                FlowNode source = sf.getSourceRef();
                FlowNode target = sf.getTargetRef();
                sf.getCategoryValueRef().clear();
                sf.getCategoryValueRef().addAll(source.getCategoryValueRef());
                sf.getCategoryValueRef().addAll(target.getCategoryValueRef());
            }
        }
    }

    public static void setToolTip(GraphicsAlgorithm ga, String text) {
        if (ga != null) {
            Property prop = MmFactory.eINSTANCE.createProperty();
            prop.setKey("tooltip");
            prop.setValue(text);
            ga.getProperties().add((Object)prop);
        }
    }

    public static String getToolTip(GraphicsAlgorithm ga) {
        if (ga != null) {
            for (Property prop : ga.getProperties()) {
                if (!"tooltip".equals(prop.getKey())) continue;
                return prop.getValue();
            }
        }
        return null;
    }

    public static boolean hasBPMNShape(PictogramElement pe) {
        return BusinessObjectUtil.getFirstElementOfType(pe, BPMNShape.class) != null;
    }

    public static boolean hasBPMNEdge(PictogramElement pe) {
        return BusinessObjectUtil.getFirstElementOfType(pe, BPMNEdge.class) != null;
    }

    public static boolean hasBPMNElement(PictogramElement pe) {
        return FeatureSupport.hasBPMNShape(pe) || FeatureSupport.hasBPMNEdge(pe);
    }

    public static PictogramElement getPictogramElement(IContext context) {
        PictogramElement[] pes;
        if (context instanceof IPictogramElementContext) {
            return ((IPictogramElementContext)context).getPictogramElement();
        }
        if (context instanceof ICustomContext && (pes = ((ICustomContext)context).getPictogramElements()).length == 1) {
            return pes[0];
        }
        return null;
    }

    public static boolean isLabelShape(PictogramElement shape) {
        if (shape == null) {
            return false;
        }
        return Graphiti.getPeService().getPropertyValue((PropertyContainer)shape, "label.shape") != null;
    }

    public static boolean isHidden(PictogramElement pe) {
        return Graphiti.getPeService().getPropertyValue((PropertyContainer)pe, "hidden") != null;
    }

    public static boolean setHidden(PictogramElement pe, boolean hidden) {
        if (hidden) {
            pe.eSetDeliver(false);
            Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, "hidden", Boolean.TRUE.toString());
            pe.setVisible(false);
            pe.eSetDeliver(true);
        } else {
            pe.eSetDeliver(false);
            Graphiti.getPeService().removeProperty((PropertyContainer)pe, "hidden");
            pe.setVisible(true);
            pe.eSetDeliver(true);
        }
        return false;
    }

    public static PictogramElement getLabelOwner(IContext context) {
        List pes = (List)context.getProperty((Object)"pictogram.elements");
        if (pes != null && pes.size() > 0) {
            return FeatureSupport.getLabelOwner((PictogramElement)pes.get(pes.size() - 1));
        }
        PictogramElement pe = (PictogramElement)context.getProperty((Object)"pictogram.element");
        if (pe != null) {
            return pe;
        }
        if (context instanceof IPictogramElementContext) {
            return FeatureSupport.getLabelOwner(((IPictogramElementContext)context).getPictogramElement());
        }
        return null;
    }

    public static PictogramElement getLabelOwner(PictogramElement pe) {
        Shape labelShape;
        DiagramElement de = BusinessObjectUtil.getFirstElementOfType(pe, DiagramElement.class);
        if (de != null) {
            return pe;
        }
        ContainerShape cs = BusinessObjectUtil.getFirstElementOfType(pe, ContainerShape.class);
        de = BusinessObjectUtil.getFirstElementOfType((PictogramElement)cs, DiagramElement.class);
        if (de != null) {
            return cs;
        }
        Message msg = BusinessObjectUtil.getFirstElementOfType((PictogramElement)cs, Message.class);
        if (msg != null) {
            return cs;
        }
        if (pe instanceof ContainerShape && FeatureSupport.isLabelShape((PictogramElement)(labelShape = BusinessObjectUtil.getFirstElementOfType(pe, Shape.class)))) {
            return pe;
        }
        Connection c = BusinessObjectUtil.getFirstElementOfType(pe, Connection.class);
        de = BusinessObjectUtil.getFirstElementOfType((PictogramElement)c, DiagramElement.class);
        if (de != null) {
            return c;
        }
        return null;
    }

    public static PictogramElement getLabelOwner(GraphicsAlgorithm text) {
        PictogramElement pe = text.getPictogramElement();
        if (FeatureSupport.isLabelShape(pe)) {
            return FeatureSupport.getLabelOwner(pe);
        }
        return null;
    }

    public static Shape getLabelShape(PictogramElement pe) {
        Shape cs;
        if ((pe = FeatureSupport.getLabelOwner(pe)) instanceof Connection) {
            for (ConnectionDecorator d : ((Connection)pe).getConnectionDecorators()) {
                if (!FeatureSupport.isLabelShape((PictogramElement)d)) continue;
                return d;
            }
        }
        if (FeatureSupport.isLabelShape((PictogramElement)(cs = BusinessObjectUtil.getFirstElementOfType(pe, Shape.class)))) {
            return cs;
        }
        return null;
    }

    public static void updateLabel(IFeatureProvider fp, PictogramElement pe, Point offset) {
        if (FeatureSupport.isLabelShape(pe)) {
            pe = FeatureSupport.getLabelOwner(pe);
        }
        if (pe != null) {
            UpdateContext context = new UpdateContext(pe);
            context.putProperty((Object)"label.offset", (Object)offset);
            IUpdateFeature feature = fp.getUpdateFeature((IUpdateContext)context);
            if (feature instanceof MultiUpdateFeature) {
                MultiUpdateFeature mf = (MultiUpdateFeature)feature;
                for (IUpdateFeature uf : mf.getFeatures()) {
                    if (!(uf instanceof UpdateLabelFeature)) continue;
                    uf.update((IUpdateContext)context);
                }
            } else if (feature != null) {
                feature.update((IUpdateContext)context);
            }
        }
    }

    public static ShapeStyle.LabelPosition getLabelPosition(PictogramElement pe) {
        BaseElement element = BusinessObjectUtil.getFirstBaseElement(pe);
        if (element != null) {
            ShapeStyle ss = ShapeStyle.getShapeStyle(element);
            return ss.getLabelPosition();
        }
        return ShapeStyle.LabelPosition.BOTTOM;
    }

    public static Tuple<List<ContainerShape>, List<ContainerShape>> getTopAndBottomBands(List<ContainerShape> bandShapes) {
        ArrayList<ContainerShape> top = new ArrayList<ContainerShape>();
        ArrayList<ContainerShape> bottom = new ArrayList<ContainerShape>();
        if (bandShapes.size() == 1) {
            BPMNShape bpmnShape = BusinessObjectUtil.getFirstElementOfType((PictogramElement)bandShapes.get(0), BPMNShape.class);
            ParticipantBandKind bandKind = bpmnShape.getParticipantBandKind();
            if (bandKind == ParticipantBandKind.TOP_INITIATING || bandKind == ParticipantBandKind.TOP_NON_INITIATING) {
                top.add(bandShapes.get(0));
            } else if (bandKind == ParticipantBandKind.BOTTOM_INITIATING || bandKind == ParticipantBandKind.BOTTOM_NON_INITIATING) {
                bottom.add(bandShapes.get(0));
            } else {
                top.add(bandShapes.get(0));
            }
        } else {
            Collections.sort(bandShapes, new Comparator<ContainerShape>(){

                @Override
                public int compare(ContainerShape c1, ContainerShape c2) {
                    BPMNShape bpmnShape1 = BusinessObjectUtil.getFirstElementOfType((PictogramElement)c1, BPMNShape.class);
                    Bounds bounds1 = bpmnShape1.getBounds();
                    BPMNShape bpmnShape2 = BusinessObjectUtil.getFirstElementOfType((PictogramElement)c2, BPMNShape.class);
                    Bounds bounds2 = bpmnShape2.getBounds();
                    return new Float(bounds1.getY()).compareTo(new Float(bounds2.getY()));
                }
            });
            int n = bandShapes.size();
            int divider = n / 2;
            top.addAll(bandShapes.subList(0, divider));
            bottom.addAll(bandShapes.subList(divider, n));
        }
        return new Tuple<List<ContainerShape>, List<ContainerShape>>(top, bottom);
    }

    public static List<ContainerShape> getParticipantBandContainerShapes(ContainerShape containerShape) {
        IPeService peService = Graphiti.getPeService();
        ArrayList<ContainerShape> bandShapes = new ArrayList<ContainerShape>();
        Collection shapes = peService.getAllContainedShapes(containerShape);
        for (Shape s : shapes) {
            String property = peService.getPropertyValue((PropertyContainer)s, "choreography.activity.band");
            if (!new Boolean(property).booleanValue()) continue;
            bandShapes.add((ContainerShape)s);
        }
        return bandShapes;
    }

    public static boolean isElementExpanded(PictogramElement pe) {
        String property = Graphiti.getPeService().getPropertyValue((PropertyContainer)pe, "is.expanded");
        return Boolean.parseBoolean(property);
    }

    public static void setElementExpanded(PictogramElement pe, boolean isExpanded) {
        if (isExpanded) {
            Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, "is.expanded", Boolean.TRUE.toString());
        } else {
            Graphiti.getPeService().removeProperty((PropertyContainer)pe, "is.expanded");
        }
    }

    public static boolean isElementExpanded(BaseElement be) {
        if (FeatureSupport.isExpandableElement(be)) {
            BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram(be);
            BPMNShape bpmnShape = DIUtils.findBPMNShape(be);
            if (bpmnShape != null && bpmnShape.isIsExpanded() && bpmnDiagram == null) {
                return true;
            }
        }
        return false;
    }

    public static boolean isExpandableElement(BaseElement be) {
        return be instanceof SubProcess || be instanceof AdHocSubProcess || be instanceof Transaction || be instanceof CallActivity || be instanceof CallChoreography;
    }

    public static void updateExpandedSize(PictogramElement pe) {
        IDimension size = GraphicsUtil.calculateSize(pe);
        FeatureSupport.setExpandedSize(pe, size);
    }

    public static void setExpandedSize(PictogramElement pe, IDimension size) {
        FeatureSupport.setExpandedSize(pe, size.getWidth(), size.getHeight());
    }

    public static void setExpandedSize(PictogramElement pe, int width, int height) {
        Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, "expanded.size", String.valueOf(width) + "," + height);
    }

    public static IDimension getExpandedSize(PictogramElement pe) {
        IDimension size = GraphicsUtil.calculateSize(pe);
        String property = Graphiti.getPeService().getPropertyValue((PropertyContainer)pe, "expanded.size");
        if (property != null) {
            int index = property.indexOf(44);
            int w = Integer.parseInt(property.substring(0, index));
            int h = Integer.parseInt(property.substring(index + 1));
            size.setWidth(w);
            size.setHeight(h);
        }
        return size;
    }

    public static void updateCollapsedSize(PictogramElement pe) {
        IDimension size = GraphicsUtil.calculateSize(pe);
        FeatureSupport.setCollapsedSize(pe, size);
    }

    public static void setCollapsedSize(PictogramElement pe, IDimension size) {
        FeatureSupport.setCollapsedSize(pe, size.getWidth(), size.getHeight());
    }

    public static void setCollapsedSize(PictogramElement pe, int width, int height) {
        Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, "collapsed.size", String.valueOf(width) + "," + height);
    }

    public static IDimension getCollapsedSize(PictogramElement pe) {
        IDimension size = GraphicsUtil.calculateSize(pe);
        String property = Graphiti.getPeService().getPropertyValue((PropertyContainer)pe, "collapsed.size");
        if (property != null) {
            int index = property.indexOf(44);
            int w = Integer.parseInt(property.substring(0, index));
            int h = Integer.parseInt(property.substring(index + 1));
            size.setWidth(w);
            size.setHeight(h);
        }
        return size;
    }
}

