/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.StyleContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.AbstractStyle;
import org.eclipse.graphiti.mm.algorithms.styles.AdaptedGradientColoredAreas;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.GradientColoredArea;
import org.eclipse.graphiti.mm.algorithms.styles.GradientColoredAreas;
import org.eclipse.graphiti.mm.algorithms.styles.LocationType;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.algorithms.styles.StylesFactory;
import org.eclipse.graphiti.mm.algorithms.styles.StylesPackage;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.graphiti.util.IGradientType;

public class StyleUtil {
    private static final String CLASS_ID = "E-CLASS";
    private static final String FILL_STYLE = "fill.style";
    private static final IGaService gaService = Graphiti.getGaService();
    private static final IPeService peService = Graphiti.getPeService();
    public static final IColorConstant CLASS_FOREGROUND = new ColorConstant(116, 143, 165);
    public static final IColorConstant CLASS_BACKGROUND = new ColorConstant(220, 233, 255);

    public static Style getStyleForClass(Diagram diagram) {
        Style s = StyleUtil.findStyle((StyleContainer)diagram, CLASS_ID);
        if (s == null) {
            s = gaService.createStyle((StyleContainer)diagram, CLASS_ID);
            s.setForeground(gaService.manageColor(diagram, CLASS_FOREGROUND));
            s.setBackground(gaService.manageColor(diagram, CLASS_BACKGROUND));
            s.setLineWidth(Integer.valueOf(1));
        }
        return s;
    }

    private static Style findStyle(StyleContainer container, String id) {
        if (container.getStyles() != null) {
            for (Style s : container.getStyles()) {
                if (!s.getId().equals(id)) continue;
                return s;
            }
        }
        return null;
    }

    public static Diagram findDiagram(GraphicsAlgorithm ga) {
        EObject container = ga.eContainer();
        while (container != null && !(container instanceof Diagram)) {
            container = container.eContainer();
        }
        return (Diagram)container;
    }

    public static void setFillStyle(GraphicsAlgorithm ga, FillStyle fillStyle) {
        peService.setPropertyValue((PropertyContainer)ga, FILL_STYLE, fillStyle.toString());
    }

    public static GraphicsAlgorithm getShapeStyleContainer(PictogramElement pe) {
        TreeIterator childIter = pe.eAllContents();
        while (childIter.hasNext()) {
            GraphicsAlgorithm ga;
            EObject o = (EObject)childIter.next();
            if (!(o instanceof GraphicsAlgorithm) || peService.getPropertyValue((PropertyContainer)(ga = (GraphicsAlgorithm)o), "shape.style") == null) continue;
            return ga;
        }
        return null;
    }

    public static void applyStyle(GraphicsAlgorithm ga, BaseElement be) {
        StyleUtil.applyStyle(ga, be, null);
    }

    public static void applyStyle(GraphicsAlgorithm ga, BaseElement be, ShapeStyle ss) {
        if (be != null) {
            Diagram diagram = StyleUtil.findDiagram(ga);
            if (ss == null) {
                ss = ShapeStyle.getShapeStyle(be);
            }
            IColorConstant foreground = ga instanceof AbstractText ? ss.getLabelForeground() : ss.getShapeForeground();
            IColorConstant background = ss.getShapeBackground();
            peService.setPropertyValue((PropertyContainer)ga, "shape.style", Boolean.TRUE.toString());
            if (BusinessObjectUtil.isConnection(be.eClass().getInstanceClass())) {
                ga.setForeground(gaService.manageColor(diagram, foreground));
                if (ga instanceof AbstractText) {
                    Font f = ss.getLabelFont();
                    ((AbstractText)ga).setFont(gaService.manageFont(diagram, f.getName(), f.getSize(), f.isItalic(), f.isBold()));
                } else if (ga.eContainer() instanceof ConnectionDecorator) {
                    ga.setBackground(gaService.manageColor(diagram, foreground));
                } else if (ga.eContainer() instanceof Connection) {
                    ga.setLineWidth(Integer.valueOf(ss.getDefaultWidth()));
                    Connection c = (Connection)ga.eContainer();
                    for (ConnectionDecorator cd : c.getConnectionDecorators()) {
                        if (FeatureSupport.isLabelShape((PictogramElement)cd)) continue;
                        cd.getGraphicsAlgorithm().setForeground(gaService.manageColor(diagram, foreground));
                        cd.getGraphicsAlgorithm().setBackground(gaService.manageColor(diagram, foreground));
                    }
                }
            } else {
                String id = ss.toString();
                Style s = StyleUtil.findStyle((StyleContainer)diagram, id);
                if (s == null) {
                    s = gaService.createStyle((StyleContainer)diagram, id);
                }
                if (ga instanceof AbstractText) {
                    Font f = ss.getLabelFont();
                    ((AbstractText)ga).setFont(gaService.manageFont(diagram, f.getName(), f.getSize(), f.isItalic(), f.isBold()));
                    ga.setForeground(gaService.manageColor(diagram, foreground));
                    return;
                }
                s.setForeground(gaService.manageColor(diagram, foreground));
                ga.setForeground(gaService.manageColor(diagram, foreground));
                String fillStyle = peService.getPropertyValue((PropertyContainer)ga, FILL_STYLE);
                if (fillStyle == null || fillStyle.equals(FillStyle.FILL_STYLE_DEFAULT.name())) {
                    ga.setFilled(Boolean.valueOf(true));
                    s.setFilled(Boolean.valueOf(true));
                    AdaptedGradientColoredAreas gradient = StyleUtil.getStyleAdaptations(ss, id);
                    gaService.setRenderingStyle((AbstractStyle)s, gradient);
                    ga.setStyle(s);
                } else if (fillStyle.equals(FillStyle.FILL_STYLE_FOREGROUND.name())) {
                    ga.setFilled(Boolean.valueOf(true));
                    ga.setBackground(gaService.manageColor(diagram, foreground));
                } else if (fillStyle.equals(FillStyle.FILL_STYLE_BACKGROUND.name())) {
                    ga.setFilled(Boolean.valueOf(true));
                    ga.setBackground(gaService.manageColor(diagram, background));
                } else if (fillStyle.equals(FillStyle.FILL_STYLE_INVERT.name())) {
                    ga.setFilled(Boolean.valueOf(true));
                    ga.setForeground(gaService.manageColor(diagram, background));
                    ga.setBackground(gaService.manageColor(diagram, foreground));
                } else {
                    ga.setFilled(Boolean.valueOf(false));
                    ga.setBackground(gaService.manageColor(diagram, background));
                }
            }
        }
    }

    public static AdaptedGradientColoredAreas getStyleAdaptions(BaseElement be) {
        Bpmn2Preferences pref = Bpmn2Preferences.getInstance((EObject)be);
        return StyleUtil.getStyleAdaptations(pref.getShapeStyle((EObject)be), pref.getShapeStyleId((EObject)be));
    }

    public static AdaptedGradientColoredAreas getStyleAdaptations(ShapeStyle ss, String id) {
        AdaptedGradientColoredAreas agca = StylesFactory.eINSTANCE.createAdaptedGradientColoredAreas();
        agca.setDefinedStyleId(id);
        agca.setGradientType(IGradientType.VERTICAL);
        agca.getAdaptedGradientColoredAreas().add(0, (Object)StyleUtil.getPreferenceDefaultAreas(ss));
        agca.getAdaptedGradientColoredAreas().add(1, (Object)StyleUtil.getPreferencePrimarySelectedAreas(ss));
        agca.getAdaptedGradientColoredAreas().add(2, (Object)StyleUtil.getPreferenceSecondarySelectedAreas(ss));
        return agca;
    }

    public static IColorConstant shiftColor(IColorConstant c, int amount) {
        int r = c.getRed() + amount;
        int g = c.getGreen() + amount;
        int b = c.getBlue() + amount;
        if (r > 255) {
            r = 255;
        }
        if (r < 0) {
            r = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (b > 255) {
            b = 255;
        }
        if (b < 0) {
            b = 0;
        }
        return new ColorConstant(r, g, b);
    }

    private static GradientColoredAreas getPreferenceDefaultAreas(ShapeStyle ss) {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(0));
        EList gcas = gradientColoredAreas.getGradientColor();
        IColorConstant c1 = StyleUtil.shiftColor(ss.getShapeBackground(), -8);
        IColorConstant c2 = StyleUtil.shiftColor(ss.getShapeBackground(), 64);
        StyleUtil.addGradientColoredArea((EList<GradientColoredArea>)gcas, c1, 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, c2, 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    private static GradientColoredAreas getPreferencePrimarySelectedAreas(ShapeStyle ss) {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(1));
        EList gcas = gradientColoredAreas.getGradientColor();
        IColorConstant c1 = StyleUtil.shiftColor(ss.getShapePrimarySelectedColor(), -64);
        IColorConstant c2 = StyleUtil.shiftColor(ss.getShapePrimarySelectedColor(), 64);
        StyleUtil.addGradientColoredArea((EList<GradientColoredArea>)gcas, c1, 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, c2, 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    private static GradientColoredAreas getPreferenceSecondarySelectedAreas(ShapeStyle ss) {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(2));
        EList gcas = gradientColoredAreas.getGradientColor();
        IColorConstant c1 = StyleUtil.shiftColor(ss.getShapeSecondarySelectedColor(), -64);
        IColorConstant c2 = StyleUtil.shiftColor(ss.getShapeSecondarySelectedColor(), 64);
        StyleUtil.addGradientColoredArea((EList<GradientColoredArea>)gcas, c1, 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, c2, 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    private static void addGradientColoredArea(EList<GradientColoredArea> gcas, IColorConstant colorStart, int locationValueStart, LocationType locationTypeStart, IColorConstant colorEnd, int locationValueEnd, LocationType locationTypeEnd) {
        GradientColoredArea gca = StylesFactory.eINSTANCE.createGradientColoredArea();
        gcas.add((Object)gca);
        gca.setStart(StylesFactory.eINSTANCE.createGradientColoredLocation());
        gca.getStart().setColor(StylesFactory.eINSTANCE.createColor());
        gca.getStart().getColor().eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Blue(), (Object)colorStart.getBlue());
        gca.getStart().getColor().eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Green(), (Object)colorStart.getGreen());
        gca.getStart().getColor().eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Red(), (Object)colorStart.getRed());
        gca.getStart().setLocationType(locationTypeStart);
        gca.getStart().setLocationValue(Integer.valueOf(locationValueStart));
        gca.setEnd(StylesFactory.eINSTANCE.createGradientColoredLocation());
        gca.getEnd().setColor(StylesFactory.eINSTANCE.createColor());
        gca.getEnd().getColor().eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Blue(), (Object)colorEnd.getBlue());
        gca.getEnd().getColor().eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Green(), (Object)colorEnd.getGreen());
        gca.getEnd().getColor().eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Red(), (Object)colorEnd.getRed());
        gca.getEnd().setLocationType(locationTypeEnd);
        gca.getEnd().setLocationValue(Integer.valueOf(locationValueEnd));
    }

    public static enum FillStyle {
        FILL_STYLE_NONE,
        FILL_STYLE_FOREGROUND,
        FILL_STYLE_BACKGROUND,
        FILL_STYLE_DEFAULT,
        FILL_STYLE_INVERT;

    }
}

