/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.validation.StatusList;
import org.eclipse.bpmn2.modeler.core.validation.validators.AbstractBpmn2ElementValidator;
import org.eclipse.bpmn2.modeler.core.validation.validators.IBpmn2ElementValidator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public class BPMN2ValidationConstraints
extends AbstractModelConstraint {
    public static final String CATEGORY_ID = "org.eclipse.bpmn2.modeler.core.validation.category.override";
    protected StatusList result = new StatusList();

    public IStatus validate(IValidationContext ctx) {
        this.initialize();
        EObject object = ctx.getTarget();
        if (this.doValidation(ctx, object)) {
            ArrayList<EClass> types = new ArrayList<EClass>();
            types.addAll((Collection<EClass>)object.eClass().getEAllSuperTypes());
            types.add(object.eClass());
            Collections.reverse(types);
            IBpmn2ElementValidator<?> baseValidator = null;
            IBpmn2ElementValidator<?> validator = null;
            for (EClass eClass : types) {
                validator = baseValidator != null ? this.getValidator(baseValidator, eClass) : this.getValidator(ctx, eClass);
                if (validator == null) continue;
                if (baseValidator == null) {
                    baseValidator = validator;
                    if (this.isLiveValidation(ctx) && !validator.doLiveValidation()) continue;
                    this.addStatus(validator.validate(object));
                    continue;
                }
                if (!baseValidator.checkSuperType(eClass, object) || this.isLiveValidation(ctx) && !validator.doLiveValidation()) continue;
                this.addStatus(validator.validate(object));
            }
        }
        return this.getResult(ctx);
    }

    protected void initialize() {
        this.result.clear();
    }

    protected boolean doValidation(IValidationContext ctx, EObject object) {
        Bpmn2Preferences prefs = Bpmn2Preferences.getInstance(object);
        return prefs.getDoCoreValidation() && !this.deferValidationToTargetRuntime(ctx, object);
    }

    protected IBpmn2ElementValidator<?> getValidator(IValidationContext ctx, EClass eClass) {
        return AbstractBpmn2ElementValidator.getValidator(ctx, eClass.getInstanceClass());
    }

    protected IBpmn2ElementValidator<?> getValidator(IBpmn2ElementValidator<?> parent, EClass eClass) {
        return AbstractBpmn2ElementValidator.getValidator(parent, eClass.getInstanceClass());
    }

    protected void addStatus(IStatus status) {
        this.result.add(status);
    }

    protected IStatus getResult(IValidationContext ctx) {
        if (this.result.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        if (this.result.size() == 1) {
            return (IStatus)this.result.get(0);
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, (Collection)this.result);
    }

    protected boolean isLiveValidation(IValidationContext ctx) {
        return ctx.getEventType() != EMFEventType.NULL;
    }

    private boolean deferValidationToTargetRuntime(IValidationContext ctx, EObject object) {
        TargetRuntime rt = TargetRuntime.getCurrentRuntime();
        if (rt != TargetRuntime.getDefaultRuntime()) {
            IConfigurationElement[] elements;
            ClassLoader cl = rt.getRuntimeExtension().getClass().getClassLoader();
            Bundle b = ((BundleReference)cl).getBundle();
            String pluginId = b.getSymbolicName();
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.validation.constraintProviders");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                if (pluginId.equals(e.getDeclaringExtension().getContributor().getName()) && "constraintProvider".equals(e.getName())) {
                    IConfigurationElement[] iConfigurationElementArray2 = e.getChildren("constraints");
                    int n3 = iConfigurationElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement e1 = iConfigurationElementArray2[n4];
                        String categories = e1.getAttribute("categories");
                        if (categories != null && categories.contains(CATEGORY_ID)) {
                            IConfigurationElement[] iConfigurationElementArray3 = e1.getChildren("constraint");
                            int n5 = iConfigurationElementArray3.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IConfigurationElement e2 = iConfigurationElementArray3[n6];
                                IConfigurationElement[] iConfigurationElementArray4 = e2.getChildren("target");
                                int n7 = iConfigurationElementArray4.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    IConfigurationElement e3 = iConfigurationElementArray4[n8];
                                    String className = e3.getAttribute("class");
                                    int i = className.indexOf(58);
                                    if (i > 0) {
                                        className = className.substring(0, i);
                                    }
                                    if (object.eClass().getName().equals(className)) {
                                        String mode = this.isLiveValidation(ctx) ? "Live" : "Batch";
                                        String m = e2.getAttribute("mode");
                                        if (m == null) {
                                            m = "Batch";
                                        }
                                        if (mode.equals(m)) {
                                            return true;
                                        }
                                    }
                                    ++n8;
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return false;
    }
}

