/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import java.util.Hashtable;
import java.util.Stack;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.ItemKind;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.FeatureDescriptor;
import org.eclipse.bpmn2.modeler.core.utils.EventDefinitionsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ImportUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.ItemDefinitionPropertiesAdapter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class ItemDefinitionRefFeatureDescriptor<T extends BaseElement>
extends FeatureDescriptor<T> {
    protected ImportUtil importer = new ImportUtil();

    public ItemDefinitionRefFeatureDescriptor(ExtendedPropertiesAdapter<T> owner, T object, EStructuralFeature feature) {
        super(owner, object, feature);
        Assert.isTrue((boolean)RootElement.class.isAssignableFrom(feature.getEType().getInstanceClass()));
    }

    public String getLabel() {
        return ItemDefinitionPropertiesAdapter.getLabel();
    }

    public String getTextValue() {
        ItemDefinition itemDefinition = (ItemDefinition)((BaseElement)this.object).eGet(this.feature);
        return ItemDefinitionPropertiesAdapter.getDisplayName(itemDefinition);
    }

    public EObject createFeature(Resource resource, EClass eClass) {
        ItemDefinition itemDefinition = ItemDefinitionPropertiesAdapter.createItemDefinition(((BaseElement)this.object).eResource());
        return itemDefinition;
    }

    public Object getValue() {
        ItemDefinition itemDefinition = (ItemDefinition)((BaseElement)this.object).eGet(this.feature);
        return ItemDefinitionPropertiesAdapter.getStructureRef(itemDefinition);
    }

    protected void internalSet(T object, EStructuralFeature feature, Object value, int index) {
        Definitions definitions = ModelUtil.getDefinitions(object);
        if (value instanceof String) {
            value = this.importer.createItemDefinition(definitions, null, (String)value, ItemKind.INFORMATION);
        }
        if (value == null || value instanceof ItemDefinition) {
            ItemDefinition itemDefinition = (ItemDefinition)value;
            super.internalSet(object, feature, (Object)itemDefinition, index);
            if (definitions != null) {
                if (object instanceof ItemAwareElement) {
                    this.changeReferences((ItemAwareElement)object, itemDefinition);
                } else if (object instanceof RootElement) {
                    this.changeReferences((RootElement)object, itemDefinition);
                }
            }
        }
    }

    private void changeReferences(RootElement object, ItemDefinition itemDefinition) {
        for (EObject ed : ModelUtil.getAllReachableObjects((EObject)object, (EClass)Bpmn2Package.eINSTANCE.getEventDefinition())) {
            if (EventDefinitionsUtil.getEventDefinitionTarget((EventDefinition)((EventDefinition)ed)) != object) continue;
            Tuple param = EventDefinitionsUtil.getIOParameter((Event)((Event)ed.eContainer()), (EventDefinition)((EventDefinition)ed));
            this.changeReferences((ItemAwareElement)param.getFirst(), itemDefinition);
        }
    }

    private void changeReferences(ItemAwareElement object, ItemDefinition itemDefinition) {
        Definitions definitions = ModelUtil.getDefinitions((Object)object);
        Stack<ItemAwareElement> changedObjects = new Stack<ItemAwareElement>();
        changedObjects.push(object);
        while (!changedObjects.isEmpty()) {
            ItemDefinition id;
            EventDefinition ed;
            ItemAwareElement element = (ItemAwareElement)changedObjects.pop();
            if (element.eContainer() instanceof Event && (ed = EventDefinitionsUtil.getEventDefinition((ItemAwareElement)element)) != null && (id = EventDefinitionsUtil.getItemDefinition((EventDefinition)ed)) != itemDefinition) {
                EventDefinitionsUtil.setItemDefinition((EventDefinition)ed, (ItemDefinition)itemDefinition);
                RootElement re = EventDefinitionsUtil.getEventDefinitionTarget((EventDefinition)ed);
                this.changeReferences(re, itemDefinition);
            }
            if (element.getItemSubjectRef() != itemDefinition) {
                element.setItemSubjectRef(itemDefinition);
            }
            TreeIterator iter = definitions.eAllContents();
            while (iter.hasNext()) {
                DataInputAssociation da;
                EObject o = (EObject)iter.next();
                if (o instanceof DataInputAssociation) {
                    da = (DataInputAssociation)o;
                    if (da.getSourceRef().contains(element)) {
                        if (da.getTargetRef() == null || da.getTargetRef().getItemSubjectRef() == itemDefinition) continue;
                        da.getTargetRef().setItemSubjectRef(itemDefinition);
                        changedObjects.push(da.getTargetRef());
                        continue;
                    }
                    if (da.getTargetRef() != element) continue;
                    for (ItemAwareElement e : da.getSourceRef()) {
                        if (e.getItemSubjectRef() == itemDefinition) continue;
                        e.setItemSubjectRef(itemDefinition);
                        changedObjects.push(e);
                    }
                    continue;
                }
                if (!(o instanceof DataOutputAssociation)) continue;
                da = (DataOutputAssociation)o;
                if (da.getSourceRef().contains(element)) {
                    if (da.getTargetRef() == null || da.getTargetRef().getItemSubjectRef() == itemDefinition) continue;
                    da.getTargetRef().setItemSubjectRef(itemDefinition);
                    changedObjects.push(da.getTargetRef());
                    continue;
                }
                if (da.getTargetRef() != element) continue;
                for (ItemAwareElement e : da.getSourceRef()) {
                    if (e.getItemSubjectRef() == itemDefinition) continue;
                    e.setItemSubjectRef(itemDefinition);
                    changedObjects.push(e);
                }
            }
        }
    }

    public Hashtable<String, Object> getChoiceOfValues() {
        return ItemDefinitionPropertiesAdapter.getChoiceOfValues(this.object);
    }
}

