/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.ReceiveTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectDescriptor;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.RootElementRefFeatureDescriptor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class MessageFlowPropertiesAdapter
extends ExtendedPropertiesAdapter<MessageFlow> {
    public MessageFlowPropertiesAdapter(AdapterFactory adapterFactory, MessageFlow object) {
        super(adapterFactory, (EObject)object);
        EReference ref = Bpmn2Package.eINSTANCE.getMessageFlow_MessageRef();
        this.setFeatureDescriptor((EStructuralFeature)ref, new RootElementRefFeatureDescriptor<MessageFlow>((ExtendedPropertiesAdapter)this, object, (EStructuralFeature)ref){

            protected void internalSet(MessageFlow messageFlow, EStructuralFeature feature, Object value, int index) {
                if (value instanceof Message || value == null) {
                    Message message = (Message)value;
                    ResourceSet resourceSet = messageFlow.eResource().getResourceSet();
                    messageFlow.setMessageRef(message);
                    List connections = DIUtils.getConnections((ResourceSet)resourceSet, (BaseElement)messageFlow);
                    for (Connection connection : connections) {
                        ExtendedPropertiesAdapter adapter;
                        BaseElement source = BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection.getStart().getParent());
                        BaseElement target = BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection.getEnd().getParent());
                        if (source instanceof SendTask) {
                            adapter = ExtendedPropertiesAdapter.adapt((Object)source);
                            adapter.getFeatureDescriptor((EStructuralFeature)Bpmn2Package.eINSTANCE.getSendTask_MessageRef()).setValue((Object)message);
                        }
                        if (!(target instanceof ReceiveTask)) continue;
                        adapter = ExtendedPropertiesAdapter.adapt((Object)target);
                        adapter.getFeatureDescriptor((EStructuralFeature)Bpmn2Package.eINSTANCE.getReceiveTask_MessageRef()).setValue((Object)message);
                    }
                }
            }
        });
        this.setObjectDescriptor((ObjectDescriptor)new ObjectDescriptor<MessageFlow>((ExtendedPropertiesAdapter)this, object){

            public String getTextValue() {
                String text = "";
                if (((MessageFlow)this.object).getName() != null) {
                    text = ((MessageFlow)this.object).getName();
                } else {
                    if (((MessageFlow)this.object).getMessageRef() != null) {
                        text = String.valueOf(text) + ChoreographyUtil.getMessageFlowName((MessageFlow)((MessageFlow)this.object));
                    }
                    if (((MessageFlow)this.object).getSourceRef() != null) {
                        text = String.valueOf(text) + "(" + ExtendedPropertiesProvider.getTextValue((EObject)((MessageFlow)this.object).getSourceRef()) + "->";
                        if (((MessageFlow)this.object).getTargetRef() != null) {
                            text = String.valueOf(text) + ExtendedPropertiesProvider.getTextValue((EObject)((MessageFlow)this.object).getTargetRef());
                        }
                        text = String.valueOf(text) + ")";
                    }
                }
                return text;
            }
        });
    }
}

