/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import java.util.Comparator;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectDescriptor;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.model.RootElementComparator;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.RootElementRefFeatureDescriptor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class RootElementPropertiesAdapter<T extends RootElement>
extends ExtendedPropertiesAdapter<T> {
    public RootElementPropertiesAdapter(AdapterFactory adapterFactory, T object) {
        super(adapterFactory, object);
        EList list = object.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature ref : list) {
            EClassifier type = ref.getEType();
            if (!(type instanceof EClass)) continue;
            EList supertypes = ((EClass)type).getEAllSuperTypes();
            for (EClass st : supertypes) {
                if (st != Bpmn2Package.eINSTANCE.getRootElement()) continue;
                this.setFeatureDescriptor(ref, new RootElementRefFeatureDescriptor<T>(this, object, ref));
            }
        }
        this.setObjectDescriptor(new RootElementObjectDescriptor(this, (ExtendedPropertiesAdapter)this, object));
    }

    public static class RootElementObjectDescriptor<T extends RootElement>
    extends ObjectDescriptor<T> {
        final /* synthetic */ RootElementPropertiesAdapter this$0;

        public RootElementObjectDescriptor(ExtendedPropertiesAdapter<T> owner, T object) {
            this.this$0 = var1_1;
            super(owner, object);
        }

        public T createObject(Resource resource, EClass eclass) {
            RootElement rootElement = (RootElement)super.createObject(resource, eclass);
            Definitions definitions = null;
            definitions = resource != null ? ModelUtil.getDefinitions((Object)resource) : ModelUtil.getDefinitions((Object)rootElement);
            if (definitions != null) {
                try {
                    definitions.getRootElements().add(rootElement);
                    if (rootElement instanceof Collaboration) {
                        Collaboration collaboration = (Collaboration)rootElement;
                        List processes = ModelUtil.getAllRootElements((Definitions)definitions, Process.class);
                        for (Process process : processes) {
                            if (DIUtils.findBPMNDiagram((BaseElement)process) == null) continue;
                            Participant defaultParticipant = (Participant)Bpmn2ModelerFactory.create((Resource)resource, Participant.class);
                            defaultParticipant.setProcessRef(process);
                            defaultParticipant.setName(String.valueOf(process.getName()) + " Pool");
                            collaboration.getParticipants().add(defaultParticipant);
                            break;
                        }
                    } else if (rootElement instanceof Process) {
                        Process process = (Process)rootElement;
                        List collaborations = ModelUtil.getAllRootElements((Definitions)definitions, Collaboration.class);
                        for (Collaboration collaboration : collaborations) {
                            BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((BaseElement)collaboration);
                            if (bpmnDiagram == null) continue;
                            bpmnDiagram.getPlane().setBpmnElement((BaseElement)process);
                            Participant defaultParticipant = null;
                            for (Participant participant : collaboration.getParticipants()) {
                                if (DIUtils.findBPMNShape((BaseElement)participant) != null || participant.getProcessRef() != null) continue;
                                defaultParticipant = participant;
                                break;
                            }
                            if (defaultParticipant == null) {
                                defaultParticipant = (Participant)Bpmn2ModelerFactory.create((Resource)resource, Participant.class);
                            }
                            defaultParticipant.setProcessRef(process);
                            defaultParticipant.setName(String.valueOf(process.getName()) + " Pool");
                            collaboration.getParticipants().add(defaultParticipant);
                            break;
                        }
                    }
                    ECollections.sort((EList)((EList)definitions.getRootElements()), (Comparator)new RootElementComparator());
                }
                catch (IllegalStateException e) {
                    try {
                        definitions.getRootElements().remove(rootElement);
                    }
                    catch (Exception exception) {
                        throw e;
                    }
                }
            }
            return (T)rootElement;
        }
    }
}

