/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.DefaultResizeBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class ResizeExpandableActivityFeature
extends DefaultResizeBPMNShapeFeature {
    public static final int MARGIN = 20;
    protected Bpmn2Preferences preferences = Bpmn2Preferences.getInstance((EObject)this.getDiagram());

    public ResizeExpandableActivityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void resizeShape(IResizeShapeContext context) {
        ResizeShapeContext resizeShapeContext = (ResizeShapeContext)context;
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        Activity activity = (Activity)BusinessObjectUtil.getFirstElementOfType((PictogramElement)containerShape, Activity.class);
        this.preferences.getShapeStyle((EObject)activity);
        try {
            BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((PictogramElement)containerShape);
            BPMNShape shape = DIUtils.findBPMNShape((BPMNDiagram)bpmnDiagram, (BaseElement)activity);
            if (shape.isIsExpanded()) {
                GraphicsAlgorithm childGa;
                GraphicsAlgorithm parentGa = containerShape.getGraphicsAlgorithm();
                int newWidth = resizeShapeContext.getWidth();
                int newHeight = resizeShapeContext.getHeight();
                SizeCalculator sizeCalc = new SizeCalculator(containerShape);
                int shiftX = sizeCalc.shiftX;
                int shiftY = sizeCalc.shiftY;
                int minWidth = sizeCalc.minWidth;
                int minHeight = sizeCalc.minHeight;
                if (shiftX < 0) {
                    for (PictogramElement pe : FeatureSupport.getContainerChildren((ContainerShape)containerShape)) {
                        childGa = pe.getGraphicsAlgorithm();
                        if (childGa == null) continue;
                        int x = childGa.getX() - shiftX + 20;
                        childGa.setX(x);
                    }
                    resizeShapeContext.setX(resizeShapeContext.getX() + shiftX - 20);
                    shiftX = 20;
                }
                if (shiftY < 0) {
                    for (PictogramElement pe : FeatureSupport.getContainerChildren((ContainerShape)containerShape)) {
                        childGa = pe.getGraphicsAlgorithm();
                        if (childGa == null) continue;
                        int y = childGa.getY() - shiftY + 20;
                        childGa.setY(y);
                    }
                    resizeShapeContext.setY(resizeShapeContext.getY() + shiftY - 20);
                    shiftX = 20;
                }
                if (shiftX < 20) {
                    shiftX = 20;
                }
                if (shiftY < 20) {
                    shiftY = 20;
                }
                minHeight += 40;
                if (newWidth < (minWidth += 40)) {
                    parentGa.setWidth(minWidth);
                }
                if (newWidth < shiftX + minWidth) {
                    int shift = shiftX + minWidth - newWidth;
                    if (shift > shiftX - 20) {
                        shift = shiftX - 20;
                    }
                    if (shift > 0) {
                        for (PictogramElement pe : FeatureSupport.getContainerChildren((ContainerShape)containerShape)) {
                            GraphicsAlgorithm childGa2 = pe.getGraphicsAlgorithm();
                            if (childGa2 == null) continue;
                            int x = childGa2.getX() - shift;
                            childGa2.setX(x);
                        }
                    }
                }
                if (newHeight < minHeight) {
                    parentGa.setHeight(minHeight);
                }
                if (newHeight < shiftY + minHeight) {
                    int shift = shiftY + minHeight - newHeight;
                    if (shift > shiftY - 20) {
                        shift = shiftY - 20;
                    }
                    if (shift > 0) {
                        for (PictogramElement pe : FeatureSupport.getContainerChildren((ContainerShape)containerShape)) {
                            GraphicsAlgorithm childGa3 = pe.getGraphicsAlgorithm();
                            if (childGa3 == null) continue;
                            int y = childGa3.getY() - shift;
                            childGa3.setY(y);
                        }
                    }
                }
                if (resizeShapeContext.getWidth() < minWidth) {
                    resizeShapeContext.setWidth(minWidth);
                }
                if (resizeShapeContext.getHeight() < minHeight) {
                    resizeShapeContext.setHeight(minHeight);
                }
            } else {
                for (PictogramElement pe : FeatureSupport.getContainerDecorators((ContainerShape)containerShape)) {
                    GraphicsAlgorithm childGa = pe.getGraphicsAlgorithm();
                    if (childGa == null) continue;
                    childGa.setWidth(context.getWidth());
                    childGa.setHeight(context.getHeight());
                }
            }
        }
        catch (Exception e) {
            Activator.logError((Exception)e);
        }
        super.resizeShape(context);
    }

    public static class SizeCalculator {
        int shiftX;
        int shiftY;
        int minWidth;
        int minHeight;
        ContainerShape containerShape;
        ShapeStyle ss;

        public SizeCalculator(ContainerShape containerShape) {
            this.setShape(containerShape);
        }

        public void setShape(ContainerShape containerShape) {
            this.containerShape = containerShape;
            Bpmn2Preferences preferences = Bpmn2Preferences.getInstance((Resource)containerShape.eResource());
            this.ss = preferences.getShapeStyle((EObject)BusinessObjectUtil.getFirstBaseElement((PictogramElement)containerShape));
            this.calculate();
        }

        private void calculate() {
            GraphicsAlgorithm ga;
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            this.minWidth = 0;
            this.minHeight = 0;
            for (PictogramElement pe : FeatureSupport.getContainerChildren((ContainerShape)this.containerShape)) {
                ga = pe.getGraphicsAlgorithm();
                if (ga == null) continue;
                int x = ga.getX();
                int y = ga.getY();
                if (x < minX) {
                    minX = x;
                }
                if (y >= minY) continue;
                minY = y;
            }
            this.shiftX = minX;
            this.shiftY = minY;
            for (PictogramElement pe : FeatureSupport.getContainerChildren((ContainerShape)this.containerShape)) {
                ga = pe.getGraphicsAlgorithm();
                if (ga == null) continue;
                int w = ga.getX() - minX + ga.getWidth();
                int h = ga.getY() - minY + ga.getHeight();
                if (w > this.minWidth) {
                    this.minWidth = w;
                }
                if (h <= this.minHeight) continue;
                this.minHeight = h;
            }
            if (this.minWidth <= 0) {
                this.minWidth = this.ss.getDefaultWidth();
            }
            if (this.minHeight <= 0) {
                this.minHeight = this.ss.getDefaultHeight();
            }
        }

        public int getShiftX() {
            return this.shiftX;
        }

        public int getShiftY() {
            return this.shiftY;
        }

        public int getWidth() {
            return this.minWidth;
        }

        public int getHeight() {
            return this.minHeight;
        }
    }
}

