/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.callactivity;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CallableElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.GlobalBusinessRuleTask;
import org.eclipse.bpmn2.GlobalManualTask;
import org.eclipse.bpmn2.GlobalScriptTask;
import org.eclipse.bpmn2.GlobalTask;
import org.eclipse.bpmn2.GlobalUserTask;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.AbstractUpdateBaseElementFeature;
import org.eclipse.bpmn2.modeler.core.features.DefaultResizeBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.features.MultiUpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.activity.AbstractCreateExpandableFlowNodeFeature;
import org.eclipse.bpmn2.modeler.core.features.activity.task.DirectEditTaskFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.activity.AbstractActivityFeatureContainer;
import org.eclipse.bpmn2.modeler.ui.features.activity.DeleteActivityFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.LayoutExpandableActivityFeature;
import org.eclipse.bpmn2.modeler.ui.features.callactivity.AbstractCallGlobalTaskFeatureContainer;
import org.eclipse.bpmn2.modeler.ui.features.callactivity.Messages;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ShowDiagramPageFeature;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class CallActivityFeatureContainer
extends AbstractActivityFeatureContainer {
    protected static final int MARKER_OFFSET = 4;
    protected static final String CALL_ACTIVITY_REF_PROPERTY = "call.activity.ref";
    protected static final String GLOBAL_TASK_SHAPE_PROPERTY = "global.task.shape";

    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && (o instanceof CallActivity || o instanceof GlobalTask);
    }

    public ICreateFeature getCreateFeature(IFeatureProvider fp) {
        return new CreateCallActivityFeature(fp);
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AbstractCallGlobalTaskFeatureContainer.AddCallGlobalTaskFeature(fp);
    }

    @Override
    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return new DeleteActivityFeature(fp){

            @Override
            public void delete(IDeleteContext context) {
                boolean canDeleteCalledActivity;
                PictogramElement pe = context.getPictogramElement();
                CallActivity callActivity = (CallActivity)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, CallActivity.class);
                CallableElement calledActivity = callActivity.getCalledElementRef();
                boolean bl = canDeleteCalledActivity = calledActivity != null;
                if (canDeleteCalledActivity) {
                    Definitions definitions = ModelUtil.getDefinitions((Object)callActivity);
                    TreeIterator iter = definitions.eAllContents();
                    block0: while (iter.hasNext() && canDeleteCalledActivity) {
                        EObject o = (EObject)iter.next();
                        if (o == callActivity || !(o instanceof BaseElement)) continue;
                        for (EObject cr : o.eCrossReferences()) {
                            if (cr != calledActivity) continue;
                            canDeleteCalledActivity = false;
                            continue block0;
                        }
                    }
                }
                super.delete(context);
                if (canDeleteCalledActivity) {
                    BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((BaseElement)calledActivity);
                    if (bpmnDiagram != null) {
                        DIUtils.deleteDiagram((IDiagramBehavior)this.getDiagramBehavior(), (BPMNDiagram)bpmnDiagram);
                    }
                    EcoreUtil.delete((EObject)calledActivity, (boolean)true);
                }
            }
        };
    }

    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return new LayoutExpandableActivityFeature(fp){

            protected int getMarkerContainerOffset() {
                return 4;
            }
        };
    }

    @Override
    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        IUpdateFeature updateFeature = super.getUpdateFeature(fp);
        MultiUpdateFeature multiUpdate = updateFeature instanceof MultiUpdateFeature ? (MultiUpdateFeature)updateFeature : new MultiUpdateFeature(fp);
        multiUpdate.addFeature((IUpdateFeature)new UpdateCallActivityFeature(fp));
        return multiUpdate;
    }

    @Override
    public IResizeShapeFeature getResizeFeature(IFeatureProvider fp) {
        return new DefaultResizeBPMNShapeFeature(fp);
    }

    @Override
    public ICustomFeature[] getCustomFeatures(IFeatureProvider fp) {
        ICustomFeature[] superFeatures = super.getCustomFeatures(fp);
        ICustomFeature[] thisFeatures = new ICustomFeature[1 + superFeatures.length];
        thisFeatures[0] = new ShowDiagramPageFeature(fp);
        int superIndex = 0;
        int thisIndex = 1;
        while (superIndex < superFeatures.length) {
            thisFeatures[thisIndex++] = superFeatures[superIndex];
            ++superIndex;
        }
        return thisFeatures;
    }

    protected static String getCallableElementStringValue(CallableElement element) {
        if (element == null) {
            return "null";
        }
        return element.getClass().getSimpleName();
    }

    protected String getImageId(GlobalTask task) {
        if (task instanceof GlobalBusinessRuleTask) {
            return ImageProvider.IMG_16_BUSINESS_RULE_TASK;
        }
        if (task instanceof GlobalManualTask) {
            return ImageProvider.IMG_16_MANUAL_TASK;
        }
        if (task instanceof GlobalScriptTask) {
            return ImageProvider.IMG_16_SCRIPT_TASK;
        }
        if (task instanceof GlobalUserTask) {
            return ImageProvider.IMG_16_USER_TASK;
        }
        return null;
    }

    public IDirectEditingFeature getDirectEditingFeature(IFeatureProvider fp) {
        return new DirectEditTaskFeature(fp);
    }

    public static class CreateCallActivityFeature
    extends AbstractCreateExpandableFlowNodeFeature<CallActivity> {
        public CreateCallActivityFeature(IFeatureProvider fp) {
            super(fp);
        }

        public String getStencilImageId() {
            return ImageProvider.IMG_16_CALL_ACTIVITY;
        }

        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getCallActivity();
        }
    }

    protected class UpdateCallActivityFeature
    extends AbstractUpdateBaseElementFeature<CallActivity> {
        public UpdateCallActivityFeature(IFeatureProvider fp) {
            super(fp);
        }

        public IReason updateNeeded(IUpdateContext context) {
            PictogramElement element;
            IReason reason = super.updateNeeded(context);
            if (reason.toBoolean()) {
                return reason;
            }
            IPeService peService = Graphiti.getPeService();
            String property = peService.getPropertyValue((PropertyContainer)(element = context.getPictogramElement()), CallActivityFeatureContainer.CALL_ACTIVITY_REF_PROPERTY);
            if (property == null) {
                return Reason.createFalseReason();
            }
            CallActivity callActivity = (CallActivity)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), CallActivity.class);
            String value = CallActivityFeatureContainer.getCallableElementStringValue(callActivity.getCalledElementRef());
            boolean changed = !value.equals(property);
            return changed ? Reason.createTrueReason((String)Messages.CallActivityFeatureContainer_Called_Element_Changed) : Reason.createFalseReason();
        }

        public boolean update(IUpdateContext context) {
            IPeService peService = Graphiti.getPeService();
            IGaService gaService = Graphiti.getGaService();
            ContainerShape container = (ContainerShape)context.getPictogramElement();
            CallActivity callActivity = (CallActivity)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), CallActivity.class);
            Shape globalTaskShape = ShapeDecoratorUtil.getContainedShape((ContainerShape)container, (String)CallActivityFeatureContainer.GLOBAL_TASK_SHAPE_PROPERTY);
            if (callActivity.getCalledElementRef() == null) {
                ShapeDecoratorUtil.hideActivityMarker((ContainerShape)container, (String)"activity.marker.expand");
                if (globalTaskShape != null) {
                    peService.deletePictogramElement((PictogramElement)globalTaskShape);
                }
            } else if (callActivity.getCalledElementRef() instanceof GlobalTask) {
                ShapeDecoratorUtil.hideActivityMarker((ContainerShape)container, (String)"activity.marker.expand");
                GlobalTask globalTask = (GlobalTask)callActivity.getCalledElementRef();
                String imageId = CallActivityFeatureContainer.this.getImageId(globalTask);
                if (imageId != null) {
                    if (globalTaskShape == null) {
                        globalTaskShape = peService.createShape(container, false);
                        peService.setPropertyValue((PropertyContainer)globalTaskShape, CallActivityFeatureContainer.GLOBAL_TASK_SHAPE_PROPERTY, Boolean.toString(true));
                    }
                    Image image = gaService.createImage((GraphicsAlgorithmContainer)globalTaskShape, imageId);
                    gaService.setLocationAndSize((GraphicsAlgorithm)image, 6, 6, 16, 16);
                } else if (globalTaskShape != null) {
                    peService.deletePictogramElement((PictogramElement)globalTaskShape);
                }
            } else if (callActivity.getCalledElementRef() instanceof Process) {
                if (globalTaskShape != null) {
                    peService.deletePictogramElement((PictogramElement)globalTaskShape);
                }
                ShapeDecoratorUtil.showActivityMarker((ContainerShape)container, (String)"activity.marker.expand");
            }
            peService.setPropertyValue((PropertyContainer)container, CallActivityFeatureContainer.CALL_ACTIVITY_REF_PROPERTY, CallActivityFeatureContainer.getCallableElementStringValue(callActivity.getCalledElementRef()));
            return true;
        }
    }
}

